/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _aristaT1_h
#define _aristaT1_h

#include <header.hxx>
#include <v_t1.hxx>

class Triangulo_T1;
struct Arista_T1_dlink;
class Arista_T1{ 
      friend ostream& operator<<(ostream&,Arista_T1&);   
   public:           
      Vertice_T1*     s[2];  // Tablero de los punteros sobre los
                             // vertices.
      Triangulo_T1*     tr;  // Puntero sobre un triangulo que contiene
                             // dicha arista.
      int              ref;  // referencia de la arista.
      Boolean        front;  // si !=0 arista en la frontera:
      Boolean       inters;  // TRUE si la arista esta en la interseccion
                             // de dos superficies.
// Otros datos.
      Arista_T1_dlink*  lk;  // Puntero al link que lo apunta
                             // la lista.

      Arista_T1 () : ref(0),front(0){
             s[0]=NIL; s[1]=NIL; tr=NIL; lk=NIL;inters=FALSE;}
      Arista_T1 (Vertice_T1* a,Vertice_T1* b, Triangulo_T1* tt,\
          int reff=0, Boolean ff=0): ref(reff),front(ff)
            {s[0]=a; s[1]=b;tr=tt;lk=NIL;inters=FALSE;}
      Arista_T1 (Vertice_T1& a,Vertice_T1& b,Triangulo_T1* tt,\
          int reff=0, Boolean ff=0): ref(reff),front(ff)
            {s[0]=&a; s[1]=&b;tr=tt;lk=NIL;inters=FALSE;}
      Arista_T1 (Vertice_T1* a[], Triangulo_T1* tt,int reff=0,\
          Boolean ff=0):ref(reff),front(ff)
            {s[0]=a[0]; s[1]=a[1];tr=tt;lk=NIL;inters=FALSE;}
      Arista_T1 (const Arista_T1& aa) {s[0]=aa.s[0]; s[1]=aa.s[1];
             ref=aa.ref; front=aa.front;
             tr=aa.tr; lk=aa.lk;inters=aa.inters;}
      void write(ostream&);

      void set (Vertice_T1* a, Vertice_T1* b, Triangulo_T1* tt,\
             int reff, Boolean ff) {
                s[0]=a; s[1]=b;
                ref=reff;
                front=ff;
                tr=tt;
                lk=NIL;
                inters=FALSE;
      }
      void set (Vertice_T1& a, Vertice_T1& b, Triangulo_T1* tt,\
             int reff, Boolean ff) {
                s[0]=&a; s[1]=&b;
                ref=reff;
                front=ff;
                tr=tt;
                lk=NIL;
                inters=FALSE;
      }
      void set (const Arista_T1& aa) {s[0]=aa.s[0]; s[1]=aa.s[1];
                ref=aa.ref; front=aa.front;
                tr=aa.tr; lk=aa.lk;inters=aa.inters; }
      void set_lk(Arista_T1_dlink* llk) {lk=llk;}
      Arista_T1& operator=(const Arista_T1& aa) {
                s[0]=aa.s[0]; s[1]=aa.s[1]; ref=aa.ref;
                front=aa.front; tr=aa.tr; lk=aa.lk;
                inters=aa.inters;
                return *this;}
      int operator==(const Arista_T1& aa) {
        int v=0;
        if ((*s[0])==(*(aa.s[0])) && (*s[1])==(*(aa.s[1]))) v=1;
        return v;
      }
      Boolean contiene(Vertice_T1*,Vertice_T1*);
      Boolean frontera() { return front;}
      Boolean interseccion() {return inters;}
      void m_ref();
      int operator<(Arista_T1& aa)
        {return (s[1]==aa.s[0]);}
      int vertice(Vertice_T1*);
      Scalar hf();
      friend R2 dist(Arista_T1,R2,R2);
      friend Scalar angle(Arista_T1*,Arista_T1*);
      friend Scalar  d_arete(const Arista_T1&, const R2&,R2&);
};                  

 

#endif

