/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#include <header.hxx>
#include <metric.hxx>

void escmtr2D(char* name,Metrica* mtr,int nbs,Scalar scale) {
  
  int i,j;
  int paso=0;
#ifdef DEBUG
  cout<<"===================================================="<<endl;
  cout<<"                     METRIC SAVING."<<endl;
  cout<<"===================================================="<<endl;
#endif
  OPEN(escritura, name);
  escritura.setf(ios::scientific,ios::floatfield); 
  for (i=0; i<nbs; i++) {
    for (j=0; j<3; j++) {
      escritura<<""<<setw(15)<<mtr[i].coef[j]*(scale*scale);
    }
    escritura<<"      ";
    if (paso) {
      paso=0; escritura<<endl;}
    else
      paso++;
  }
  if (paso) escritura<<endl; 
  escritura.close(); 
}
