/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#include <header.hxx>


void escsol(int nbs,int nsol, char* name, Scalar* sol) {
  int i,j;
  // escritura de la solucion interpolada en el nuevo mallado.
  OPEN(escr0,name);
  escr0<<"3  "<<nsol<<" "<<nbs<<"  2"<<endl;
  escr0.setf(ios::scientific,ios::floatfield);
  for (i=0; i<nbs; i++) {
    for (j=0; j<nsol; j++) {
      escr0<<""<<setw(15)<<sol[i*nsol+j];
    }
    escr0<<endl;
  }
  escr0.close();

}

