/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _header_h
#define _header_h

#include <stdio.h>
#include <time.h>
//#include <sys/times.h>
#include <fstream.h>
#include <iomanip.h>
#include <float.h>
#include <limits.h>
#include <iostream.h>
//#include <strstream.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


// extern char* form(const char* ...);		// printf format

#define ERROR()\
{cerr<<"Atencion. Memoria insuficiente."<<endl; exit(1);}
 
#define OPENI(ETIQ,NAME)\
ifstream ETIQ (NAME,ios::in);\
if(! ETIQ){cerr<< "erreur open in \""<<NAME<<"\"\n";exit(1);}

#define OPENO(ETIQ,NAME)\
ofstream ETIQ (NAME,ios::out);\
if(! ETIQ){cerr<< "erreur open out \""<<NAME<<"\"\n";exit(1);}

#define OPEN(ETIQ,NAME)\
ofstream ETIQ (NAME,ios::in|ios::out);\
if(! ETIQ){cerr<< "erreur open \""<<NAME<<"\"\n";exit(1);}

#define NEXTLINE(ETIQ) {char c;while ( ETIQ.get(c) && c != '\n');}
  
#if !defined(MIN) 
# define MIN(a,b) ( ((a)<(b)) ? (a) : (b) )
#endif
#if !defined(MAX)
# define MAX(a,b) ( ((a)>(b)) ? (a) : (b) )
#endif
#define SGN(a)((a)>0 ? 1: ((a)==0 ? 0:-1))
//#define square(A) ((A) * (A))

//#define APROGRAMMER(a) {cerr << "A PROGRAMMER "  #a << endl; exit (1) ;}
//#define ERREUR(a,b) {cerr <<"FATAL ERREUR dans "  #a << b << endl; exit (1) ;}

//#ifdef DEBUG 
#if 0
#define DEL(t) cout << "delete: "  #t << endl;
#define CONS(t) cout << "cons: "  #t << endl;
#else
#define DEL(t) 
#define CONS(t) 
#endif

#if defined(__MWERKS__)
#define cerr cout
#endif /* MACINTOSH METROWERKS */

#if !defined(__MWERKS__)
#define FALSE 0
#define TRUE 1
typedef   char  Boolean;
#endif /* MACINTOSH METROWERKS */

#define FATAL 3  
#define WARNING 2
#define REMARQUE 1
#define OK   0
#define REEL float
#define REF  int
#define REFNULLE 0
#define NIL 0
#define BL ' '
#define TAB "\t"

typedef   double Scalar;




#define EPSILON DBL_EPSILON
#define NTROUX  200
#if !defined(PI) 
# define PI 3.14159265358979323846
#endif
#define EPS 1e-20


#endif
