/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _Pilatrar_h
#define _Pilatrar_h

#include <t_t1.hxx>

struct Pila_trar_link {
  Triangulo_T1* t;
  int a;
  Pila_trar_link* sig;
  Pila_trar_link() {t=NIL; a=-1; sig=NIL;}
  Pila_trar_link(Triangulo_T1* tt, int aa) {
    t=tt; a=aa;sig=NIL; }
  void set(Triangulo_T1* tt, int aa) {
    t=tt; a=aa; sig=NIL;}
};

class Pila_trar {
public:
  Pila_trar_link* cab;
  
  Pila_trar() {cab=NIL;}
  Pila_trar(Pila_trar_link* cc) {
    cab=cc; }
  Pila_trar_link* cabeza() {return cab;}
  void in(Pila_trar_link* el) {
    el->sig=cab;
    cab=el; }
  Pila_trar_link* out() {
    Pila_trar_link* aux=NIL;
    if (cab) {
      aux=cab;
      cab=aux->sig;
    }
    return aux;
  }
  int num_elem() {
    Pila_trar_link* aux;
    int cont=0;
    aux=cab;
    while(aux) {cont++;aux=aux->sig;}
    return cont;
  }
  void clear () {
    Pila_trar_link* aux;
    while (cab) {
      aux=cab;
      cab=cab->sig;
      delete aux;
    }
  }
  void operator delete (void* p) {
    if (p) {
      ((Pila_trar*)p)->clear();
      delete p; p=NIL;
    }
  }
  void write(ostream&);
  friend ostream& operator<<(ostream&,Pila_trar&);
};

#endif
