/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#include <params.hxx>

void parameter::write(ostream& os) {
  os <<"Mesh adaptation parameters."<<endl
     <<"==========================="<<endl;
  os <<"  sol:"<<sol<<endl;
  os <<"  nsol:"<<nsol<<endl;
  os <<"  timtr:"<<timtr<<endl;
  os <<"  timesh:"<<timesh<<endl;
  os <<"  sol_interp:"<<sol_interp<<endl;
  os <<"  tinterp:"<<tinterp<<endl;
  os <<"  scale:"<<scale<<endl;
  os <<"  nbt_max:"<<nbt_max<<endl;
  os <<"  err0:"<<err0<<endl;
  os <<"  lmin:"<<lmin/scale<<endl;
  os <<"  lmax:"<<lmax/scale<<endl;
  os <<"  aniso:"<<aniso<<endl;
  os <<"  hwall:"<<hwall/scale<<endl;
  os <<"  refwall:"<<refwall<<endl;
  os <<"  angulo:"<<angulo<<endl;
  os <<"  nit:"<<nit<<endl;
  os <<"  segur:"<<segur<<endl;
  os <<"  reg_ini:"<<reg_ini<<endl;
  os <<"  reg_fin:"<<reg_fin<<endl;
  os <<"  rel_mtr:"<<rel_mtr<<endl;
  os <<"  fluid_NS:"<<fluid_NS<<endl<<endl<<flush;
}
ostream& operator<<(ostream& os, parameter& pp) {pp.write(os); return os;}
void parameter::change(Scalar escala) {
  scale=escala;
  lmin=lmin*scale;
  lmax=lmax*scale;
  hwall=hwall*scale;
}
