// Emacs will be in -*- Mode: c++ -*-
//
// ********** DO NOT REMOVE THIS BANNER **********
//
// SUMMARY: Language for a Finite Element Method
// RELEASE: 2.0     
// USAGE  : You may copy freely these files and use it for    
//          teaching or research. These or part of these may   
//          not be sold or used for a commercial purpose with- 
//          out our consent : fax (33)1 44 27 44 11        
//
// AUTHORS:  D. Bernardi, Y. Darmaillac F. Hecht,    
//           P. Parole O. Pironneau C. Prud'homme
// ORG    :          
// E-MAIL :   pironneau@ann.jussieu.fr     
//
// ORIG-DATE:     June-94
// LAST-MOD:      3-Jan-96 at 13:40:55 by Prud'homme Christophe
//
// DESCRIPTION:  
// DESCRIP-END.
//

#ifndef __Disk_h
#define __Disk_h

#include <triangul.h>
#include <opclass.h> 

class fcts
{
public:   
  float *c1, *b1, *nuyx1,*nuxx1,*nuxy1,*nuyy1, *a21, *a11, *g1, *f1, *p1, *sol1, *fplot;
  ccomplex *c1c, *b1c, *nuyx1c,*nuxx1c,*nuxy1c,*nuyy1c, *a21c, *a11c, *g1c, *f1c, *p1c, *sol1c;
  Acmat c2, b2, nuyx2,nuxx2,nuxy2,nuyy2, a12, a22;
  Acvect g2, p2, f2, sol2;
  
  fcts():c1(NULL),b1(NULL),nuyx1(NULL),nuxx1(NULL),nuxy1(NULL),nuyy1(NULL),
    a21(NULL), a11(NULL), g1(NULL), f1(NULL), p1(NULL),sol1(NULL),fplot(NULL),
    c2(), b2(), nuyx2(),nuxx2(),nuxy2(),nuyy2(), a12(),
    a22(),g2(), p2(), f2(),sol2(){}
};

char* readprog(char *path);
int loadtriangulation(triangulation *, char *);
int savetriangulation(triangulation *, char *);
int saveparam(fcts *param, triangulation* t, char *path, int N=1);
int savefct(creal *, int, char *);
int saveconst(creal, char *);
int loadsol(int, fcts *);
int loadfct(creal *, int, char *);
int readpoints(char *, float*, int);

#endif /* __Disk_h */
