c     -*- mode: FORTRAN -*-
c
c     This file is part of krot,
c     a program for the simulation, assignment and fit of HRLIF spectra.
c
c     Copyright (C) 1994-1998 Arnim Westphal
c     Copyright (C) 1997-1999 Jochen Kpper
c
c     If you use this program for your scientific work, please cite it according to
c     the file CITATION included with this package.
c
c     krot-arnirot
c     a program to calculate rotational resolved vibrational/vibronic bands


#include "arni.h"

c     read parameters from file or stdin
      subroutine input( Jmax, npar,
     *                  swg, swe, swang, itrvec,
     *                  diaalg,
     *                  Jmxcal, dKmax, cutint,
     *                  lifile, asfile,
     *                  fitges, ifit, sigma,
     *                  polori,
     *                  shorti,
     *                  cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *                  frame, kind,
     *                  cBran, polax1,
     *                  symdes,
     *                  lngbar, lstars, lbars, ldash,
     *                  temp1, temp2, weight, nuspsw,
     *                  nuzero,
     *                  divis, Jmxout, normf,
     *                  rotcog, rotcoe, idelta,
     *                  fsrcor, olitmx,
     *                  stflag )

      implicit none

      integer        Jmax, npar

      integer        diaalg
      integer        fitges
      integer        idelta
      integer        ifit(2*npar+2)
      integer        itrvec
      integer        iunout
      integer        Jmxcal
      integer        Jmxout
      integer        dKmax
      integer        normf
      integer        nuspsw(0:3)
      integer        olitmx
      integer        shorti
      integer        stflag
      integer        swe, swg

      real*8         cutint
      real*8         divis
      real*8         fsrcor
      real*8         nuzero
      real*8         polori(3)
      real*8         rotcoe(npar), rotcog(npar)
      real*8         sigma
      real*8         swang(3,2)
      real*8         temp1, temp2, weight

      character*1    cBran(-1:1), polax1(3)
      character*2    symdes(0:1,0:1)
      character*3    no_yes(0:1), off_on(0:1)
      character*5    cRotCg(npar), cRotCe(npar), cEuler(3)
      character*7    cState(2)
      character*9    cDRotC(npar), kind(0:1)
      character*10   frame(0:1)
      character*81   lstars, lbars, ldash
      character*220  lngbar
      character*250  asfile, lifile


      ARNIROT_LAUNCH ( "Launching input." )

c     setup string variables
      call setup ( npar,
     *             cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *             frame, kind,
     *             cBran, polax1,
     *             symdes,
     *             lngbar, lstars, lbars, ldash )

#ifdef DEBUG_NEW_INPUT
      iunout = 11
      open(iunout, file = 'oldInput', status = 'unknown')
#else
      iunout =  0
#endif
c     input all program parameters from standard input
      call paraIO( 5, iunout, 0,
     *             Jmax, npar,
     *             swg, swe, swang, itrvec,
     *             diaalg,
     *             Jmxcal, dKmax, cutint,
     *             lifile, asfile,
     *             fitges, ifit, sigma,
     *             polori,
     *             shorti,
     *             cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *             cBran, polax1,
     *             lbars, ldash,
     *             temp1, temp2, weight, nuspsw,
     *             nuzero,
     *             divis, Jmxout, normf,
     *             rotcog, rotcoe, idelta,
     *             fsrcor, olitmx,
     *             stflag )
#ifdef DEBUG_NEW_INPUT
      close(iunout)
#endif

      return
      end


c-----------------------------------------------------------------------------
      subroutine output( Jmax, dmeval, dmevec, maxnli, npar, ntheli, icqn,
     *                   swg, swe, swang, itrvec,
     *                   diaalg,
     *                   evalg, evale,
     *                   evecgr, evecer, evecgi, evecei,
     *                   Jmxcal, dKmax, cutint,
     *                   lifile, asfile,
     *                   fitges, ifit, sigma,
     *                   polori,
     *                   shorti,
     *                   cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *                   cBran, polax1,
     *                   symdes,
     *                   lngbar, lstars, lbars, ldash,
     *                   lqn, lqn2, intens, frethe, freexp,
     *                   temp1, temp2, weight, nuspsw,
     *                   nuzero,
     *                   divis, Jmxout, normf,
     *                   rotcog, rotcoe, idelta,
     *                   ivpt,
     *                   fsrcor, olitmx,
     *                   stflag )

      implicit none

      integer        Jmax, dmeval, dmevec, maxnli, npar

      integer        diaalg
      integer        fitges
#ifdef DEBUG_NEW_INPUT
      integer        i, l
#endif
      integer        icqn(dmeval,3)
      integer        idelta
      integer        ifit(2*npar+2)
      integer        itrvec
      integer        ivpt(0:Jmax)
      integer        Jmxcal, Jmxout
      integer        dKmax
      integer        lqn(maxnli,6), lqn2(maxnli,6)
      integer        normf
      integer        ntheli
      integer        nuspsw(0:3)
      integer        olitmx
      integer        shorti
      integer        stflag
      integer        swe, swg

      real*8         cutint
      real*8         divis
      real*8         evalg(dmeval), evale(dmeval)
      real*8         evecgi(dmevec), evecei(dmevec)
      real*8         evecgr(dmevec), evecer(dmevec)
      real*8         freexp(maxnli), frethe(maxnli)
      real*8         fsrcor
      real*8         intens(maxnli)
      real*8         nuzero
      real*8         polori(3)
      real*8         rotcoe(npar), rotcog(npar)
      real*8         sigma
      real*8         swang(3,2)
      real*8         temp1, temp2, weight

      character*1    cBran(-1:1), polax1(3)
      character*2    symdes(0:1,0:1)
      character*3    no_yes(0:1), off_on(0:1)
      character*5    cRotCg(npar), cRotCe(npar), cEuler(3)
      character*7    cState(2)
      character*9    cDRotC(npar)
      character*81   lstars, lbars, ldash
      character*220  lngbar
      character*250  asfile, lifile


      ARNIROT_LAUNCH ( "Launching output." )

c-----------------------------------------------------------------------------
c     output (modified parameters and) lines
c-----------------------------------------------------------------------------
c     set flag for (un)performed fit
      if ( shorti .eq. 1 ) write(*,*) fitges

      if ( fitges .eq. 1 ) then
#ifdef DEBUG_NEW_INPUT
c        create new input files if a least squares analysis has been done
         if ( shorti .eq. 0 ) then
            open(10, file = 'oldInput', status = 'unknown')
            open(11, file = 'newInput.long', status = 'unknown')
            call paraIO( 10, 11, 1,
     *                   Jmax, npar,
     *                   swg, swe, swang, itrvec,
     *                   diaalg,
     *                   Jmxcal, dKmax, cutint,
     *                   lifile, asfile,
     *                   fitges, ifit, sigma,
     *                   polori,
     *                   shorti,
     *                   cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *                   cBran, polax1,
     *                   lbars, ldash,
     *                   temp1, temp2, weight, nuspsw,
     *                   nuzero,
     *                   divis, Jmxout, normf,
     *                   rotcog, rotcoe, idelta,
     *                   fsrcor, olitmx,
     *                   stflag )
            close(10)
            close(11)
            write(*,'(a)') '\n\nNew input file (newInput.long)  created.'
c           convert delta values back to absolute rotational constants
            if ( idelta .eq. 1 ) call delabs( rotcog, rotcoe, npar, 2 )
         end if
         open(12, file = 'newInput.short', status = 'unknown')
         write(12,'(a)') '-1'
         call paraIO( 0, 12, 2,
     *                Jmax, npar,
     *                swg, swe, swang, itrvec,
     *                diaalg,
     *                Jmxcal, dKmax, cutint,
     *                lifile, asfile,
     *                fitges, ifit, sigma,
     *                polori,
     *                shorti,
     *                cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *                cBran, polax1,
     *                lbars, ldash,
     *                temp1, temp2, weight, nuspsw,
     *                nuzero,
     *                divis, Jmxout, normf,
     *                rotcog, rotcoe, idelta,
     *                fsrcor, olitmx,
     *                stflag )
         do i = 1, ntheli, 1
           if ( freexp(i) .ne. 0 )
     *          write(12,*) (lqn(i,l), l = 1,6,1), freexp(i)
         end do
         close(12)
         if ( shorti .eq. 0 ) write(*,'(a)') 'New input file (newInput.short) created.'
#endif
         call paraIO( 0, 6, 2,
     *                Jmax, npar,
     *                swg, swe, swang, itrvec,
     *                diaalg,
     *                Jmxcal, dKmax, cutint,
     *                lifile, asfile,
     *                fitges, ifit, sigma,
     *                polori,
     *                shorti,
     *                cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *                cBran, polax1,
     *                lbars, ldash,
     *                temp1, temp2, weight, nuspsw,
     *                nuzero,
     *                divis, Jmxout, normf,
     *                rotcog, rotcoe, idelta,
     *                fsrcor, olitmx,
     *                stflag )
      end if

c     output lines in DESCENDING frequency order or unsorted (new IO)
      call linout( maxnli, ntheli,
     *             lifile,
     *             shorti,
     *             cBran,
     *             lstars,
     *             lqn, lqn2, intens, frethe, freexp,
     *             divis, fsrcor, Jmxout, normf )

      if ( shorti .eq. 0 ) write(*,'(a)') lstars

#ifdef DEBUG
      call sdebug( Jmax, dmeval, dmevec, ntheli,
     *             Jmxcal, icqn, lifile,
     *             evalg, evale,
     *             evecgr, evecer, evecgi, evecei,
     *             symdes,
     *             lngbar,
     *             ivpt )
#endif

      return
      end
