// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.



#ifndef KROT_DRAWAREA_INLINE_H
#define KROT_DRAWAREA_INLINE_H



#include "dataset.h"
#include "krotData.h"



inline void DrawArea::checkStartFreq()
{
    KROT_LAUNCH_VERBOSE( "Launching DrawArea::checkStartFreq" );
    if( start < krotData->start() ) {
	start =  krotData->start();
    } else {
	if( start > krotData->stop() - width() ) {
	    start =  krotData->stop() - width();
	} else {
	    return;
	}
    }
    repaint();
    return;
}



inline int DrawArea::computeIntensity( const DataSet& set, const int64_t freq ) const
{
    double val = set[ freq ];
    int avg = krotData->averaging() > 1,
	avg2 = avg / 2;
    if( avg > 1 ) {
	for( int64_t i = freq - avg2;
	     i <= freq + avg - avg2; i++ )
	    if( set[ i ] > val )
		val = set[ i ];
    }
    return  val < 0.0 ? ( height() - 1 ) : ( val >= height() ? 0 : static_cast< int > ( height() - 1 - val ) );
}



inline void DrawArea::setDisplayRange( const DataRange& r )
    // Since we might get a temporary object from WorkArea::limits, we need to copy the range !
{
    range = r;
    if( start < r.start || start > r.stop ) {
	start = r.start;
	min = r.min;
    }
}



#endif



//* Local Variabes:
//* mode: C++
//* c-file-style: "Stroustrup"
//* End:
