// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.



#ifndef KROT_UTIL_INLINE_H
#define KROT_UTIL_INLINE_H



#include "krot.h"

#include <qcheckbox.h>
#include <qfont.h>
#include <qlabel.h>

#include <cstdlib>



inline bool ChkLblFloated::isChecked() const
{
    return mark->isChecked();
}



inline void ChkLblFloated::setChecked( const bool check )
{
    mark->setChecked( check );
    return;
}



inline void ChkLblFloated::setEnabled( const bool enabled )
{
    mark->setEnabled( enabled );
    edit->setEnabled( enabled );
    return;
}



inline void ChkLblFloated::setLabelFont( const QFont& font )
{
    // mark->setFontPropagation( true );
    mark->setFont( font );
    return;
}



inline void ChkLblFloated::setValue( const double value )
{
    edit->setValue( value );
    return;
}



inline QSize ChkLblFloated::sizeHint () const
{
    int h = edit->fontMetrics().height();
    int w = edit->fontMetrics().width( "00000.000" );
    if ( edit->frame() ) {
	w += 8;
	h += 8;
    } else {
	w += 4;
	h += 4;
    }
    // QCheckBox
    w += mark->sizeHint().width();
    if ( h < mark->sizeHint().height() )
	h = mark->sizeHint().height();
    KROT_DEBUG2_VERBOSE( "ChkLblFloated::sizeHint: w = %d, h = %d", w, h );
    return QSize( w, h );
}



inline void ChkLblFloated::slotToggled( bool on )
{
    emit toggled( on );
    return;
}



inline double ChkLblFloated::value() const
{
    return edit->value();
}



inline Floated::Floated( QWidget *parent, const char *name )
{
    Floated( 3, 0.0, parent, name );
    return;
}



inline Floated::Floated( const double value, QWidget *parent, const char *name )
{
    Floated( 3, value, parent, name );
    return;
}



inline void Floated::setValue( const double value )
{
    static QString text;
    text.sprintf( "%.*f", precision, value );
    validateAndSet( text, 0, 0, 0 );
    return;
}



inline QSize Floated::sizeHint() const
{
    int h = fontMetrics().height();
    int w = fontMetrics().width( "00000.000" );
    if ( frame() ) {
	w += 8;
	h += 8;
    } else {
	w += 4;
	h += 4;
    }
    KROT_DEBUG2_VERBOSE( "Floated::sizeHint: w = %d, h = %d", w, h );
    return QSize( w, h );
}



inline double Floated::value() const
{
    return atof( text() );
}



inline void LblFloated::setEnabled( bool enable )
{
    edit->setEnabled( enable );
    return;
}



inline void LblFloated::setLabelFont( const QFont& font )
{
    label->setFont( font );
    return;
}



inline void LblFloated::setValue( const double value )
{
    edit->setValue( value );
    return;
}



inline QSize LblFloated::sizeHint() const
{
    // QLineEdit
    int h = edit->fontMetrics().height();
    int w = edit->fontMetrics().width( "00000.000" );
    if ( edit->frame() ) {
	w += 8;
	h += 8;
    } else {
	w += 4;
	h += 4;
    }
    // QLabel
    w += label->sizeHint().width();
    if ( h < label->sizeHint().height() )
	h = label->sizeHint().height();
    KROT_DEBUG2_VERBOSE( "LblFloated::sizeHint: w = %d, h = %d", w, h );
    return QSize( w, h );
}



inline double LblFloated::value() const
{
    return edit->value();
}



inline void LblInted::setValue( const int value )
{
    edit->setValue( value );
    return;
}



inline void LblInted::setLabelFont( const QFont& font )
{
    label->setFont( font );
    return;
}



inline QSize LblInted::sizeHint() const
{
    // QLineEdit
    int h = edit->fontMetrics().height();
    int w = edit->fontMetrics().width( "000000" );
    if ( edit->frame() ) {
	w += 8;
	h += 8;
    } else {
	w += 4;
	h += 4;
    }
    // QLabel
    w += label->sizeHint().width();
    if ( h < label->sizeHint().height() )
	h = label->sizeHint().height();
    KROT_DEBUG2_VERBOSE( "LblFloated::sizeHint: w = %d, h = %d", w, h );
    return QSize( w, h );
}



inline int LblInted::value() const
{
    return edit->value();
}



inline Inted::Inted( QWidget *parent, const char *name )
{
    Inted( INT_MIN, INT_MAX, 0, parent, name );
    return;
}



inline Inted::Inted( const int value, QWidget *parent, const char *name )
{
    Inted( INT_MIN, INT_MAX, value, parent, name );
    return;
}



inline void Inted::setValue( const int value )
{
    static QString text;
    text.sprintf( "%d", value );
    validateAndSet( text, 0, 0, 0 );
    return;
}



inline QSize Inted::sizeHint() const
{
    int h = fontMetrics().height();
    int w = fontMetrics().width( "000000" );
    if ( frame() ) {
	w += 8;
	h += 8;
    } else {
	w += 4;
	h += 4;
    }
    KROT_DEBUG2_VERBOSE( "Inted::sizeHint: w = %d, h = %d", w, h );
    return QSize( w, h );
}



inline int Inted::value() const
{
    return atoi( text() );
}



#endif



//* Local Variables:
//* mode: C++
//* c-file-style: "Stroustrup"
//* End:
