/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> SP_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/
#include        "com_iar.h"





short CAlloc1Dim( char **ptpt, long sz ) ;
void CFree1Dim( char **ptpt ) ;
short SAlloc1Dim( short **ptpt, long sz ) ;
void SFree1Dim( short **ptpt ) ;
short LAlloc1Dim( long **ptpt, long sz ) ;
void LFree1Dim( long **ptpt ) ;
short LReAlloc1Dim( long **ptpt, long sz ) ;
short FAlloc1Dim( float **ptpt, long sz ) ;
void FFree1Dim( float **ptpt ) ;
short DAlloc1Dim( double **ptpt, long sz ) ;
short DReAlloc1Dim( double **ptpt, long sz ) ;
void DFree1Dim( double **ptpt ) ;

short FAlloc2Dim( float ***ptptpt, long sz1, long sz2 ) ;
void FFree2Dim( float ***ptptpt, long sz1 ) ;
short DAlloc2Dim( double ***ptptpt, long sz1, long sz2 ) ;
void DFree2Dim( double ***ptptpt, long sz1 ) ;

short FAlloc3Dim( float ****ptptptpt, long sz1, long sz2, long sz3 ) ;
void FFree3Dim( float ****ptptptpt, long sz1, long sz2 ) ;
short DAlloc3Dim( double ****ptptptpt, long sz1, long sz2, long sz3 ) ;
void DFree3Dim( double ****ptptptpt, long sz1, long sz2 ) ;




/*ALLOCATE CHARACTER SPACE IN ONE DIMENSION*/
short CAlloc1Dim( char **ptpt, long sz )
   {

/*FREE SPACE ASSOCIATED WITH NON-NULL POINTER*/
   if( *ptpt != NULL )
      CFree1Dim( ptpt ) ;

/*ALLOCATE CHARACTER SPACE IN ONE DIMENSION*/
   if( (*ptpt = (char *)malloc( (unsigned)(sz * sizeof( char )) )) == NULL )
      return( -1 ) ;

/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*FREE CHARACTER SPACE IN ONE DIMENSION*/
void CFree1Dim( char **ptpt )
   {

/*FREE CHARACTER SPACE IN ONE DIMENSION*/
   if( *ptpt != NULL )
      free( (char *)*ptpt ) ;
   *ptpt = NULL ;
   }














/*ALLOCATE SHORT SPACE IN ONE DIMENSION*/
short SAlloc1Dim( short **ptpt, long sz )
   {

/*FREE SPACE ASSOCIATED WITH NON-NULL POINTER*/
   if( *ptpt != NULL )
      SFree1Dim( ptpt ) ;

/*ALLOCATE SHORT SPACE IN ONE DIMENSION*/
   if( (*ptpt = (short *)malloc( (unsigned)(sz * sizeof( short )) )) == NULL )
      return( -1 ) ;

/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*FREE SHORT SPACE IN ONE DIMENSION*/
void SFree1Dim( short **ptpt )
   {

/*FREE SHORT SPACE IN ONE DIMENSION*/
   if( *ptpt != NULL )
      free( (char *)*ptpt ) ;
   *ptpt = NULL ;
   }














/*ALLOCATE INTEGER SPACE IN ONE DIMENSION*/
short LAlloc1Dim( long **ptpt, long sz )
   {

/*FREE SPACE ASSOCIATED WITH NON-NULL POINTER*/
   if( *ptpt != NULL )
      LFree1Dim( ptpt ) ;

/*ALLOCATE INTEGER SPACE IN ONE DIMENSION*/
   if( (*ptpt = (long *)malloc( (unsigned)(sz * sizeof( long )) )) == NULL )
      return( -1 ) ;

/*RETURN SUCCESS*/
   return( 1 ) ;
   }






/*REALLOCATE INTEGER SPACE IN ONE DIMENSION*/
short LReAlloc1Dim( long **ptpt, long sz )
   {

/*ALLOCATE INTEGER SPACE IN ONE DIMENSION*/
   if( (*ptpt = (long *)realloc( *ptpt, (unsigned)(sz * sizeof( long )) )) == NULL )
      return( -1 ) ;

/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*FREE INTEGER SPACE IN ONE DIMENSION*/
void LFree1Dim( long **ptpt )
   {

/*FREE INTEGER SPACE IN ONE DIMENSION*/
   if( *ptpt != NULL )
      free( (char *)*ptpt ) ;
   *ptpt = NULL ;
   }














/*ALLOCATE FLOAT SPACE IN ONE DIMENSION*/
short FAlloc1Dim( float **ptpt, long sz )
   {

/*FREE SPACE ASSOCIATED WITH NON-NULL POINTER*/
   if( *ptpt != NULL )
      FFree1Dim( ptpt ) ;

/*ALLOCATE FLOAT SPACE IN ONE DIMENSION*/
   if( (*ptpt = (float *)malloc( (unsigned)(sz * sizeof( float )) )) == NULL )
      return( -1 ) ;

/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*FREE FLOAT SPACE IN ONE DIMENSION*/
void FFree1Dim( float **ptpt )
   {

/*FREE FLOAT SPACE IN ONE DIMENSION*/
   if( ptpt != NULL )
      free( (char *)*ptpt ) ;
   *ptpt = NULL ;
   }














/*ALLOCATE DOUBLE SPACE IN ONE DIMENSION*/
short DAlloc1Dim( double **ptpt, long sz )
   {

/*FREE SPACE ASSOCIATED WITH NON-NULL POINTER*/
   if( *ptpt != NULL )
      DFree1Dim( ptpt ) ;

/*ALLOCATE DOUBLE SPACE IN ONE DIMENSION*/
   if( (*ptpt = (double *)malloc( (unsigned)(sz * sizeof( double )) )) == NULL )
      return( -1 ) ;

/*RETURN SUCCESS*/
   return( 1 ) ;
   }






/*REALLOCATE INTEGER SPACE IN ONE DIMENSION*/
short DReAlloc1Dim( double **ptpt, long sz )
   {

/*ALLOCATE INTEGER SPACE IN ONE DIMENSION*/
   if( (*ptpt = (double *)realloc( *ptpt, (unsigned)(sz * sizeof( double )) )) == NULL )
      return( -1 ) ;

/*RETURN SUCCESS*/
   return( 1 ) ;
   }






/*FREE DOUBLE SPACE IN ONE DIMENSION*/
void DFree1Dim( double **ptpt )
   {

/*FREE DOUBLE SPACE IN ONE DIMENSION*/
   if( *ptpt != NULL )
      free( (char *)*ptpt ) ;
   *ptpt = NULL ;
   }














/*ALLOCATE FLOAT SPACE IN TWO DIMENSIONS -> NOT GUARENTEED TO BE CONTIGIOUS*/
short FAlloc2Dim( float ***ptptpt, long sz1, long sz2 )
   {
   long cnt, cts ;


/*ALLOCATE SPACE FOR ARRAY OF POINTERS OF SIZE FIRST DIMENSION*/
   if( (*ptptpt = (float **)malloc( (unsigned)(sz1 * sizeof( float * )) )) == NULL )
      return( -1 ) ;


/*LOOP THROUGH FIRST DIMENSION AND ALLOCATE SPACE FOR EACH POINTER OF SIZE SECOND DIMENSION*/
   for( cnt = 0; cnt < sz1; cnt++ )
      {
      if( (*(*ptptpt + cnt) = (float *)malloc( (unsigned)(sz2 * sizeof( float )) )) == NULL )
         return( -1 ) ;
      else
         for( cts = 0; cts < sz2; cts++ )
            *(*(*ptptpt + cnt) + cts) = 0.0 ;
      }

/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*FREE FLOAT SPACE IN TWO DIMENSIONS*/
void FFree2Dim( float ***ptptpt, long sz1 )
   {
   long cnt ;

/*LOOP THROUGH FIRST DIMENSION AND FREE SPACE FOR EACH POINTER OF SIZE SECOND DIMENSION*/
   for( cnt = 0; cnt < sz1; cnt++ )
      {
      if( *(*ptptpt + cnt) != NULL )
         free( (char *)*(*ptptpt + cnt) ) ;
      *(*ptptpt + cnt) = NULL ;
      }

/*FREE SPACE FOR ARRAY OF POINTERS OF SIZE FIRST DIMENSION*/
   if( *ptptpt != NULL )
      free( (char *)*ptptpt ) ;
   *ptptpt = NULL ;
   }














/*ALLOCATE DOUBLE SPACE IN TWO DIMENSIONS -> NOT GUARENTEED TO BE CONTIGIOUS*/
short DAlloc2Dim( double ***ptptpt, long sz1, long sz2 )
   {
   long cnt, cts ;


/*ALLOCATE SPACE FOR ARRAY OF POINTERS OF SIZE FIRST DIMENSION*/
   if( (*ptptpt = (double **)malloc( (unsigned)(sz1 * sizeof( double * )) )) == NULL )
      return( -1 ) ;


/*LOOP THROUGH FIRST DIMENSION AND ALLOCATE SPACE FOR EACH POINTER OF SIZE SECOND DIMENSION*/
   for( cnt = 0; cnt < sz1; cnt++ )
      {
      if( (*(*ptptpt + cnt) = (double *)malloc( (unsigned)(sz2 * sizeof( double )) )) == NULL )
         return( -1 ) ;
      else
         for( cts = 0; cts < sz2; cts++ )
            *(*(*ptptpt + cnt) + cts) = 0.0 ;
      }


/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*FREE DOUBLE SPACE IN TWO DIMENSIONS*/
void DFree2Dim( double ***ptptpt, long sz1 )
   {
   long cnt ;


/*LOOP THROUGH FIRST DIMENSION AND FREE SPACE FOR EACH POINTER OF SIZE SECOND DIMENSION*/
   for( cnt = 0; cnt < sz1; cnt++ )
      {
      if( *(*ptptpt + cnt) != NULL )
         free( (char *)*(*ptptpt + cnt) ) ;
      *(*ptptpt + cnt) = NULL ;
      }


/*FREE SPACE FOR ARRAY OF POINTERS OF SIZE FIRST DIMENSION*/
   if( *ptptpt != NULL )
      free( (char *)*ptptpt ) ;
   *ptptpt = NULL ;
   }














/*ALLOCATE FLOAT SPACE IN THREE DIMENSIONS -> NOT GUARENTEED TO BE CONTIGIOUS*/
short FAlloc3Dim( float ****ptptptpt, long sz1, long sz2, long sz3 )
   {
   long cnt, cts ;


/*ALLOCATE SPACE FOR ARRAY OF POINTERS TO ARRAY OF POINTERS OF SIZE FIRST DIMENSION*/
   if( (*ptptptpt = (float ***)malloc( (unsigned)(sz1 * sizeof( float ** )) )) == NULL )
      return( -1 ) ;



/*LOOP THROUGH SIZE OF FIRST DIMENSION*/
   for( cnt = 0; cnt < sz1; cnt++ )
      {


   /*ALLOCATE SPACE FOR EACH POINTER ARRAY OF SIZE SECOND DIMENSION*/
      if( (*(*ptptptpt + cnt) = (float **)malloc( (unsigned)(sz2 * sizeof( float * )) )) == NULL )
         return( -1 ) ;


   /*LOOP THROUGH SIZE OF SECOND DIMENSION AND ALLOCATE SPACE FOR EACH POINTER OF SIZE THIRD DIMENSION*/
      for( cts = 0; cts < sz2; cts++ )
         if( (*(*(*ptptptpt + cnt) + cts) =
               (float *)malloc( (unsigned)(sz3 * sizeof( float )) )) == NULL )
            return( -1 ) ;
      }


/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*FREE FLOAT SPACE IN THREE DIMENSIONS*/
void FFree3Dim( float ****ptptptpt, long sz1, long sz2 )
   {
   long cnt, cts ;


/*LOOP THROUGH SIZE OF FIRST DIMENSION*/
   for( cnt = 0; cnt < sz1; cnt++ )
      {


   /*LOOP THROUGH SIZE OF SECOND DIMENSION*/
      for( cts = 0; cts < sz2; cts++ )
         {

      /*FREE SPACE FOR EACH POINTER OF SIZE THIRD DIMENSION*/
         if( *(*(*ptptptpt + cnt) + cts) != NULL )
            free( (char *)*(*(*ptptptpt + cnt) + cts) ) ;
         *(*(*ptptptpt + cnt) + cts) = NULL ;
         }


   /*FREE SPACE FOR EACH POINTER ARRAY OF SIZE SECOND DIMENSION*/
      if( *(*ptptptpt + cnt) != NULL )
         free( (char *)*(*ptptptpt + cnt) ) ;
      *(*ptptptpt + cnt) = NULL ;
      }



/*FREE SPACE FOR ARRAY OF POINTERS TO ARRAY OF POINTERS OF SIZE FIRST DIMENSION*/
   if( *ptptptpt != NULL )
      free( (char *)*ptptptpt ) ;
   *ptptptpt = NULL ;
   }














/*ALLOCATE DOUBLE SPACE IN THREE DIMENSIONS -> NOT GUARENTEED TO BE CONTIGIOUS*/
short DAlloc3Dim( double ****ptptptpt, long sz1, long sz2, long sz3 )
   {
   long cnt, cts ;



/*ALLOCATE SPACE FOR ARRAY OF POINTERS TO ARRAY OF POINTERS OF SIZE FIRST DIMENSION*/
   if( (*ptptptpt = (double ***)malloc( (unsigned)(sz1 * sizeof( double ** )) )) == NULL )
      return( -1 ) ;




/*LOOP THROUGH SIZE OF FIRST DIMENSION*/
   for( cnt = 0; cnt < sz1; cnt++ )
      {


   /*ALLOCATE SPACE FOR EACH POINTER ARRAY OF SIZE SECOND DIMENSION*/
      if( (*(*ptptptpt + cnt) = (double **)malloc( (unsigned)(sz2 * sizeof( double * )) )) == NULL )
         return( -1 ) ;


   /*LOOP THROUGH SIZE OF SECOND DIMENSION AND ALLOCATE SPACE FOR EACH POINTER OF SIZE THIRD DIMENSION*/
      for( cts = 0; cts < sz2; cts++ )
         if( (*(*(*ptptptpt + cnt) + cts) =
               (double *)malloc( (unsigned)(sz3 * sizeof( double )) )) == NULL )
            return( -1 ) ;
      }



/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*FREE DOUBLE SPACE IN THREE DIMENSIONS*/
void DFree3Dim( double ****ptptptpt, long sz1, long sz2 )
   {
   long cnt, cts ;


/*LOOP THROUGH SIZE OF FIRST DIMENSION*/
   for( cnt = 0; cnt < sz1; cnt++ )
      {

   /*LOOP THROUGH SIZE OF SECOND DIMENSION*/
      for( cts = 0; cts < sz2; cts++ )
         {

      /*FREE SPACE FOR EACH POINTER OF SIZE THIRD DIMENSION*/
         if( *(*(*ptptptpt + cnt) + cts) != NULL )
            free( (char *)*(*(*ptptptpt + cnt) + cts) ) ;
         *(*(*ptptptpt + cnt) + cts) = NULL ;
         }


   /*FREE SPACE FOR EACH POINTER ARRAY OF SIZE SECOND DIMENSION*/
      if( *(*ptptptpt + cnt) != NULL )
         free( (char *)*(*ptptptpt + cnt) ) ;
      *(*ptptptpt + cnt) = NULL ;
      }


/*FREE SPACE FOR ARRAY OF POINTERS TO ARRAY OF POINTERS OF SIZE FIRST DIMENSION*/
   if( *ptptptpt != NULL )
      free( (char *)*ptptptpt ) ;
   *ptptptpt = NULL ;
   }




