/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#ifndef THEME_H
#define THEME_H

#include "qobject.h"

class Theme: public QObject{
	Q_OBJECT
public:
	Theme();
	~Theme();
	void	save(QString file);
	void 	load(QString file);
	void 	applyTheme();
	void 	setToDefault();
	void 	setColorScheme(QString s);
	void 	setSoundScheme(QString s);
	void 	setWallpaper(QString tit,int index);
	void 	setWallpaperArg(int desktop,int typ, bool arg);
	QString getColorScheme();
	QString getSoundScheme();
	QString getWallpaper(int index);
	bool 	getWallpaperArg(int desktop,int typ);
	bool 	changed;

private:
	QString		colorScheme;
	QString		colorScheme_old;
	QString		soundScheme;
	QString		soundScheme_old;
	bool 		gfx_change;
	QString		desktop_gfx[10];
	bool		desktop_arg[10][3];
	
signals:
	void		themeLoaded();
};

#endif


