#include "AddNoRet.moc"
#include <qwidget.h>
#include <qlabel.h>
#include <klocale.h>
#include <qtooltip.h>
#include <kapp.h>

AddNoRet::AddNoRet(QWidget * parent=0, char * wname=0): QWidget(parent, wname)
{
	int y;
	this->setCaption(i18n("Add non-retrievable file/directory"));
	resize(320,80);
	setFixedSize(320,80);
	filename=new InputFileCtl(i18n("&Filename:"),0,false,0,this);
	filename->setGeometry(5,5,width()-10,filename->height());
	y=5+filename->height()+5;
	QToolTip::add(filename,i18n("End the filename with a / to indicate it is\nan entire directory; no file in this directory\nwill be retrievable."));
	ok=new QPushButton(i18n("&OK"),this);
	ok->setAutoDefault(true);
	ok->setDefault(true);
	ok->setGeometry(5,y,this->width()/2-10,ok->height());
	connect(ok,SIGNAL(clicked()),SLOT(okButtonPressed()));
	cancel=new QPushButton(i18n("&Cancel"),this);
	connect(cancel,SIGNAL(clicked()),SLOT(cancelButtonPressed()));
	cancel->setGeometry(this->width()/2+5,y,this->width()/2-10,cancel->height());
	show();
}
AddNoRet::~AddNoRet()
{
	delete filename;
	delete ok;
	delete cancel;
}
void AddNoRet::okButtonPressed()
{
	char *f=(char *)filename->text();
	if(f!=0)
		emit noRetAdded(f);
	delete this;
}
void AddNoRet::cancelButtonPressed()
{
	delete this;
}
