/*
 * KBatMon - Copyright 1999 Russ Steffen <rsteffen@ia.net>
 * 
 * Released under the terms of the GNU General Public License
 * 
 * 
 * $Id: kbatmon.cc,v 1.17 1999/01/15 06:08:47 russ Exp $
 * 
 * $Log: kbatmon.cc,v $
 * Revision 1.17  1999/01/15 06:08:47  russ
 * Added file headers.
 *
 * 
 */

#include "kbatmon.h"
#include "kbatmonconfigdlg.h"
#include "version.h"

#include <kapp.h>
#include <kwm.h>
#include <kiconloader.h>
#include <kmsgbox.h>

#include <qcolor.h>
#include <qevent.h>
#include <qpainter.h>
#include <qtooltip.h>
#include <qpopmenu.h>
#include <qcursor.h>
#include <qpainter.h>
#include <qpaintdevice.h>

#include <iostream.h>

KBatMon::KBatMon() : QWidget(0), APM(0), status_dlg(0)
{
    // Set up the APM interface
    APM = new APMInterface;
    connect( APM, SIGNAL(update()), this, SLOT(apmUpdate()) );

    // Popup menu
    popup = new QPopupMenu;

    popup->insertItem( i18n("Status"), this, SLOT(openStatusWindow()), 0, Status_ID );
    popup->insertItem( i18n("Configure"), this, SLOT(openConfigDialog()), 0, Config_ID );
    popup->insertSeparator();
    popup->insertItem( i18n("Suspend"), APM, SLOT(suspend()), 0, Suspend_ID );
    popup->insertItem( i18n("Standby"), APM, SLOT(standby()), 0, Standby_ID );
    popup->insertSeparator();
//    popup->insertItem( i18n("Help..."), this, SLOT(help()), 0, Help_ID );
    popup->insertItem( i18n("About..."), this, SLOT(about()), 0, About_ID );
    popup->insertSeparator();
    popup->insertItem( i18n("Exit"), this, SLOT(shutdown()), 0, Exit_ID );

    connect( &config, SIGNAL(dockInPanelChanged(bool)), this, SLOT(dockInPanelChanged(bool)) );

    if( config.getDockInPanel() ) {
        KWM *kwm = new KWM;
        kwm->setDecoration(winId(), KWM::noDecoration);
        kwm->setDockWindow(winId());
        delete kwm;
    } else {
        KWM *kwm = new KWM;
        kwm->setDecoration(winId(), KWM::tinyDecoration);
        delete kwm;

        setFixedSize(20,20);
    }


    status_dlg = new KBatMonStatus( APM, &config );

}


KBatMon::~KBatMon()
{
    if( APM )
        delete APM;
}

void KBatMon::mousePressEvent( QMouseEvent *e )
{
    popup->exec(QCursor::pos());
}

void KBatMon::apmUpdate() 
{
    QString tipText;

    tipText.sprintf( i18n("Battery : %d%%"), APM->getBatteryPercentage() );

    if( APM->getACLineStatus() ) {
        tipText += i18n(", on AC Power");
    }
    
    QToolTip::add( this, tipText );

    // force the widget to repaint
    update();
}

void KBatMon::dockInPanelChanged( bool newValue )
{
    if( newValue == true ) {
       hide();
       
       recreate( 0, 0, QPoint(0,0) );
       
       KWM *kwm = new KWM;
       kwm->setDecoration(winId(), KWM::noDecoration);
       kwm->setDockWindow(winId());
       delete kwm;
       
       show();
    } else {
       hide();
       
       recreate( 0, 0, QPoint(0,0) );
       
       KWM *kwm = new KWM;
       kwm->setDecoration(winId(), KWM::tinyDecoration );
       delete kwm;
       
       show();
    }

}

void KBatMon::help()
{

}

void KBatMon::about()
{
   KMsgBox::message(0, i18n("About KBatMon"), 
		    i18n("KBatMon - KDE Battery Monitor\n"
			 "Version " KBATMON_VERSION "\n"
			 "Copyright 1999 Russ Steffen <rsteffen@ia.net>\n\n"
			 "Released under the terms of the\n"
			 "GNU General Public License" ) );
   
   
}

void KBatMon::shutdown()
{
    kapp->quit();
}

void KBatMon::openStatusWindow()
{
    if( !status_dlg->isVisible() )
        status_dlg->show();
}

void KBatMon::suspend()
{
   APM->suspend();
}

void KBatMon::openConfigDialog()
{
   KBatMonConfigDialog *configDlg;
   
   configDlg = new KBatMonConfigDialog(config);
   
   configDlg->exec();
   
   delete configDlg;
}



void KBatMon::paintEvent( QPaintEvent * ) 
{
    QPainter p( this );
    QString icon;

    if( APM->getACLineStatus() ) {
        // on AC power
        icon = "plug.xpm";
    } else {
        // on battery power
        int bat_percent = APM->getBatteryPercentage();

        if( bat_percent >= 0 && bat_percent < 10 )
            icon = "bat-0.xpm";
        else if ( bat_percent >= 10 && bat_percent < 20 )
            icon = "bat-10.xpm";
        else if ( bat_percent >= 20 && bat_percent < 30 )
            icon = "bat-20.xpm";
        else if ( bat_percent >= 30 && bat_percent < 40 )
            icon = "bat-30.xpm";
        else if ( bat_percent >= 40 && bat_percent < 50 )
            icon = "bat-40.xpm";
        else if ( bat_percent >= 50 && bat_percent < 60 )
            icon = "bat-50.xpm";
        else if ( bat_percent >= 60 && bat_percent < 70 )
            icon = "bat-60.xpm";
        else if ( bat_percent >= 70 && bat_percent < 80 )
            icon = "bat-70.xpm";
        else if ( bat_percent >= 80 && bat_percent < 90 )
            icon = "bat-80.xpm";
        else if ( bat_percent >= 90 && bat_percent < 100 )
            icon = "bat-90.xpm";
        else if ( bat_percent == 100 )
            icon = "bat-100.xpm";

    }

    QPixmap pm( Icon(icon) );

    bitBlt( this,
            (width()-pm.width())/2,
            (height()-pm.height())/2, &pm,
            0, 0,
            pm.width(), pm.height() );

}

