/*
 * KBatMon - Copyright 1999 Russ Steffen <rsteffen@ia.net>
 *
 * Released under the terms of the GNU General Public License
 *
 *
 * $Id: kbatmonconfig.cc,v 1.4 1999/01/15 06:08:48 russ Exp $
 *
 * $Log: kbatmonconfig.cc,v $
 * Revision 1.4  1999/01/15 06:08:48  russ
 * Added file headers.
 *
 *
 */
 
#include <kapp.h>
#include <kconfigbase.h>

#include "kbatmonconfig.h"


// Config File Strings
#define CONFIG_GROUP_GENERAL "General"
#define CONFIG_DOCK_IN_PANEL "DockInPanel"
#define CONFIG_DOCK_IN_PANEL_DEFAULT true
#define CONFIG_USE_SESSION_MANAGEMENT "UseSessionManagement"
#define CONFIG_USE_SESSION_MANAGEMENT_DEFAULT true

#define CONFIG_LOW_BAT_WARNING "LowBatteryWarning"
#define CONFIG_LOW_BAT_WARNING_DEFAULT false


KBatMonConfig::KBatMonConfig()
    : configFile( kapp->getConfig() )
{}

KBatMonConfig::~KBatMonConfig()
{}

bool
KBatMonConfig::getDockInPanel(void)
{
    KConfigGroupSaver general( configFile, CONFIG_GROUP_GENERAL );
    return configFile->readBoolEntry(CONFIG_DOCK_IN_PANEL, CONFIG_DOCK_IN_PANEL_DEFAULT );
}

void
KBatMonConfig::setDockInPanel(bool newValue)
{
    KConfigGroupSaver general( configFile,  CONFIG_GROUP_GENERAL );

    bool oldValue = configFile->readBoolEntry(CONFIG_DOCK_IN_PANEL, CONFIG_DOCK_IN_PANEL_DEFAULT );

    if( newValue != oldValue ) {
        configFile->writeEntry(CONFIG_DOCK_IN_PANEL, newValue );
        emit dockInPanelChanged(newValue);
        emit configChanged();
    }
}

bool
KBatMonConfig::getUseSessionManagement(void)
{
    KConfigGroupSaver general( configFile, CONFIG_GROUP_GENERAL );
    return configFile->readBoolEntry(CONFIG_USE_SESSION_MANAGEMENT, CONFIG_USE_SESSION_MANAGEMENT_DEFAULT );
}

void
KBatMonConfig::setUseSessionManagement(bool newValue)
{
    KConfigGroupSaver general( configFile,  CONFIG_GROUP_GENERAL );

    bool oldValue = configFile->readBoolEntry(CONFIG_USE_SESSION_MANAGEMENT, CONFIG_USE_SESSION_MANAGEMENT_DEFAULT );

    if( newValue != oldValue ) {
        configFile->writeEntry(CONFIG_USE_SESSION_MANAGEMENT, newValue );
        emit useSessionManagementChanged(newValue);
        emit configChanged();
    }
}

bool
KBatMonConfig::getLowBatWarning(void)
{
    KConfigGroupSaver general( configFile,  CONFIG_GROUP_GENERAL );
    return configFile->readBoolEntry(CONFIG_LOW_BAT_WARNING, CONFIG_LOW_BAT_WARNING_DEFAULT );
}

void
KBatMonConfig::setLowBatWarning(bool newValue)
{
    KConfigGroupSaver general( configFile,  CONFIG_GROUP_GENERAL );

    bool oldValue = configFile->readBoolEntry(CONFIG_LOW_BAT_WARNING, CONFIG_LOW_BAT_WARNING_DEFAULT );

    if( newValue != oldValue ) {
        configFile->writeEntry(CONFIG_LOW_BAT_WARNING, newValue);
        emit lowBatWarningChanged(newValue);
        emit configChanged();
    }
}

