/****************************************************************************
 * KGhostscriptInfo - holds a list of printer types and the magicfilter
 *  information needed for them.
 *
 *  Copyright (C) 1998 Neil Hart (nhart@magma.ca)
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Id: kgsinfo.cpp,v 1.9 1998/05/01 16:01:05 nhart Exp nhart $
 *                                                                   
 ****************************************************************************/


#include "kgsinfo.h"
#include "kprinterrs.h"

#include <qstring.h>
#include <qfile.h>
#include <qtstream.h>

#include <kapp.h>

#include <iostream.h>
#include <stdio.h>
#include <string.h>

#define LINELENGTH 1024

static char* RCSinfo = "$Id: kgsinfo.cpp,v 1.9 1998/05/01 16:01:05 nhart Exp nhart $";

KGhostscriptInfo::KGhostscriptInfo()
{
	piCtr = 0;
}

KGhostscriptInfo::~KGhostscriptInfo()
{
	for (int i = 0; i < piCtr; i++)
	{
		if (pInfo[i][0] != 0) delete pInfo[i][0];
		if (pInfo[i][1] != 0) delete pInfo[i][1];
	}
}

int KGhostscriptInfo::init()
{
	// This table is a list of printer types to be presented when the user
	//  is selecting a printer, together with the magicfilter that needs to
	//  be used. Thanks to H. Peter Anvin for magicfilter.
	QString filter_list_name( KApplication::kde_datadir() + "/kcmprinter_filters");
	FILE* filter_list = fopen( filter_list_name.data(), "r" );
	if ( filter_list == NULL )
		return CANT_OPEN_GHOSTSCRIPT_INFO;

	char lineFromFilterFile[LINELENGTH];
	while ( (fgets(lineFromFilterFile, LINELENGTH, filter_list)) != NULL )
	{
		// split the line into two null-terminated strings
		char* cp = strchr( lineFromFilterFile, '\n' );
		*cp = '\0';
		cp = strchr( lineFromFilterFile, ':' );
		if ( cp == NULL )
			continue;
		*cp = '\0';
		FILE* fp = fopen( lineFromFilterFile, "r" );
		if ( fp != NULL)
		{
			// filter exists, so add it to the table
			pInfo[piCtr][1] = new QString( lineFromFilterFile );
			pInfo[piCtr][0] = new QString( cp + 1 );
			piCtr++;
			fclose( fp );
		}
	}
	if ( fclose(filter_list) != 0 )
		return CANT_OPEN_GHOSTSCRIPT_INFO;

	return RETURN_OK;
}

int KGhostscriptInfo::numberOfPrinterTypes()
{
	return piCtr;
}

// set type to point to a text description of the numbered printer type
//  if number is out of range, return false
bool KGhostscriptInfo::getGsPrinterType(int index, QString** pType)
{
	if ( index > (piCtr - 1) )
		return false;
	*pType = pInfo[index][0];
	return true;
}

// set filter to point to a filter name
//  if number is out of range, return false
bool KGhostscriptInfo::getGsPrinterFilter(int index, QString** pFilter)
{
	if ( index > (piCtr - 1) )
		return false;
	*pFilter = pInfo[index][1];
	return true;
}

// given a filter name, set type to point to a text description of 
//  the printer type. If filter name doesn't exist, return false
bool KGhostscriptInfo::getTypeFromFilter(const QString* filter, QString** pType)
{
	int i;
	for (i = 0; i < piCtr; i++)
	{
		if ( *(pInfo[i][1]) == *filter )
		{
			*pType = pInfo[i][0];
			return true;
		}
	}
	return false;
}

// given a filter name, set pIndex to point to index of that filter
//  in the list of filter types. If filter name doesn't exist, return false
bool KGhostscriptInfo::getIndexFromFilter(const QString* filter, int* pIndex)
{
	int i;
	for (i = 0; i < piCtr; i++)
	{
		if ( *(pInfo[i][1]) == *filter )
		{
			*pIndex = i;
			return true;
		}
	}
	return false;
}

	
