/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   
/* ascii-file-check !!!!!!!!!!!!!!!!!!!!!!!!!!!!
int KDiff::loadFile( char *fname, QString& dest )
*/

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <ctype.h>
#include <qdir.h>
/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "kdiff.h"
// #include "kdiff.moc.cpp"
#include "DebugInfo.h"

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/
#define DIFF_LRC      1  // Left Right Change
#define DIFF_RCA      2  // Right Change Add
#define DIFF_LCA      3
#define DIFF_LA       4
#define DIFF_RA       5
#define DIFF_LC       6
#define DIFF_NOTREL   7

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- GLOBAL VARIABLES
-----------------------------------------------------------------------------*/


/* Aenderungen von Zeile 1 bis Zeile 4
1,4c1,4
< Dies Zeile 1
< Dies ist Zeile 2
< Dies  Zeile 3
< Dies ist Zeile 4
---
> Dies ist Zeile 1
> Dies Zeile 2
> Dies ist Zeile 3
> Dies Zeile 4
*/

/* Aenderungen in Zeile 4 
4c4
< Dies ist Zeile 4
---
> Dies Zeile 4
*/

/* rechts ist eine Zeile mehr
3a4
> Dies ist Zeile 4
*/

/* links ist eine Zeile mehr
5d4
< und hier ist was neu
*/
/* links geaendert und eine Zeile hinzugekommen
2,3c2
< Dies ist Zeile 12
< Dies ist Zeile i13
*/

/* rechts geaendert und eine Zeile hinzugekommen
2c2,3
< Dies ist Zeile 2
---
> Dies ist Zeile 12
> neue zeile rechts
*/

/* Zeile 3,4 links hinzugekommen
3,4d2
< Dies ist Zeile 3
< Dies ist Zeile 4
*/
/* Zeile 3,4 rechts hinzugekommen
2a3,4
> Dies ist Zeile 3
> Dies ist Zeile 4
*/

//
// Name:  kDifference::kDifference 
//
// Comment:
//
// Parameter:
//
kDifference::kDifference( char *diffOutputLine )
{
 dprintf( "START::kDifference( >%s< ) \n", diffOutputLine );
 
 if ( diffOutputLine[0] == '<' || diffOutputLine[0] == '>' || diffOutputLine[0] == '-' )
 {
   type = DIFF_NOTREL;
 }
 else // 1,4c1,4 Changes on left and right side
  if ( sscanf( diffOutputLine, "%d,%dc%d,%d\n", &leftS, &leftE, &rightS, &rightE ) == 4 ) 
  {
    type = DIFF_LRC;
  }
  else //2c2,3  right change 2 and adds 3 
   if (  sscanf( diffOutputLine, "%dc%d,%d\n", &leftS, &rightS, &rightE ) == 3 )   
   {
     type = DIFF_RCA;
     leftE = leftS;
   }
   else //2,3c2 left change 2 and adds 3
    if (  sscanf( diffOutputLine, "%d,%dc%d\n", &leftS, &leftE, &rightS ) == 3 )   
    {
      type = DIFF_LCA;
      rightE = rightS;
    }
    else // 3c3 single line changed
     if ( sscanf( diffOutputLine, "%dc%d\n", &leftS, &rightS ) == 2 )
     {
       type = DIFF_LC;
       leftE=leftS;
       rightE=rightS;
     }  
     else // 2a3,4  right adds 3 and 4
      if ( sscanf( diffOutputLine, "%da%d,%d\n", &leftS, &rightS, &rightE ) == 3 )
      {
        leftE = leftS;
        type = DIFF_RA;
      }
      else // 3a4 right adds 4
       if ( sscanf( diffOutputLine, "%da%d\n", &leftS, &rightS ) == 2 )  
       {
         leftE = leftS;
         rightE = rightS;
         type = DIFF_RA;
       }
       else // 3,4d2 left adds 3 and 4
        if ( sscanf( diffOutputLine, "%d,%dd%d\n", &leftS, &leftE, &rightS ) == 3 )    
        {
          rightE = rightS;
          type = DIFF_LA;
        }
        else // 5d4  left adds 5
         if ( sscanf( diffOutputLine, "%dd%d\n", &leftS, &rightS ) == 2 )  
         {
           leftE = leftS;
           rightE = rightS;
           type = DIFF_LA;
         }
         else
           type = DIFF_NOTREL;

  dprintf( "kDifference::kDifference: type = >%d<\n", type );
  dprintf( "END::kDifference=><\n");
} 

//
// Name:  kDifference::~kDifference 
//
// Comment:
//
kDifference::~kDifference()
{
  dprintf( "START::~kDifference\n");

  dprintf( "END::~kDifference=><\n");
} 


//
// Name: kDisplayText::kDisplayText( char *line, int fline, int dline, short attr ) 
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
kDisplayText::kDisplayText( char *line, int fline, int dline, short attr ) 
{
  dprintf( "START::kDisplayText( >%s<, >%d<, >%d<, >%d<)\n", line, fline, dline, attr );
 
  lineStr = new char[strlen(line)+1];
  strcpy( lineStr, line );
  fLine = fline;
  dLine = dline;
  attribut = attr;

  dprintf( "END::kDisplayText( ... )=>void<\n" );

}

//
// Name: kDisplayText::~kDisplayText()
//
// Comment:
//
kDisplayText::~kDisplayText()
{
  dprintf( "START::~kDisplayText( )\n" );
  if ( lineStr != 0 )
    delete lineStr;
  dprintf( "END::~kDisplayText( ... )=>void<\n" );
}


//
// Name:  KDiff::KDiff ( KURL *leftFile = 0, KURL *rightFile = 0 ) 
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
KDiff::KDiff ( KURL *leftFile = 0, KURL *rightFile = 0 )
      :QObject()
{
  dprintf( "START:KDiff::KDiff ( KURL *leftFile = 0, KURL *rightFile = 0 )\n");
  
  if ( leftFile != 0 )
     lFile = leftFile;
  else
    lFile = 0;
    
  if ( rightFile != 0 )
    rFile = rightFile;
  else
    rFile = 0;
 
  diffStdoutStr = QString();
  diffStderrStr = QString();
  diffProcess = NULL;
  
  leftText = QString();
  rightText = QString();
      
  dList = new QList<kDifference>;
  leftTextList = new QList<kDisplayText>;
  rightTextList = new QList<kDisplayText>;
  
  dList->setAutoDelete( TRUE );
  leftTextList->setAutoDelete( TRUE );
  rightTextList->setAutoDelete( TRUE );

  emit proceedState( PS_NOTHING_DONE );

  dprintf( "END:KDiff::KDiff ( )=><\n");
} // End of Member:  KDiff::KDiff ( KURL *leftFile = 0, KURL *rightFile = 0 )


//
// Name:  KDiff::~KDiff() 
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
KDiff::~KDiff()
{
  dprintf( "START:KDiff::~KDiff()\n");

  if ( diffProcess != NULL ) delete diffProcess;

  if ( dList != 0 )
  {
    dList->clear();
    delete dList;
  }
  if ( leftTextList != 0 )
  {
    leftTextList->clear();
    delete leftTextList;
  }
  
  if ( rightTextList != 0 )
  {
    rightTextList->clear();
    delete rightTextList;
  }
  
  dprintf( "END:KDiff::~KDiff()=><\n");
} // End of Member:  KDiff::~KDiff()



//
// Name: int KDiff::setLeftFile( KURL *leftFile) 
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
int KDiff::setLeftFile( KURL *leftFile)
{
  int retValue = -1;
  dprintf( "START:KDiff::setLeftFile( KURL *leftFile)\n");
  
  lFile = leftFile;
  QString decoded( lFile->path() );
  KURL::decodeURL( decoded );
  
  if ( (retValue=loadFile( (const char *)decoded, leftText )) != 0 )
  {
    lFile = 0;
    leftText.resize(0);
  }

  emit proceedState( PS_NOTHING_DONE );

  dprintf( "END:KDiff::setLeftFile( )=>%d<\n", retValue );
  return( retValue );
}



//
// Name: int KDiff::setRightFile( KURL *rightFile) 
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
int KDiff::setRightFile( KURL *rightFile )
{
  int retValue = -1;
  dprintf( "START:KDiff::setRightFile( KURL *rightFile)\n");

  rFile = rightFile;
  QString decoded( rFile->path() );
  KURL::decodeURL( decoded );
  if ( (retValue=loadFile( (const char *)decoded, rightText )) != 0 )
  {
    rFile = 0;
    rightText.resize(0);
  } 

  emit proceedState( PS_NOTHING_DONE );

  dprintf( "END:KDiff::setRightFile( )=>%d<\n", retValue );
  return( retValue );
}


//
// Name: KDiff::loadFile( char *fname, QString& dest )
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue: -1 File loading error else
//              0
//
int KDiff::loadFile( const char *fname, QString& dest )
{
  int retValue = -1;
  char *buffer;   
  QFileInfo fInfo( fname );
  QFile     file( fname );
 
  dprintf( "START:KDiff::loadFile( >%s<, >...<)\n", fname );

  dest = "";
    
  if ( file.open( IO_ReadOnly ) == TRUE )
  {
    buffer = new char[fInfo.size() + 1];
    buffer[fInfo.size()] = '\0';
    if ( buffer != 0 && dest.resize( fInfo.size() ) == true )
    {
      if ( (uint)file.readBlock( buffer, fInfo.size()) == fInfo.size() )
      {
        retValue = 0;
#if 0
        /* is ascii-data ? */
        for ( int i=0; i < fInfo.size(); i++ )
        {
          if( !isascii( buffer[i] ) )
          {
            retValue =-2;
            break;
          }
        }
#endif
        if ( retValue == 0 )
          dest.append( buffer ); //dest = buffer;          
      }
      delete buffer;
    }                 
  }
  file.close();

  dprintf( "END:KDiff::loadFile( )=>%d<\n", retValue );
  return( retValue );
}


//
// Name: int KDiff::canDoDifferences() 
//
// Comment: checks for left and right file
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue: bool
//
bool KDiff::canDoDifferences()
{ 
  bool retValue;

  dprintf( "START:KDiff::canDoDifferences()\n");
  if ( rFile != 0  && lFile != 0 )
    retValue = TRUE;
  else
    retValue = FALSE;
     
  dprintf( "END:KDiff::canDoDifferences()=>%d<\n", retValue );
  return( retValue); 
}


//
// Name: int KDiff::doDifferences() 
//
// Comment: exec diff-process
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
int KDiff::doDifferences()
{
  int retValue = 0;
  
  dprintf( "START:KDiff::doDifferences()\n");

  if ( lFile == 0 )
    retValue = -1;
  else
    if ( rFile == 0 )
      retValue = -2;
      
  if ( retValue == 0 )
  {
    diffStdoutStr = "";
    diffStderrStr = "";
    
    if ( diffProcess != NULL )
    {
      delete diffProcess;
    }
    
    diffProcess = new KProcess();
    diffProcess->setExecutable( "diff" );
    connect( diffProcess, SIGNAL(receivedStdout(KProcess*, char*, int)), SLOT(diffStdout(KProcess*, char*, int)) );
    connect( diffProcess, SIGNAL(receivedStderr(KProcess*, char*, int)), SLOT(diffStderr(KProcess*, char*, int)) );
    //connect( diffProcess, SIGNAL(processExited(KProcess*)), SLOT(diffReady(KProcess*)) );
       
    //diffProcess->clearArguments(); since snapshot 01/18/98 it doesn't work
    // so i create diffProcess new every time a diff-process is needed
    
    QString decodedR( rFile->path() );  
    KURL::decodeURL( decodedR );
    QString decodedL( lFile->path() );  
    KURL::decodeURL( decodedL );    
    
    *diffProcess << decodedL << decodedR;
    
    emit proceedState( PS_DIFF_START );
    bool a = diffProcess->start( KProcess::Block, /*NotifyOnExit,*/ KProcess::AllOutput );
    emit proceedState( PS_DIFF_FINISHED );

    if ( a != TRUE || diffStderrStr.length() > 0 )
    {
      retValue = -3;
    }
#if 0
    if ( diffProcess->normalExit() == TRUE )
      printf( "Process did normal exit\n");
    else
      printf( "Process did unnormal exit\n");

    printf( "Exitstatus:>%d< \n",diffProcess->exitStatus ());
#endif
  }

  if ( retValue == 0 )
  {
    parseDiffOutput( leftText, rightText, diffStdoutStr );
  }
  
  emit proceedState( PS_DIFF_COMPLETE_FINISHED );

  dprintf( "END:KDiff::doDifferences()=>%d<\n", retValue );
  return( retValue );
} 


//
// Name: KDiff::diffStdout( KProcess *proc, char *buffer, int len )
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue: bool
//
void KDiff::diffStdout( KProcess *proc, char *buffer, int len )
{
  dprintf( "START:KDiff::diffStdout( >%p<, >%p<, >%d<)\n", proc, buffer, len );
  if ( len > 0 )
  {
    diffStdoutStr+=buffer;
  }

  dprintf( "END:KDiff::diffStdout()=>void<\n" );
}


//
// Name: KDiff::diffStderr( KProcess *proc, char *buffer, int len ) 
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue: bool
//
void KDiff::diffStderr( KProcess *proc, char *buffer, int len )
{
  dprintf( "START:KDiff::diffStderr( >%p<, >%p<, >%d<)\n", proc, buffer, len );
 // dprintf( ">%s<\n", (len>0)?buffer:"" );
  if ( len > 0 )
  {
    diffStderrStr+=buffer;
  }

  dprintf( "END:KDiff::diffStderr()=>void<\n" );
}


//----------------------------------------------------------------------------------
//
// Name:  KDiff( const char *leftTxt, const char *rightTxt, const char *diffOutStr )
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
void KDiff::parseDiffOutput( const char *leftTxt, const char *rightTxt, const char *diffOutStr )
{
  char *curPos;
  char *line;
  int fileLineNr, displayLineNr, i;
  kDifference *kd;
  kDisplayText *kdt;
  short attribute;

  
  dprintf( "START::parseDiffOutput( ... )\n" );

  dList->clear();
  leftTextList->clear();
  rightTextList->clear();
  

  // diff-output to difference-list
  //-------------------------------
  curPos = diffOutStr;
  line = getLine( curPos );
  while( line != 0 )
  {
    kd = new kDifference( line );
    if ( kd->type == DIFF_NOTREL )
    {
      delete kd;
    }
    else
    {
      dList->append( kd );
    }
    curPos=&curPos[ strlen(line) ];
    delete line;
    line = getLine( curPos );
  }

  emit proceedState( PS_OUTPUT_MERGED );
  
  // merge the difference-list + lefttext to newtext
  //------------------------------------------------
  displayLineNr = 0;
  fileLineNr = 0;
  curPos = leftTxt; 
  line = getLine( curPos );
  while( line != 0 )
  {
     attribute = DISPLAY_NORMAL;    
     fileLineNr++; 
     displayLineNr++;
     kd = leftDifferenceType( fileLineNr );
     if ( kd != 0 )
     {
       int leftLinesDifference = kd->leftE - kd->leftS;
       int rightLinesDifference = kd->rightE - kd->rightS;

       switch ( kd->type )
       {
         case DIFF_LC:
           kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_CHANGE );
           leftTextList->append( kdt );
         break;
         case DIFF_LRC:
           // if one or more lines in a change-set are deleted instead of only changed, the diff output
           // display only the change information 
           // ex. 6,14c6,15 --> in right file were line 10 removed !!!

           // difference in both files equals ?
           if ( leftLinesDifference == rightLinesDifference )
           {
             kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_CHANGE );
             leftTextList->append( kdt );
           }
           else
           {
             if (  leftLinesDifference < rightLinesDifference )
             {
              if ( fileLineNr == kd->leftE )
               {
                 kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_CHANGE );
                 leftTextList->append( kdt );

                 for ( i=0; i< rightLinesDifference-leftLinesDifference; i++ )
                 {
                   displayLineNr++;
                   kdt = new kDisplayText( "\n", -1, displayLineNr, DISPLAY_DELETE );
                   leftTextList->append( kdt );
                 }
               }
               else
               {
                 kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_CHANGE );
                 leftTextList->append( kdt );
               }
             }
             else
             {
                kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_CHANGE );
                leftTextList->append( kdt );
             }
           }
         break;
         case DIFF_LA:
           kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_INSERT );
           leftTextList->append( kdt );
         break;
         case DIFF_LCA:
           if ( fileLineNr > kd->leftS )
             attribute = DISPLAY_INSERT;
           else
             attribute = DISPLAY_CHANGE;

           kdt = new kDisplayText( line, fileLineNr, displayLineNr, attribute );
           leftTextList->append( kdt );
         break;

         case DIFF_RA: // 2a3,4  right adds 3 and 4 --> left deleted 3,4
         {
           bool inserted = FALSE;
           kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_NORMAL );
           leftTextList->append( kdt );
           displayLineNr++;
           for ( i = kd->rightS; i <= kd->rightE; i++ )
           {           
             kdt = new kDisplayText( "\n", -1, displayLineNr, DISPLAY_DELETE );
             leftTextList->append( kdt );
             displayLineNr++;
             inserted = TRUE;
           }
           if ( inserted == TRUE ) displayLineNr--; 
         }       
         break;
         case DIFF_RCA: // 2c2,3  right change 2 and adds 3 
           for ( i = kd->rightS; i <= kd->rightE; i++ )
           {           
             if ( i > kd->rightS )
               attribute = DISPLAY_DELETE;
             else
               attribute = DISPLAY_CHANGE;

             kdt = new kDisplayText( (attribute==DISPLAY_CHANGE)?line:"\n", (attribute==DISPLAY_CHANGE)?fileLineNr:-1, displayLineNr, attribute );
             leftTextList->append( kdt );
             displayLineNr++;
           }
           if ( kd->rightS< kd->rightE) displayLineNr--;
         break;

         default:
           kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_NORMAL );
           leftTextList->append( kdt );
         break;                 
       }

     }// if ( kd != 0 )
     else
     {
       kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_NORMAL );
       leftTextList->append( kdt );
     }
     
     curPos=&curPos[ strlen(line) ];
     delete line;
     line = getLine( curPos );

   }//while

   emit proceedState( PS_OUTPUT_LEFTTEXT );

  // merge the difference-list + righttext to newtext
  //------------------------------------------------
  displayLineNr = 0;
  fileLineNr = 0;
  curPos = rightTxt; 
  line = getLine( curPos );
  while( line != 0 )
  {
     attribute = DISPLAY_NORMAL;    
     fileLineNr++; 
     displayLineNr++;
     kd = rightDifferenceType( fileLineNr );
     if ( kd != 0 )
     {
       int leftLinesDifference = kd->leftE - kd->leftS;
       int rightLinesDifference = kd->rightE - kd->rightS;

       switch ( kd->type )
       {
         case DIFF_LC:
           kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_CHANGE );
           rightTextList->append( kdt );
         break;
         case DIFF_LRC:
           // if one or more lines in a change-set are deleted instead of only changed, the diff output
           // display only the change information
           // ex. 6,14c6,15 --> in right file were line 10 removed !!!

           // difference in both files equals ?
           if ( rightLinesDifference == leftLinesDifference )
           {
             kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_CHANGE );
             rightTextList->append( kdt );
           }
           else
           {
             if (  rightLinesDifference < leftLinesDifference )
             {
               if ( fileLineNr == kd->rightE )
               {
                 kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_CHANGE );
                 rightTextList->append( kdt );

                 for ( i=0; i< leftLinesDifference-rightLinesDifference; i++ )
                 {
                   displayLineNr++;
                   kdt = new kDisplayText( "\n", -1, displayLineNr, DISPLAY_DELETE );
                   rightTextList->append( kdt );
                 }
               }
               else
               {
                 kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_CHANGE );
                 rightTextList->append( kdt );
               }
             }
             else
             {
                kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_CHANGE );
                rightTextList->append( kdt );
             }
           }
         break;


         case DIFF_LA: // 3,4d2 left adds 3 and 4   OR // 3d2  left adds 3
         {
           bool inserted = FALSE;
           kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_NORMAL );
           rightTextList->append( kdt );
           displayLineNr++;
           for ( i = kd->leftS; i <= kd->leftE; i++ )
           {           
             kdt = new kDisplayText( "\n", -1, displayLineNr, DISPLAY_INSERT );
             rightTextList->append( kdt );
             displayLineNr++;
             inserted = TRUE;
           }
           if ( inserted == TRUE ) displayLineNr--;
         }
         break;
         case DIFF_LCA: //2,3c2 left change 2 and adds 3
           for ( i = kd->leftS; i <= kd->leftE; i++ )
           {           
             if ( i > kd->leftS )
               attribute = DISPLAY_INSERT;
             else
               attribute = DISPLAY_CHANGE;
             
             kdt = new kDisplayText( (attribute==DISPLAY_CHANGE)?line:"\n", (attribute==DISPLAY_CHANGE)?fileLineNr:-1, displayLineNr, attribute );
             rightTextList->append( kdt );
             displayLineNr++;
           }
           if ( kd->leftE > kd->leftS ) displayLineNr--;
         break;

         case DIFF_RCA:
         case DIFF_RA:
           if ( kd->leftE < fileLineNr )
             attribute = DISPLAY_DELETE;
           else
             attribute = DISPLAY_CHANGE;
             
           kdt = new kDisplayText( line, fileLineNr, displayLineNr, attribute );
           rightTextList->append( kdt );
         break;

         default:
           kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_NORMAL );
           rightTextList->append( kdt );
         break;                 
       }

     }// if ( kd != 0 )
     else
     {
       kdt = new kDisplayText( line, fileLineNr, displayLineNr, DISPLAY_NORMAL );
       rightTextList->append( kdt );    
     }
     
     curPos=&curPos[ strlen(line) ];
     delete line;
     line = getLine( curPos );

   }//while

#ifdef DEBUGME_AEHAEH

  for ( i = 0; i < (int)leftTextList->count(); i++ )
  {
    kDisplayText *t=leftTextList->at(i);
    if ( t != 0 )
    {
      printf( ">%5d<|>%5d<|>%2d<|>%s", t->fLine, t->dLine, t->attribut, t->lineStr );
    }
  }
printf("--------------------------------------------------\n");
  for ( i = 0; i < (int)rightTextList->count(); i++ )
  {
    kDisplayText *t=rightTextList->at(i);
    if ( t != 0 )
    {
      printf( ">%5d<|>%5d<|>%2d<|>%s", t->fLine, t->dLine, t->attribut, t->lineStr );
    }
  }
printf("--------------------------------------------------\n");
  for ( i = 0; i < (int)dList->count(); i++ )
  {
    kDifference *t=dList->at(i);
    if ( t != 0 )
    {
      printf( ">%1d<|>%5d<|>%5d<|>%5d<|>%5d<\n", t->type, t->leftS, t->leftE, t->rightS, t->rightE );
    }
  } 
#endif

  dprintf( "END::parseDiffOutput( ... )=>void<\n" );

}



//
// Name:  KDiff::hasDifferences();
//
// Comment:
//
// Parameter:
//
// ReturnValue: 
//
int KDiff::hasDifferences()
{
  int retValue;
  dprintf( "START::hasDifferences()\n" );

  retValue = dList->count();

  dprintf( "END::hasDifferences()=>%d<\n", retValue );
  return( retValue );
}


//
// Name:  getLine( char *str )
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
char *KDiff::getLine( char *str )
{
  int i;
  char *retValue=0;
  char *retP;
  
  dprintf( "START::getLine(...)\n" );
  
  i=0;
  retP = str;
  while ( *retP != 0 )
  {           
    if ( *retP == '\n' )
    {
      i++;
      break;
    }
    retP++;
    i++;
  }

  if ( i > 0 )
  {
    retValue = new char[i+1];
    strncpy( retValue, str, i );
    retValue[i]='\0'; 
  }   

  dprintf( "END::getLine(...)=>%s<\n", retValue );
  
  return( retValue );
}




//
// Name:  getLeftDisplayText( int dlineNr )
//
// Comment: the output from diff and the left file are merged 
//          in the list leftTextList. this fct. returns the display line
//          for the argument dlineNr.
//
// Parameter: 
//
// ReturnValue:
//
kDisplayText *KDiff::getLeftDisplayText( unsigned int dlineNr )
{
  kDisplayText *t=0;
  
  dprintf( "START::getLeftDisplayText( >%d< )\n", dlineNr );

  if ( dlineNr == 0 ) dlineNr=1;
  if ( dlineNr <= leftTextList->count() )
    t=leftTextList->at( dlineNr-1 );

  if ( t )
    if( t->dLine != dlineNr )  
      t=0;

  dprintf( "END::getLeftDisplayText(...)=>%p<\n", t );
  return( t );
}

//
// Name:  getLeftFileText( int flineNr )
//
// Comment: the output from diff and the left file are merged 
//          in the list leftTextList. this fct. returns the original 
//          line from the left file
//
// Parameter:
//
// ReturnValue:
//
kDisplayText *KDiff::getLeftFileText( unsigned int flineNr )
{
  kDisplayText *t=0;
  
  dprintf( "START::getLeftFileText( >%d< )\n", flineNr );

  for ( int a = 0; a < (int)leftTextList->count(); a++ )
  {
    t=leftTextList->at(a);
    if ( t->fLine == flineNr )
      break;
  }
  if ( t )
    if( t->fLine != flineNr )  
      t=0;

  dprintf( "END::getLeftFileText(...)=>%p<\n", t );
  return( t );
}


//
// Name:  getRightDisplayText( int dlineNr )
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
kDisplayText *KDiff::getRightDisplayText( unsigned int dlineNr )
{
  kDisplayText *t=0;
  
  dprintf( "START::getRightDisplayText( >%d< )\n", dlineNr );

  if ( dlineNr == 0 ) dlineNr=1;
  
  if ( dlineNr <= rightTextList->count() )
    t=rightTextList->at( dlineNr-1 );

  if ( t )
    if( t->dLine != dlineNr )  
      t=0;

  dprintf( "END::getRightDisplayText(...)=>%p<\n", t );
  return( t );

}


//
// Name:  getRightFileText( int flineNr )
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
kDisplayText *KDiff::getRightFileText( unsigned int flineNr )
{
  kDisplayText *t=0;
  
  dprintf( "START::getRightFileText( >%d< )\n", flineNr );

  for ( int a = 0; a < (int)rightTextList->count(); a++ )
  {
    t=rightTextList->at(a);
    if ( t->fLine == flineNr )
      break;
  }
  if ( t )
    if( t->fLine != flineNr )  
      t=0;
  dprintf( "END::getRightFileText(...)=>%p<\n", t );
  return( t );

}


//
// Name:  leftDifferenceType( int lineNr )
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
kDifference *KDiff::leftDifferenceType( int lineNr )
{
  kDifference *retValue=0;
  kDifference *t=0;
  
  dprintf( "START::leftDifferenceType( >%d< )\n", lineNr );

  for( int a=0; a < (int)dList->count(); a++ )
  {
    t=dList->at(a);

    if ( t->leftS == lineNr || t->leftE == lineNr || 
         ( t->leftS < lineNr && t->leftE > lineNr )
       )
    {
      retValue = t;
      break;
    }
    if ( t->leftE > lineNr )
    {
      retValue = 0;
      break;   
    }
  }  

  dprintf( "END::leftDifferenceType(...)=>%p<\n", retValue );
  return( retValue );
}


//
// Name:  rightDifferenceType( int lineNr )
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
kDifference *KDiff::rightDifferenceType( int lineNr )
{
  kDifference *retValue=0;
  kDifference *t=0;
  
  dprintf( "START::rightDifferenceType( >%d< )\n", lineNr );

  for( int a=0; a < (int)dList->count(); a++ )
  {
    t=dList->at(a);

    if ( t->rightS == lineNr || t->rightE == lineNr || 
         ( t->rightS < lineNr && t->rightE > lineNr )
       )
    {
      retValue = t;
      break;
    }
     
    if ( t->rightE > lineNr )
    {
      retValue = 0;
      break;   
    }           
  }  
 
  dprintf( "END::rightDifferenceType(...)=>%p<\n", retValue );
  return( retValue );
}


//
// Name:  KDiff::getLeftLineCount()
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
int KDiff::getLeftLineCount()
{
  int retValue;
  dprintf( "START::getLeftLineCount()\n" );
  retValue = leftTextList->count();
  dprintf( "END::getLeftLineCount()=>%d<\n", retValue ); 
  return( retValue );
}

//
// Name:  KDiff::getRightLineCount()
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
int KDiff::getRightLineCount()
{
  int retValue;
  dprintf( "START::getRightLineCount()\n" );
  retValue = rightTextList->count();
  dprintf( "END::getRightLineCount()=>%d<\n", retValue ); 
  return( retValue );
}   


//
// Name:  KDiff::getMaxLeftLineLenght()
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
int KDiff::getMaxLeftLineLenght()
{
  int retValue = 0;
  kDisplayText *kdt;
  
  dprintf( "START:KDiff:getMaxLeftLineLenght:()\n" );

  for( int i=0; i < (int)leftTextList->count(); i++ )
  {
    kdt=leftTextList->at(i);
    if ( retValue < (int)strlen( kdt->lineStr ) )
      retValue = strlen( kdt->lineStr );
  }
  
  dprintf( "END::getMaxLeftLineLenght()=>%d<\n", retValue ); 
  return( retValue );
}


//
// Name:  KDiff::getMaxRightLineLenght()
//
// Comment:
//
// Parameter:
//
// ReturnValue:
//
int KDiff::getMaxRightLineLenght()
{
  int retValue = 0;
  kDisplayText *kdt;
  
  dprintf( "START:KDiff:getMaxRightLineLenght:()\n" );

  for( int i=0; i < (int)rightTextList->count(); i++ )
  {
    kdt=rightTextList->at(i);
    if ( retValue < (int)strlen( kdt->lineStr ) )
      retValue = strlen( kdt->lineStr );
  }
  
  dprintf( "END::getMaxRightLineLenght()=>%d<\n", retValue ); 
  return( retValue );

}


//
// Name:  getPrevDiffLine( int startDline )
//
// Comment:  
//   returns previous displayline which displayattribut is not normal.
//   if none found, parameter startDline is returned.
//
// Parameter:
//
// ReturnValue:
//
int KDiff::getPrevDiffLine( unsigned int startDline )
{
  kDisplayText *t=0;
  int dline;
  
  dprintf( "START::getPrevDiffLine( >%d< )\n", startDline );

  if ( startDline == 0 ) 
    startDline=1;
  if ( startDline > leftTextList->count() )
    startDline=leftTextList->count();
    
    
  dline = startDline;
  startDline--;
  while ( startDline > 0 )
  {
    t=0;
    t=leftTextList->at( startDline-1 );
    if ( t )
    {
      if( t->attribut != DISPLAY_NORMAL )
      {
        dline = startDline;
        break;
      }
    }             
    startDline--;
  }
  
  dprintf( "END::getPrevDiffLine(...)=>%d<\n", dline );
  return( dline );
}



//
// Name:  getNextDiffLine( int startDline )
//
// Comment:  
//   returns next displayline which displayattribut is not normal.
//   if none found, parameter startDline is returned.
//
// Parameter:
//
// ReturnValue:
//
int KDiff::getNextDiffLine( unsigned int startDline )
{
  kDisplayText *t=0;
  int dline;
  
  dprintf( "START::getNextDiffLine( >%d< )\n", startDline );

  if ( startDline == 0 ) 
    startDline=1;
  if ( startDline > leftTextList->count() )
    startDline=leftTextList->count();
    
    
  dline = startDline;
  startDline++;
  while ( startDline <= leftTextList->count() )
  {
    t=0;
    t=leftTextList->at( startDline-1 );
    if ( t )
    {
      if( t->attribut != DISPLAY_NORMAL )
      {
        dline = startDline;
        break;
      }
    }             
    startDline++;
  }
  
  dprintf( "END::getPrevNextLine(...)=>%d<\n", dline );
  return( dline );
}



