/*

  THIS PROGRAM BASED ON kikbd BY (c) ALEXANDER BUDNIK <budnik@linserv.jinr.ru> 
  and setxkbmap by (c) Silicon Graphics Inc. 

  (c) Peter Novodvorsky <petya@logic.ru>, http://www.logic.ru/peter/, from 
  IPLabs   Linux Team <linux@iplabs.ru>, http://www.iplabs.ru/Linux/.

*/


#include <stdio.h> 
#include <stdlib.h>
#include <locale.h>
#include <string.h>
#include <qapplication.h>
#include <qlayout.h>
#include <qfileinf.h>
#include <qfont.h>
#include <qevent.h>
#include <klocale.h>
#include <kwm.h>
#include <kconfig.h>
#ifdef ACCEL
#include <kglobalaccel.h>
#endif
#include <kpixmap.h>
#include <kmsgbox.h>




#include "kkb.h"
#include <X11/Xos.h>
#include <X11/extensions/XKBfile.h>
#include <X11/extensions/XKBconfig.h>
#include <X11/extensions/XKBrules.h>




void KkbMain::KkbGetConfig() {
  KConfig *conf = KApplication::getKApplication()->getConfig();
  if (conf==NULL) {
    KMsgBox::message(0, i18n("Kkb ERROR"), i18n("Couldn't get information from configuration files"), KMsgBox::EXCLAMATION);
    ::exit(0);
  }
  conf->setGroup("Settings");

  isBeep=conf->readNumEntry("Beep",0); 
  conf->readListEntry("Mappings", langs);
#ifdef ACCEL
  changekeys=conf->readEntry("Keys");
#endif

  if ((!getMappingInformation()) || (!configData->first())) {
    KMsgBox::message(0, i18n("Kkb ERROR"), i18n("Couldn't get information from configuration files"), KMsgBox::EXCLAMATION);
    ::exit(0);
  }
  setXkbLayout();

}

void KkbButton::mousePressEvent(QMouseEvent* event)
{
  if(event->button() == LeftButton)  emit clicked();
  if(event->button() == RightButton) emit showMenu();
  if(event->button() == MidButton) emit midclicked();
}

void KkbMain::mousePressEvent(QMouseEvent* ev) {}


int KkbMain::KkbGetState() {
  XkbStateRec stat;
  XkbGetState(display,XkbUseCoreKbd,&stat);
  return (int)stat.group;
}
  
void KkbMain::showMenu()
{
  menu->popup(mainWidget()->mapToGlobal(mainWidget()->rect().topLeft()));
}

void KkbMain::KkbChangeGlobalGroup() {
  configData->next()?:configData->first();
  setXkbLayout();
  button->setText(configData->current()->getLang(KkbGetState()));
  button->setBackgroundPixmap(configData->current()->getPixmap());
}

bool KkbMain::getMappingInformation() {
  QString layout, pixfile, descr, file;
  QString lang[4];
  QPixmap *pixflag;
  KkbConfigClass *entry;
  langs.first();
  while (langs.current()!=NULL) {
    file=KApplication::kde_datadir()+"/kkb/"+langs.current();
    if (!file)
      return False;
    QFileInfo fi(file);
    if(!fi.isReadable()) 
      return False; 
    KConfig kconfig(fi.absFilePath());
    kconfig.setGroup("Groups");

    lang[0]=kconfig.readEntry("Group1");
    lang[1]=kconfig.readEntry("Group2");
    lang[2]=kconfig.readEntry("Group2");
    lang[3]=kconfig.readEntry("Group3");
  
    kconfig.setGroup("Properties");
    

    pixfile=kconfig.readEntry("Pixmap");
    layout=kconfig.readEntry("Layout");
    descr=kconfig.readEntry("Description","No Description");
    file=KApplication::kde_datadir()+"/kkb/pics/"+pixfile;
    
    configData->append(new KkbConfigClass(QPixmap(file), layout, lang, descr));
    langs.next();
  }
    
  
  return True;
}
  

  

KkbMain::~KkbMain() {
  KConfig *conf = KApplication::getKApplication()->getConfig();  
  conf->setGroup("Settings");
  conf->writeEntry("Beep", isBeep);
  conf->sync();
}

KkbMain::KkbMain(int n, char **v)
  :KApplication(n,v)
{ 
  QString temp;    

  /*Xkb stuff*/
  i1= XkbMajorVersion;
  i2= XkbMinorVersion;
  if ( !XkbLibraryVersion(&i1,&i2) ) {
    fprintf(stderr,klocale->translate("Warning! X library built with XKB version %d.%02d\n"),i1,i2);
    fprintf(stderr,klocale->translate("         but %s was built with %d.%02d\n"),XkbMajorVersion,XkbMinorVersion);
    fprintf(stderr,klocale->translate("         Trying anyway\n"));
  }
  if ( !XkbQueryExtension(display,&i1,&i2,&i3,&i4,&i5)>0 ) {
    if ((i4!=0)||(i5!=0))
      fprintf(stderr,klocale->translate("server supports incompatible XKB version %d.%02d\n"),i4,i5);
    else 
      fprintf(stderr,klocale->translate("XkbQueryExtension failed\n"));
      fprintf(stderr,klocale->translate("Trying anyway\n"));
  }   
 
  XkbSelectEventDetails(display, XkbUseCoreKbd, XkbStateNotify, 0xFFF, XkbGroupLockMask|XkbGroupBaseMask);
  
  /*buttons, layout, etc. */
  QWidget *wid = new QFrame();
  QVBoxLayout *lay = new QVBoxLayout(wid);
  button = new KkbButton(wid);
  lay->addWidget(button);
  setMainWidget(wid);
  setTopWidget(wid);

  configData=new KkbMappingList();

  KkbGetConfig();
  
  /*menu*/
  menu = new QPopupMenu();
 
  KkbConfigClass *conf;
  for (conf=configData->first(); conf != NULL; conf=configData->next()) {
    menu->insertItem(conf->getPixmap(), conf->getDescr());
  }
  configData->first();
  menu->insertSeparator();

  beepID=menu->insertItem(klocale->translate("&Beep"), this, SLOT(dobeep()));
  menu->setCheckable(TRUE);
  menu->setItemChecked(beepID, isBeep);

    menu->insertItem(klocale->translate("&Quit"), this, SLOT(quit()));
  
  /*signals*/
  connect(button, SIGNAL(showMenu()), SLOT(showMenu()));
  connect(button, SIGNAL(clicked()), SLOT(KkbChangeState()));
  connect(button, SIGNAL(midclicked()), SLOT(KkbChangeGlobalGroup()));
  connect(menu  , SIGNAL(activated(int)), SLOT(activateMenu(int)));

  /*get Keys*/
#ifdef ACCEL
  keys = new KGlobalAccel();
  keys->insertItem(i18n("Change Group"), "Change Group", changekeys);
  keys->connectItem("Change Group", this, SLOT(KkbChangeGlobalGroup()));
  keys->readSettings();
#endif
  
  /*fonts and size*/
  button->setBackgroundPixmap(configData->current()->getPixmap());
  button->setFont(generalFont);
  QFontMetrics font = button->fontMetrics();
  button->setFixedSize(20,20);
  mainWidget()->resize(button->minimumSize());
  button->setText(configData->current()->getLang(KkbGetState()));

  KWM::setDockWindow(wid->winId());

  mainWidget()->show();  
}

void KkbMain::doconfig() {
  system("kcmkb&");
  KkbGetConfig();  
  button->setText(configData->current()->getLang(KkbGetState()));
}

bool KkbMain::setXkbLayout() {
  XkbRF_VarDefsRec	rdefs;
  XkbRF_RulesPtr        ruls=NULL;
  XkbComponentNamesRec  rnames;
  char *rfName;
  char dir[100];
  if (!XkbRF_GetNamesProp(display,&rfName,&rdefs)) {
    KMsgBox::message(0, i18n("Kkb ERROR"), i18n("Couldn't interpret Xkb property"), KMsgBox::EXCLAMATION);
    return False;
  }
  rdefs.layout=configData->current()->getLayout();
  XkbRF_SetNamesProp(display,rfName,&rdefs);
    
  sprintf(dir,"%s/rules/%s",XKB_DIR,rfName);
  ruls=  XkbRF_Load(dir, getLocale(), True,True);
  if (!ruls) {
     KMsgBox::message(0, i18n("Kkb ERROR"), i18n("Your rules file is in the wrong place!"), KMsgBox::EXCLAMATION);
     ::exit(0);
  }
  XkbRF_GetComponents(ruls, &rdefs, &rnames);
  if (!XkbGetKeyboardByName(display, XkbUseCoreKbd,&rnames,
                       XkbGBN_AllComponentsMask,
		       XkbGBN_AllComponentsMask&(~XkbGBN_GeometryMask),
			    True)) {
    KMsgBox::message(0, i18n("Kkb ERROR"), i18n("Couldn't set map!"), KMsgBox::EXCLAMATION);
    ::exit(0);
  } 
}


char *KkbMain::getLocale() {
  return setlocale(LC_ALL, "");
} 


bool KkbMain::x11EventFilter(XEvent *e) {
  if (e->type==i2) {
    button->setText(configData->current()->getLang(KkbGetState()));
    button->setBackgroundPixmap(configData->current()->getPixmap());
    if (isBeep) {
      // store the old state
      XKeyboardState old_state;
      XGetKeyboardControl(kapp->getDisplay(), &old_state);
      
      // switch to the test state
      XKeyboardControl kbd;
      kbd.bell_percent = 10;
      kbd.bell_pitch = 400;
      kbd.bell_duration = 10;
      XChangeKeyboardControl(kapp->getDisplay(), 
    		     KBBellPercent | KBBellPitch | KBBellDuration,
    		     &kbd);
      // ring bell
      XBell(kapp->getDisplay(),100);
      
      // restore old state
      kbd.bell_percent = old_state.bell_percent;
      kbd.bell_pitch = old_state.bell_pitch;
      kbd.bell_duration = old_state.bell_duration;
      XChangeKeyboardControl(kapp->getDisplay(), 
    		     KBBellPercent | KBBellPitch | KBBellDuration,
    		     &kbd); 
    }
    return TRUE;
  }
#ifdef ACCEL
  if (keys->x11EventFilter(e))
    return TRUE;
#endif
  return KApplication::x11EventFilter(e); 
}

void KkbMain::dobeep() {
  isBeep=!isBeep;
  menu->setItemChecked(beepID, isBeep);
}

void KkbMain::activateMenu(int i) {
  if ((i<menu->count()-2) && (configData->at()!=i)) {
    configData->at(i);
    setXkbLayout();
    button->setText(configData->current()->getLang(KkbGetState()));
    button->setBackgroundPixmap(configData->current()->getPixmap());
  }
}
  
void KkbMain::KkbChangeState() {
  int i=KkbGetState();
  do {
    i++;
  } while (configData->current()->getLang(i%4)=="none");
  XkbLockGroup(display, XkbUseCoreKbd, i%4);
}

KkbButton::KkbButton(QWidget* parent)
  :QLabel(parent)
{
  setAlignment(AlignCenter);
}
 
int main(int argc, char **argv) 
{ 
 
  KkbMain appl(argc, argv);
  return appl.exec();
}
    

