//////////////////////////////////////////////////////////////////////////////
// This software is distributed under the terms of the General Public License.
//
// Program : kless
// Author  : Norbert Drees & Ralf Haferkamp
// E-Mail  : norbert@et-inf.fho-emden.de
//           hafer@et-inf.fho-emden.de
//////////////////////////////////////////////////////////////////////////////

#ifndef KLESS_H
#define KLESS_H

#ifdef KLESSDEBUG
#include <iostream.h>
#endif

#include <fstream.h>
#include <string.h>

// QT
#include <qkeycode.h>
#include <qfileinf.h> 
#include <qdir.h> 
#include <qmsgbox.h>
#include <qpopmenu.h>
#include <qarray.h>

// KDE
#include <kfm.h>
#include <kapp.h>
#include <kmenubar.h>
#include <ktopwidget.h>
#include <kurl.h>
#include <kmsgbox.h> 
#include <klocale.h>
#include <kfontdialog.h>
#include <kfiledialog.h>
#include <kcolordlg.h>

#include "search.h"
#include "textview.h"

#define MIN_WINDOW_WIDTH	400
#define MIN_WINDOW_HEIGHT	300

#define DEFAULT_EDITOR "kedit"
#define DEFAULT_PRINTER "lpr"

#define KLESS_VERSION "1.4.8"

#define MENUITEMS 6 

class KLessWindow : public KTopLevelWidget {

	Q_OBJECT
	
public:

	KLessWindow( QWidget *parent = 0, const char *name = 0 );
	
	void getFile();
	void readFile( QString );
	void readSTDIN();
	void argLoad( const char * );

	static QList<KLessWindow> windowList;
	
private slots:

	void dropEvent( KDNDDropZone * );
	void slotKFMJobDone();
	
	void Load();
	void Reload();
	void SaveAs();
	void Edit();
	void Print();
	void NewWindow();
	void Close();
	void Quit();
	
	void Search();
	void SearchFirst( QString, bool );
	void SearchNext();

	void Tab();	
	void Editor();
	void Printer();
	void Font();
	void bgColor();
	void fgColor();
	void saveOptions();
	
	void About();
	void Help();

	void menubarMoved();
	void SearchClosed();
	
private:	

	KDNDDropZone	*dropZone;
	KFM				*kfmConnection;

	QString			HomeDir;
	QString			data_path;
	QString			CopyToHomeDir;
	QString			name;

	QString			about_picture;

	int 				tab_width;
	
	KMenuBar 		*menubar;
	QPopupMenu		*filemenu;
	QPopupMenu		*searchmenu;
	QPopupMenu		*optionsmenu;
	QPopupMenu		*helpmenu;
	QPopupMenu		*colors;

	int				menuItem[ MENUITEMS ]; // set menuitems: enable/disable
	void				updateMenu();

	KStatusBar		*statusbar;

	SearchDialog	*searchdlg;
	bool				searchdlg_open;
	bool				sense;
	QString			searchText;

	TextView 		*multiedit;
	bool				hasSelectedText();	// is there a marked text region ?

	void				Save( bool );
	void				resizeEvent( QResizeEvent * );
	void				closeEvent( QCloseEvent * );

	void 				runCommand( QString, QString );

};

#endif KLESS_H
