//////////////////////////////////////////////////////////////////////////////
// This software is distributed under the terms of the General Public License.
//
// Program : kless
// Author  : Norbert Drees & Ralf Haferkamp
// E-Mail  : norbert@et-inf.fho-emden.de
//           hafer@et-inf.fho-emden.de
//////////////////////////////////////////////////////////////////////////////

#include "search.h"

SearchDialog::SearchDialog( bool sense, QString txt, QString path,
                            QWidget *parent, const char *name )
	: QWidget( parent , name ), searchText( txt ), picPath( path ) {

	#ifdef KLESSDEBUG
		cout << "void SearchDialog::" << endl;
		cout << "===================" << endl;
		cout << "* searchText : " << searchText << endl;
		cout << "Running search dialog" << endl;
	#endif

	keys = new QAccel( this );
	keys->connectItem( keys->insertItem( CTRL+'E' ), this, SLOT( quit() ) );
	keys->connectItem( keys->insertItem( CTRL+'S' ), this, SLOT( ok() ) );
	next_id = keys->connectItem( keys->insertItem( CTRL+'N' ), this, SLOT( SearchNext() ) );
	keys->setItemEnabled( next_id, false );

	frame = new QFrame( this );
	frame->setFrameStyle( QFrame::Panel | QFrame::Raised );

	searchEdit = new QLineEdit( this );
	searchEdit->setText( searchText );
	searchEdit->setFocus();
	connect( searchEdit, SIGNAL( returnPressed() ), SLOT( ok() ) );
	connect( searchEdit, SIGNAL( textChanged( const char * ) ), SLOT( unsetNext() ) );   

	LedOn.load( picPath + "/led-red.gif" );
	LedOff.load( picPath + "/led-gray.gif" );
	Led = new QLabel( this );
	Led->setPixmap( LedOn );

	LedText = new QLabel( this );
	LedText->setText( klocale->translate( "Next" ) );
	
	casesense  = new QCheckBox( klocale->translate( "Case Sensitive" ), this, "sense" );
	casesense->setAccel( CTRL+'T' );
	casesense->setChecked( sense );
	connect( casesense, SIGNAL( clicked() ), SLOT( unsetNext() ) );

	setTabOrder( searchEdit, casesense );
}

void SearchDialog::resizeEvent( QResizeEvent * ) {

	frame->move( 0, 0 );
	frame->resize( width(), height() );

	searchEdit->move( 5, 5 );
	searchEdit->resize( 200, searchEdit->height() );

	Led->move( 210, 5 );
	Led->resize( 10, 30 );

	LedText->move( 225, 5 );
	LedText->resize( 100, 30 );

	casesense->move( 285, 10 );
	casesense->resize( width() - 290, 20);
	
	searchEdit->selectAll();
	unsetNext();
}

void SearchDialog::quit() {

	#ifdef KLESSDEBUG
		cout << "void SearchDialog::quit()" << endl;
		cout << "=========================" << endl;
		cout << "exit search" << endl;
	#endif
	
	emit SearchClosed();
}

void SearchDialog::ok() {

	searchText = searchEdit->text();
	if( searchText == Key_Return ) {
		return;
	}

	#ifdef KLESSDEBUG
		cout << "void SearchDialog::ok()" << endl;
		cout << "=======================" << endl;
		cout << "searchText : " << searchText << endl;
		cout << "jetzt First" << endl;
	#endif
	emit searchFirst( searchText, casesense->isChecked() );
}

void SearchDialog::setNext() {

	QString text = searchEdit->text();
	if( text == 0 ) {
		return;
	}

	keys->setItemEnabled( next_id, true );
	Led->setPixmap( LedOn );
}

void SearchDialog::unsetNext() {

	searchText = 0;
	keys->setItemEnabled( next_id, false );
	Led->setPixmap( LedOff );
}

void SearchDialog::SearchNext() {

	QString text = searchEdit->text();
	if( text == Key_Return ) {
		unsetNext();
		return;
	}

	if( text == 0 ) {
		unsetNext();
		return;
	}

	if( strcmp( text, searchText ) ) {
		unsetNext();
		return;
	}

	emit searchNext();
}
