//////////////////////////////////////////////////////////////////////////////
// This software is distributed under the terms of the General Public License.
//
// Program : kless
// Author  : Norbert Drees & Ralf Haferkamp
// E-Mail  : norbert@et-inf.fho-emden.de
//           hafer@et-inf.fho-emden.de
//////////////////////////////////////////////////////////////////////////////

#ifndef SEARCH_H
#define SEARCH_H

#ifdef KLESSDEBUG
#include <iostream.h>
#endif

#include <qwidget.h>
#include <qlined.h>
#include <qchkbox.h>
#include <qaccel.h>
#include <qkeycode.h>
#include <qlabel.h>
#include <qpixmap.h>

#include <kapp.h>
#include <klocale.h>

class SearchDialog : public QWidget {

	Q_OBJECT

public:
	SearchDialog(	bool sense = false, QString txt = 0, QString path = 0,
						QWidget *parent = 0, const char *name = 0

	);

private slots:
	void quit();
	void ok();
	void SearchNext();
	void setNext();
	void unsetNext();

signals:
	void searchFirst( QString, bool );
	void searchNext();
	void SearchClosed();

protected:
	void resizeEvent( QResizeEvent * );
  
private:
	QAccel		*keys;
	QLineEdit 	*searchEdit;
	QLabel		*Led;
	QPixmap		LedOn;
	QPixmap		LedOff;
	QLabel		*LedText;
	QCheckBox 	*casesense;
	QFrame		*frame;
	QString 		searchText;
	QString		picPath;
	int 			next_id;
};

#endif
