//////////////////////////////////////////////////////////////////////////////
// This software is distributed under the terms of the General Public License.
//
// Program : kless
// Author  : Norbert Drees & Ralf Haferkamp
// E-Mail  : norbert@et-inf.fho-emden.de
//           hafer@et-inf.fho-emden.de
//////////////////////////////////////////////////////////////////////////////

#include "main.h"
#include <qregexp.h>

#ifdef KLESSDEBUG
#include <iostream.h>
#endif

TextView::TextView( QWidget *parent, const char *name )
	: QMultiLineEdit( parent, name ) {
    
	setReadOnly( TRUE );
	setAutoUpdate( TRUE );
	line = 0;
	col = 0;
}

void TextView::cursorRight( bool mark, bool wrap ) {

	QMultiLineEdit::cursorRight( mark, wrap );
}

void TextView::searchString( QString searchText, bool next, bool sense ) {

	QString lineStr;
	QRegExp RegExp( searchText, sense );
	int i, j, k;
	bool exit_search = false;
	int str_len;		// Laenge des zu suchenden Textes
	int found;			// Position des gefundenen Strings

	if( next ) {		// wiederholte Suche ?
		i = line;
		j = col;
	} else {
		i = 0;
		j = 0;
	}

	for( found = -1 ; found == -1 ; i++, j = 0 ) {
		if( i == numRows() ) { // Ende erreicht ? dann Dialog
			if( again() ) {
				i = 0;
				j = 0;
			} else {
				exit_search = true;
				break;
			}
		}
		lineStr = textLine( i );
		found = RegExp.match( lineStr, j, &str_len );
	}

	if( exit_search == false ) {

		if( found != -1 ) {
			emit Found();
		} else {
			emit notFound();
		}

		line = i - 1;
		col = found + 1;

		#ifdef KLESSDEBUG
			cout << "void TextView::searchString(QString searchText, bool next, bool sense)" << endl;
			cout << "======================================================================" << endl;
			cout << "gefunden in " << i << "," << col << endl;
		#endif

		setCursorPosition( --i, found, false );

		// gefundenen String markieren
		///// str_len = strlen( searchText );
		for( k = 1; k <= str_len; k++) {
			cursorRight( true );
		}
		repaint();
	}
}

bool TextView::again() {

	QMessageBox yesno(
		"KLess",
  		klocale->translate( "End of document reached, continue from beginnig ?" ),
		QMessageBox::NoIcon,
		QMessageBox::Yes | QMessageBox::Default,
		QMessageBox::No,
		0
	);
	yesno.setButtonText( QMessageBox::Yes, klocale->translate( "Yes" ) );
	yesno.setButtonText( QMessageBox::No, klocale->translate( "No" ) );

	if ( yesno.exec() == QMessageBox::No ) {
		return false;	
	}

	return true;
}

bool TextView::hasSelectedText() {

	return this->hasMarkedText();
}

QString TextView::getSelectedText() {

	return this->markedText();
}
