#ifndef _KLDAP_H_
#define _KLDAP_H_

#include <lber.h>
#include <ldap.h>
#include <sys/time.h>
#include "backend.h"

extern const char *ldap2english[][2];

class KLdapEntry : public Entry {
	LDAPMessage *e;
	LDAP *ld;
        void *ptr;

 public:
	KLdapEntry(LDAP *l, LDAPMessage *entry) { ld = l; e = entry;};

	char  *firstAttribute() {
		return ldap_first_attribute(ld, e, (BerElement **) &ptr);
	};

	char *nextAttribute() {
		return ldap_next_attribute(ld, e, (BerElement *) ptr);
	};

	char **getValues(const char *attr) {
		return ldap_get_values(ld, e, attr);
	};

	char *getDn() { return ldap_get_dn(ld, e);};

	char *getField(const char *f);

};

class KLdap : public Backend {
	LDAP *ld;
	LDAPMessage *res, *e;
	int msgid;
	struct timeval t;
public:
        KLdap() {};
	virtual ~KLdap() {};
        KLdap(char *host, int port) { open(host, port); };
	LDAP *open(char *host, int port) {
		return ld = ldap_open(host, port);
	};
	//bind(char *who, char *cred, int method);
	//bind_s(char *who, char *cred, int method);
	//int simple_bind(char *who, char *passwd);
	int simple_bind_s(char *who, char *passwd);
	unbind() { return ldap_unbind(ld);};
	abandon() { return ldap_abandon(ld, msgid); };
	result(int all) { return ldap_result(ld, msgid, all, &t, &res);};
	void setTimeout(time_t nsecs, time_t nusec) { 
		t.tv_sec = nsecs; 
		t.tv_usec = nusec;
	};
	void perror(char *s) { ldap_perror(ld,s);};

	KLdapEntry *firstEntry();
	KLdapEntry *nextEntry();
	static int msgfree(LDAPMessage *m);
	static void value_free(char **v);

	int ldap_search_s(char *base, int scope, char *filter,
			  char *attrs[], int attrsonly) {
		return ::ldap_search_s(ld, base, scope, filter,
				     attrs, attrsonly, &res);
	}

	int lookup(const char *s);
};


#endif // _KLDAP_H_
