#include <stdio.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include "dlgoptions.h"

OptionsDlg::OptionsDlg(TChart* TC, QWidget* parent=0, const char* name=0):
     QDialog (parent, name, TRUE)
{
KIconLoader IconLoader;

   setFixedSize(400,160);
   setCaption(i18n("look@seti Options"));
   Chart=TC;

   ValLab = new QLabel("", this);
   ValLab->setGeometry(340,20,40,20);

   QLabel *UpdateInvervalLab= new QLabel(i18n("Update interval"),this);
   UpdateInvervalLab->setGeometry(20,20,100,20);
   IntervallSlider = new KSlider(1,600, 1, Chart->GetUpdateIntervall()/1000,
                         QSlider::Horizontal, this);
   IntervallSlider->setGeometry(130,20,200,20);
   IntervallSlider->setTickmarks(QSlider::NoMarks);
   connect(IntervallSlider, SIGNAL(valueChanged(int)), this, SLOT(SliderChange(int)));
   SliderChange(Chart->GetUpdateIntervall()/1000);

   QLabel *LoadLab=new QLabel(i18n("Auto load file"), this);
   LoadLab->setGeometry(20,60,100,20);
   QLabel *Load1Lab=new QLabel(i18n("(Leave blank to disable auto loading)"), this);
   Load1Lab->setGeometry(20,80,400,20);
   LoadEdit=new QLineEdit(this);
   LoadEdit->setGeometry(130,60,200,22);
   LoadEdit->setText(Chart->StartupFile);
   SuchBtn = new QPushButton(i18n("Search"), this, "SuchBtn");
   SuchBtn->setGeometry(340,60,50,22);
   connect(SuchBtn, SIGNAL(clicked()), SLOT(SuchBtnClick()) );

   QPushButton *OkBtn = new QPushButton(i18n("OK"), this, "OkBtn");
   OkBtn->setGeometry(30,height()-40,80,30);
   connect(OkBtn, SIGNAL(clicked()), SLOT(accept()) );

   QPushButton *CancelBtn = new QPushButton(i18n("Cancel"), this, "CancelBtn");
   CancelBtn->setGeometry(width()-110,height()-40,80,30);
   connect(CancelBtn, SIGNAL(clicked()), SLOT(reject()) );
}

void OptionsDlg::SliderChange(int Value) {
char S[10];

   sprintf(S,i18n("%d sec"), Value);
   ValLab->setText(S);
}

void OptionsDlg::SuchBtnClick() {
debug("suchbtnclick");
QString Datei = KFileDialog::getOpenFileName("./", "*.seti", this, i18n("Open Autoload Watchlist"));

   if (!Datei.isEmpty())
      LoadEdit->setText(Datei);
}
