/*
    KMLOCfg
    
    A utility to configure the ELSA MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#include "kmlocfg.h"
#include "kmlocfg.moc"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 


#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qkeycode.h>
#include <qstring.h>
#include <qglobal.h>
#include <qlabel.h>

#include <ktopwidget.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kmsgbox.h>
#include <kapp.h>

#include "global.h"
#include "preferences.h"
#include "loaddlg.h"
#include "setupdlg.h"


#define TOOL_ID_DL   0
#define TOOL_ID_UL   1
#define TOOL_ID_EDIT 2



KMLOCfg::KMLOCfg( const char * name ) : KTopLevelWidget( name )
{
	QPixmap pix;
	KIconLoader * kil = mykapp->getIconLoader();
	KsConfig = mykapp->getConfig();

	prefs = new Preferences( 0, "preferences" );
	CHECK_PTR( prefs );
	prefs->reset();

	loaddlg = new LoadDlg( 0, "loaddlg" );
	CHECK_PTR( loaddlg );

	setupdlg = new SetupDlg( 0, "setupdlg" );
	CHECK_PTR( setupdlg );

	QPopupMenu * file_menu = new QPopupMenu( 0, "filemenu" );
	CHECK_PTR( file_menu );
	menu_item_dl = file_menu->insertItem(i18n("&Download"), this, SLOT(downloadCfg()), CTRL+Key_D );
	menu_item_ul = file_menu->insertItem(i18n("&Upload"), this, SLOT(uploadCfg()), CTRL+Key_U );
	file_menu->insertSeparator();
	file_menu->insertItem(i18n("&New"), this, SLOT(newSetup()), CTRL+Key_N);
	menu_item_edit = file_menu->insertItem(i18n("&Edit..."), this, SLOT(showSetup()), CTRL+Key_E);
	file_menu->insertSeparator();
	file_menu->insertItem(i18n("&Quit"), this, SLOT(quit()), CTRL+Key_Q);

	QPopupMenu * opt_menu = new QPopupMenu( 0, "optionsmenu" );
	CHECK_PTR( opt_menu );
	opt_menu->insertItem(i18n("&Preferences..."), this, SLOT(showPrefs()));
	opt_menu->insertSeparator();
	menu_item_tool = opt_menu->insertItem(i18n("Show &Toolbar"), this, SLOT(toggleToolbar()), CTRL+Key_T );
	opt_menu->setItemChecked( menu_item_tool, TRUE );
	menu_item_status = opt_menu->insertItem(i18n("Show &Statusbar"), this, SLOT(toggleStatusbar()), CTRL+Key_S );
	opt_menu->setItemChecked( menu_item_status, TRUE );

	QPopupMenu * help_menu = new QPopupMenu( 0, "helpmenu" );
	CHECK_PTR( help_menu );
	help_menu->insertItem(i18n("&Contents"), this, SLOT(invokeHelp()), Key_F1);
	help_menu->insertSeparator();
	help_menu->insertItem(i18n("&About kmlocfg..."), this, SLOT(showAbout()));

	menuBar = new KMenuBar( this, "menubar" );
	CHECK_PTR( menuBar );
	menuBar->insertItem(i18n("&File"), file_menu);
	menuBar->insertItem(i18n("&Options"), opt_menu);
	menuBar->insertSeparator();
	menuBar->insertItem(i18n("&Help"), help_menu);

	setMenu(menuBar);
	menuBar->show();

	toolBar = new KToolBar( this, "toolbar" );
	CHECK_PTR( toolBar );

	pix = kil->loadIcon("filednl.xpm");
	toolBar->insertButton(pix, TOOL_ID_DL, SIGNAL(clicked()), this, SLOT(downloadCfg()), TRUE, i18n("Download Current Configuration"));
	pix = kil->loadIcon("fileupl.xpm");
	toolBar->insertButton(pix, TOOL_ID_UL, SIGNAL(clicked()), this, SLOT(uploadCfg()), TRUE, i18n("Upload Current Configuration"));
	pix = kil->loadIcon("configure.xpm");
	toolBar->insertButton(pix, TOOL_ID_EDIT, SIGNAL(clicked()), this, SLOT(showSetup()), TRUE, i18n("Edit the Modem's Setup"));
	toolBar->insertSeparator( 3 );
	pix = kil->loadIcon("tick.xpm");
	toolBar->insertButton(pix, 4, SIGNAL(clicked()), this, SLOT(showPrefs()), TRUE, i18n("Preferences"));
	pix = kil->loadIcon("help.xpm");
	toolBar->insertButton(pix, 5, SIGNAL(clicked()), this, SLOT(invokeHelp()), TRUE, i18n("Help Contents"));
	pix = kil->loadIcon("exit.xpm");
	toolBar->insertButton(pix, 6, SIGNAL(clicked()), this, SLOT(quit()), TRUE, i18n("Quit"));
	toolBar->alignItemRight(6, TRUE);

	addToolBar(toolBar);
	toolBar->show();
	toolBarOn = TRUE;

	view = new QLabel( this );
	pix = kil->loadIcon( "mloffice.xpm" );
	view->setPixmap( pix );
	view->setFixedSize( view->sizeHint() );
	setView( view );

	statusBar = new KStatusBar( this, "statusbar" );
	CHECK_PTR( statusBar );
	statusBar->insertItem( "", 0 );
	setStatusBar( statusBar );
	statusBar->show();
	statusBarOn = TRUE;

	newPrefs();
	newSetup();

	menuBar->setItemEnabled( menu_item_ul, FALSE );
	menuBar->setItemEnabled( menu_item_edit, FALSE );

	toolBar->setItemEnabled( TOOL_ID_UL, FALSE );
	toolBar->setItemEnabled( TOOL_ID_EDIT, FALSE );

	connect(prefs, SIGNAL(apply_clicked()), SLOT(newPrefs()));

	connect(loaddlg, SIGNAL(downDone(bool)), SLOT(fetchDownDone(bool)) );
	connect(loaddlg, SIGNAL(upDone(bool)), SLOT(fetchUpDone(bool)) );

	resize( sizeHint() );
	show();
}


KMLOCfg::~KMLOCfg()
{
	delete menuBar;
	delete toolBar;
	delete statusBar;
}


void KMLOCfg::toggleToolbar()
{
	toolBarOn = !toolBarOn;

	menuBar->setItemChecked( menu_item_tool, toolBarOn );
	if (toolBarOn)
		toolBar->show();
	else
		toolBar->hide();
	updateRects();
}


void KMLOCfg::toggleStatusbar()
{
	statusBarOn = !statusBarOn;

	menuBar->setItemChecked( menu_item_status, statusBarOn );
	if (statusBarOn)
		statusBar->show();
	else
		statusBar->hide();
	updateRects();
}


void KMLOCfg::downloadCfg()
{
	if (loaddlg->startDownload( prefs->modDevice(), prefs->modSpeed() )) {
		menuBar->setItemEnabled( menu_item_dl, FALSE );
		menuBar->setItemEnabled( menu_item_ul, FALSE );
		toolBar->setItemEnabled( TOOL_ID_DL, FALSE );
		toolBar->setItemEnabled( TOOL_ID_UL, FALSE );
		statusBar->changeItem( i18n("Loading configuration..."), 0 );
	}
}


void KMLOCfg::uploadCfg()
{
	loaddlg->setConfig( setupdlg->getConfig() );
	if (loaddlg->startUpload( prefs->modDevice(), prefs->modSpeed() )) {
		menuBar->setItemEnabled( menu_item_dl, FALSE );
		menuBar->setItemEnabled( menu_item_ul, FALSE );
		toolBar->setItemEnabled( TOOL_ID_DL, FALSE );
		toolBar->setItemEnabled( TOOL_ID_UL, FALSE );
		statusBar->changeItem( i18n("Saving configuration..."), 0 );
	}
}


void KMLOCfg::newPrefs()
{
	prefs->addToolTips( prefs->genTooltips() );
	setupdlg->addToolTips( prefs->genTooltips() );
}


void KMLOCfg::showPrefs()
{
	if (prefs->isVisible())
		prefs->raise();
	else
		prefs->show();
}


void KMLOCfg::newSetup()
{
	loaddlg->setDefaultConfig();
	setupdlg->setConfig( loaddlg->getConfig() );

	has_config = TRUE;

	menuBar->setItemEnabled( menu_item_ul, has_config );
	menuBar->setItemEnabled( menu_item_edit, has_config );
	toolBar->setItemEnabled( TOOL_ID_UL, has_config );
	toolBar->setItemEnabled( TOOL_ID_EDIT, has_config );
}


void KMLOCfg::showSetup()
{
	if (setupdlg->isVisible())
		setupdlg->raise();
	else
		setupdlg->show();
}


void KMLOCfg::invokeHelp()
{
	mykapp->invokeHTMLHelp("kmlocfg/kmlocfg.html", "");
}


void KMLOCfg::showAbout()
{
	QString msg;

	msg.sprintf("KMLOCfg %s\n", VERSION);
	msg += i18n("Copyright  2000 Oliver Gantz (o.gantz@tu-bs.de).\n\n" \
		"A utility to configure the ELSA MicroLink(tm) Office modem.\n\n" \
		"This program is free software and is distributed under the terms\n" \
		"of the GNU General Public License.\n\n" \
		"ELSA and MicroLink are trademarks of ELSA AG, Aachen.");
	KMsgBox::message(0, i18n("About KMLOCfg"), msg);
}


void KMLOCfg::quit()
{
	mykapp->quit();
}


void KMLOCfg::fetchDownDone( bool success )
{
	if (success) {
		has_config = TRUE;
		setupdlg->setConfig( loaddlg->getConfig() );
		showSetup();
	}	

	menuBar->setItemEnabled( menu_item_dl, TRUE );
	menuBar->setItemEnabled( menu_item_ul, has_config );
	menuBar->setItemEnabled( menu_item_edit, has_config );
	toolBar->setItemEnabled( TOOL_ID_DL, TRUE );
	toolBar->setItemEnabled( TOOL_ID_UL, has_config );
	toolBar->setItemEnabled( TOOL_ID_EDIT, has_config );
	statusBar->changeItem( "", 0 );
}


void KMLOCfg::fetchUpDone( bool success )
{
	menuBar->setItemEnabled( menu_item_dl, TRUE );
	menuBar->setItemEnabled( menu_item_ul, TRUE );
	toolBar->setItemEnabled( TOOL_ID_DL, TRUE );
	toolBar->setItemEnabled( TOOL_ID_UL, TRUE );
	statusBar->changeItem( "", 0 );
}
