/***************************************************************************
                          global.h  -  description                              
                             -------------------                                         
    begin                : Wed Apr 7 1999                                           
    copyright            : (C) 1999 by Norbert Weuster                         
    email                : weuster@uni-duisburg.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

///////////////////////////////////////////////////////////////
// global values

#ifndef GLOBAL_H
#define GLOBAL_H

#define SOURCEADDRESS TRUE
#define DESTINATIONADDRESS FALSE

#include <string>

// #define DEBUG_OUT

enum view_active {NOTHING=0, KOSI, CHAT, TRAFFIC, HEADER, CONF, STATS};

const int MAX_MTU = 8192;

// number of packets to store
const int PACKETMAX = 50;

// const int DEFAULT_UPDATE_DELAY = 50000;
const int UPDATETIME = 2000;  // 2 sec

// every cleantime secs, the inactivecouter is decreased
const int INACTIVETIME  = 5000;  // 5 sec
const int INACTIVECOUNT = 60;  // 60 secs

const char DEFAULTDEVICE[]="eth0";

// const int activityLimit = 10;

// X-Server start port
const int RECXPORT = 6000;

 struct packetcounter {
	  unsigned int packet;
	  unsigned int arp;
	  unsigned int rarp;
	  unsigned int ip;
	  unsigned int tcp;
	  unsigned int udp;
	  unsigned int icmp;
	  unsigned int otherip;
	  unsigned int badip;
	  unsigned int ipx;
	  unsigned int apple;
	  unsigned int netbios;
	  unsigned int others;
      };

      struct bytecounter {
	  unsigned long int packet;
	  unsigned long int arp;
	  unsigned long int rarp;
	  unsigned long int ip;
	  unsigned long int tcp;
	  unsigned long int udp;
	  unsigned long int icmp;
	  unsigned long int otherip;
	  unsigned long int badip;
	  unsigned long int ipx;
	  unsigned long int apple;
	  unsigned long int netbios;
	  unsigned long int others;
      };
      
struct stats {
    string ifName;                  // interface name
    struct packetcounter pcounter;  // packetcounter
    struct bytecounter bcounter;    // bytecounter
};



#endif GLOBAL_H
