/***************************************************************************
                          traficview.h  -  description                              
                             -------------------                                         
    begin                : Fri Apr 16 1999                                           
    copyright            : (C) 1999 by Norbert Weuster                         
    email                : weuster@uni-duisburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KTRAFFICVIEW_H
#define KTRAFFICVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qtimer.h>
#include <qrect.h>
#include <math.h>
#include <qlist.h>
#include <string>
#include <map>

#include "knetdumpdoc.h"

/**
  *@author Norbert Weuster
  */

class KTrafficView : public QWidget  {
    Q_OBJECT

public:
    KTrafficView(QWidget* parent=0, KnetdumpDoc* doc=0, const char *name=0);
    ~KTrafficView();

private:
    void paintEvent(QPaintEvent*);
    void drawNodes (QPainter& p);
    void drawConnections (QPainter& p);
    bool storeNewNode ();
    void calccoordi ();
    QColor getColor ();
    
public slots:
    void startslot ();
    void drawAll();

private slots:
    void drawConns();

signals:
    void gotData ();
    

private:
    bool drawing;
    short int packetNum;
    KnetdumpDoc *pdoc;
    QTimer *drawTimer;
    unsigned int actualSize;

    class Connection {
    public:
        Connection (QString n1, QString n2);
        Connection (QString n1, QString n2, int load);
        ~Connection ();
        bool operator== (const Connection& rhs) const;
        const QString from() const;
        const QString to() const;
        int load () const;
        void reset ();
        void decload ();
        void inc (u_int load);
    private:
        QString a;
        QString b;
        u_int netLoad;
    };

    class ConnList : public list<Connection> {
    public:
        Connection& operator() (const QString &n1, const QString &n2);
    };
    
    ConnList connections;        // connections is a list of Connection           
    
    map<string, double> coordinate;
    
};

#endif
