/***************************************************************************
                          publbase.h  -  description
                             -------------------
    begin                : Fri Sep 24 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PUBLBASE_H
#define PUBLBASE_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <table.h>

/** @author Jan Mueller
  * One tuple from the table publication.
  * See @ref AuthorBase for details.
  */

class PublBase : public Table {
 private:
  PublBase(const PublBase&);
	PublBase& operator=(const PublBase&);	

 	void initNew();
 	void initWhere(const char *where);
 public:
  /** Creates new note.
   */
  PublBase(Sql *conn);
  PublBase(const char *dbname);

  /** Reads row with the SQL-WHERE clause "where". "where" must not return more than one record.
   */
  PublBase(const char *where, Sql *conn);
  PublBase(const char *where, const char *dbname);

  /** Updates row, if data has changed and not readonly-mode.
   */
  virtual ~PublBase();
	const char *getBibTex()					{ return publ()->bibtex.get(); }
	bool  getCreateBibTex()		{ return publ()->createbibtex.get(); }
  const char *getTitle() 					{ return publ()->title.get(); }
  const char *getSubtitle() 			{ return publ()->subtitle.get(); }
  int   getEdition() 					{ return publ()->edition.get(); }
  const char *getEditor() 				{ return publ()->editor.get(); }
  const char *getHowPublished()	 	{ return publ()->howpublished.get(); }
  const char *getOrganization() 	{ return publ()->organization.get(); }
  PublisherName *getPublisher()	 	{
  	Str s("where publisher.oid=");
  	oid2str(publ()->publisher.get(), &s);
	  return getPublisherNames(s);
	}
  const char *getYear() 					{ return publ()->year.get(); }
  const char *getPages() 					{ return publ()->pages.get(); }
  const char *getTranslator() 		{ return publ()->translator.get(); }
  const char *getVolume() 				{ return publ()->volume.get(); }
  const char *getNumber()	 				{ return publ()->number.get(); }
  const char *getMonth() 					{ return publ()->month.get(); }
  const char *getSeries() 				{ return publ()->series.get(); }
  const char *getType() 					{ return publ()->type.get(); }
  const char *getKey() 						{ return publ()->key.get(); }
  const char *getOrgTitle() 			{ return publ()->orgtitle.get(); }
  PublisherName *getOrgPublisher() {
  	Str s("where publisher.oid=");
  	oid2str(publ()->orgpublisher.get(), &s);
	  return getPublisherNames(s);
  }
  const char *getOrgYear() 				{ return publ()->orgyear.get(); }
  const char *getIsbnIssn() 			{ return publ()->isbn_issn.get(); }
  const char *getHidingPlace() 		{ return publ()->hidingplace.get(); }
  const char *getMemo() 					{ return publ()->memo.get(); }
  int   getEntryType() 			{ return publ()->entrytype.get(); }
	AuthorName *getPublAuthors() {
		Str s("where author.oid=publication_author.authorno and publication_author.publicationno=");
  	oid2str(publ()->id.get(), &s);
	  return getAuthorNames(s);
	}
	PartTitle *getPublParts() {
		Str s("where part.publicationno=");
  	oid2str(publ()->id.get(), &s);
		s+=" order by part.partno";
	  return getPartTitles(s);
	}
  const char *getModified() 				{ return publ()->modified.get(); }
  const char *getCreated() 					{ return publ()->created.get(); }
	
	void setBibTex(const char *s)				{ publ()->bibtex.set(s); 				publ()->bibtex.setChanged(); }	
	void setCreateBibTex(bool b)				{ publ()->createbibtex.set(b); 	publ()->createbibtex.setChanged(); }
  void setTitle(const char *s) 				{ publ()->title.set(s); 				publ()->title.setChanged(); }	
  void setSubtitle(const char *s) 		{ publ()->subtitle.set(s); 			publ()->subtitle.setChanged(); }	
  void setEdition(const int i) 				{ publ()->edition.set(i); 			publ()->edition.setChanged(); }	
  void setEdition(const char *s) 			{ publ()->edition.set(s); 			publ()->edition.setChanged(); }	
  void setEditor(const char *s) 			{ publ()->editor.set(s); 				publ()->editor.setChanged(); }	
  void setHowPublished(const char *s) { publ()->howpublished.set(s);	publ()->howpublished.setChanged(); }	
  void setOrganization(const char *s) { publ()->organization.set(s);	publ()->organization.setChanged(); }	
  void setYear(const char *s) 				{ publ()->year.set(s); 					publ()->year.setChanged(); }	
  void setPages(const char *s) 				{ publ()->pages.set(s); 				publ()->pages.setChanged(); }	
  void setTranslator(const char *s) 	{ publ()->translator.set(s); 		publ()->translator.setChanged(); }	
  void setVolume(const char *s) 			{ publ()->volume.set(s); 				publ()->volume.setChanged(); }	
  void setNumber(const char *s) 			{ publ()->number.set(s); 				publ()->number.setChanged(); }	
  void setMonth(const char *s) 				{ publ()->month.set(s); 				publ()->month.setChanged(); }	
  void setSeries(const char *s) 			{ publ()->series.set(s); 				publ()->series.setChanged(); }	
  void setType(const char *s) 				{ publ()->type.set(s); 					publ()->type.setChanged(); }	
  void setKey(const char *s) 					{ publ()->key.set(s); 					publ()->key.setChanged(); }	
  void setOrgTitle(const char *s) 		{ publ()->orgtitle.set(s); 			publ()->orgtitle.setChanged(); }	
  void setOrgYear(const char *s) 			{ publ()->orgyear.set(s); 			publ()->orgyear.setChanged(); }	
  void setIsbnIssn(const char *s) 		{ publ()->isbn_issn.set(s); 		publ()->isbn_issn.setChanged(); }	
  void setHidingPlace(const char *s) 	{ publ()->hidingplace.set(s); 	publ()->hidingplace.setChanged(); }	
  void setMemo(const char *s) 				{ publ()->memo.set(s); 					publ()->memo.setChanged(); }	
  void setEntryType(int i) 						{ publ()->entrytype.set(i); 		publ()->entrytype.setChanged(); }	
  void setPublisher(const Oid o)			{ publ()->publisher.set(o);     publ()->publisher.setChanged(); }
  void setOrgPublisher(const Oid o)		{ publ()->orgpublisher.set(o);  publ()->orgpublisher.setChanged(); }

  virtual const char *getWhereClause() { return _where; }

  Oid createNote();
  Oid createAuthor();
  void insertAuthor(Oid o);
  void removeAuthor(Oid o);
  Oid createPart();
  void deletePart(const char *where);
	Oid createPublisher();
	NoteTitle *getNotes();
  /**  */
  int bibTexIndex(Oid author, Oid publ);
 private:
	KaspaRec *invalid();
  KaspaRec *read(const char *where);
  void write(const char *where, bool block=false);
  void del(Oid o);
  PublRec *publ();
  char *_where;
};


#endif

























