/***************************************************************************
                          cmapelement.cpp
                      -------------------
    description          : Base class for map elements
    begin                : Fri Sep 8 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cmapelement.h"

void CMapElement::setLowHiX(int lowx,int hix)
{
	startx = lowx;
	endx = hix;
}

void CMapElement::setLowHiY(int lowy,int hiy)
{
	starty = lowy;
	endy = hiy;
}


void CMapElement::setCords(int lowx,int lowy,int hix,int hiy)
{
	setLowHiX(lowx,hix);
	setLowHiY(lowy,hiy);
}

bool CMapElement::elementIn(int x1,int y1,int x2,int y2,CMapZone *currentZone)
{
	int startx1,startx2;
 	int starty1,starty2;
 	int endx1,endx2;
 	int endy1,endy2;

 	if (startx<endx)
	{
		startx1 = startx;
		endx1 = endx;
	}
	else
	{
		startx1 = endx;
		endx1 = startx;
	}

 	if (starty<endy)
	{
		starty1 = starty;
		endy1 = endy;
	}
	else
	{
		starty1 = endy;
		endy1 = starty;
	}

	if (x1<x2)
	{
		startx2 = x1;
		endx2 = x2;	
	}
	else
	{
		startx2 = x2;
		endx2 = x1;
	}

	if (y1<y2)
	{
		starty2 = y1;
		endy2 = y2;	
	}
	else
	{
		starty2 = y2;
		endy2 = y1;
	}
	
	return (startx1>=startx2 && starty1>=starty2 && endx1<=endx2 && endy1<=endy2);
}

bool CMapElement::mouseInResize(int x,int y,CMapZone *currentZone)
{
	int startx1;
 	int starty1;
 	int endx1;
 	int endy1;

 	if (starty<endy)
	{
		starty1 = starty;
		endy1 = endy;
	}
	else
	{
		starty1 = endy;
		endy1 = starty;
	}

 	if (startx<endx)
	{
		startx1 = startx;
		endx1 = endx;
	}
	else
	{
		startx1 = endx;
		endx1 = startx;
	}

	 	
 	if (startx1 == endx1)
 	{
 		startx1-=3;
 		endx1+=3;
 	}
 	
 	if (starty1 == endy1)        	
 	{
 		starty1-=3;
 		endy1+=3;
 	}
	
	return (x>=endx1-3 && x<=endx1+3 && y>=endy1-3 && y<=endy1+3);	
}

bool CMapElement::mouseInElement(int x,int y,CMapZone *currentZone)
{
 	int startx1;
 	int starty1;
 	int endx1;
 	int endy1;

 	if (starty<endy)
	{
		starty1 = starty;
		endy1 = endy;
	}
	else
	{
		starty1 = endy;
		endy1 = starty;
	}

 	if (startx<endx)
	{
		startx1 = startx;
		endx1 = endx;
	}
	else
	{
		startx1 = endx;
		endx1 = startx;
	}

	 	
 	if (startx1 == endx1)
 	{
 		startx1-=3;
 		endx1+=3;
 	}
 	
 	if (starty1 == endy1)        	
 	{
 		starty1-=3;
 		endy1+=3;
 	}
	
	return (x>=startx1 && x<=endx1 && y>=starty1 && y<=endy1);	
}

void CMapElement::moveBy(int x,int y)
{
	startx +=x;
	endx +=x;
	starty+=y;
	endy+=y;
}

void CMapElement::setSelected(bool sel)
{	selected = sel; }
