/***************************************************************************
                          dlgoptiongeneral.h
                          -------------------
    description          : General Options Dialog Class
    begin                : Thu Oct 7 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef DLGOPTIONGENERAL_H
#define DLGOPTIONGENERAL_H

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
//Generated area. DO NOT EDIT!!!(end)

#include <qdialog.h>

/**
  * General Options Dialog Class
  *@author Stephan Uhlmann
  *@author Kevin Krammer
  */

class DlgOptionGeneral : public QDialog  {
   Q_OBJECT
public: 
	/** constructor */
	DlgOptionGeneral(QWidget *parent=0, const char *name=0);
	/** destructor */
	~DlgOptionGeneral();

	/** checks/unchecks QCkeckBox for autoReconnect option */
	void setKeepLastInput(bool);
	/** returns the value of the QCheckBox for autoReconnect option */
	bool getKeepLastInput();
	/** checks/unchecks useBeep */
	void setUseBeep(bool u);
	/** gets status of useBeep */
	bool getUseBeep();
  /** set's the intelligentHistory-Checkbox */
  void setIntelligentHistory(bool i);
  /** is intelligent history on or off? */
  bool getIntelligentHistory();
  /** enables the Numpad for Macros */
  void setNumpadMacros(bool b);
  /** returns if Numpad-Macros are enabled or disabled */
  bool getNumpadMacros();
	/** enable or disable autoselect text in inputline on focus */
	void setSelectAllOnFocus(bool b);
	/** returns true if the SelectAllOnFocus-feature is enabled */
	bool getSelectAllOnFocus();
  /** returns true if ping should be enabled */
  bool getPingEnabled();
  /** returns the path (including  filename) */
  QString getPingPath();
  /** Sets data associated to ping configuration */
  void setPingData(QString path, bool enabled);


protected: 
	/** initalizes Dialog (KDevelop generated) */
	void initDialog();
	//Generated area. DO NOT EDIT!!!(begin)
	QGroupBox *charCust_GroupBox;
	QCheckBox *keepLastInput_CheckBox;
	QCheckBox *useBeep_CheckBox;
	QCheckBox *intelligentHistory_CheckBox;
	QCheckBox *NumpadMacros_CheckBox;
	QCheckBox *SelectAllOnFocus_CheckBox;
	QGroupBox *pingGroupBoxPing;
	QLineEdit *pingInput;
	QPushButton *pingChooseButton;
	QCheckBox *pingCheckBox;
	//Generated area. DO NOT EDIT!!!(end)

public slots: // Public slots
  /** slot for the ping enable CheckBoxes signal clicked() */
  void slotPingCheckBoxClicked();
  /** slot for the clicked signal of the '...'-Button */
  void slotPingChooseButtonClicked();
};

#endif
