/***************************************************************************
                          plgtemplate.cpp
                      -------------------
    description          :
    begin                : Mon May 15 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "plgtemplate.h"
#include "../../kmudapi.h"
#include <iostream.h>
#include <qpopupmenu.h>
#include <kapp.h>
#include <kiconloader.h>

extern "C"
{
	PlgTemplate* create();
}

PlgTemplate* create()
{
	return(new PlgTemplate());
}


PlgTemplate::PlgTemplate(){

	name="Template";
	version="0.1";
	description="This is a template plugin for Kmud";
	author="Stephan Uhlmann";
	email="suhlmann@gmx.de";
	homepage="http://www.kmud.de/";
	copyright="Copyright 2000 by Stephan Uhlmann, Licensed under the GPL";

	configurable=true;
}

PlgTemplate::~PlgTemplate(){
}

void PlgTemplate::start()
{
	cout << "Plugin: " << name << " started" << endl;
}

void PlgTemplate::stop()
{
	cout << "Plugin: " << name << " stopped" << endl;
}

QString PlgTemplate::processInput(QString s)
{
	cout << "Plugin: " << name << " got input: " << s << endl;
	return s;
}

QString PlgTemplate::processRawOutput(QString s)
{
	cout << "Plugin: " << name << " got raw output: " << s << endl;
	return s;
}

QString PlgTemplate::processParsedOutput(QString s)
{
	cout << "Plugin: " << name << " got parsed output: " << s << endl;
	return s;
}

void PlgTemplate::callConfigDialog()
{
	cout << "Plugin: " << name << " has nothing to configure." << endl;
}
