/***************************************************************************
                  herschelSPIRE.h  -  data source plugin template
                             -------------------
    begin                : Feb 17 2007
    copyright            : (C) 2007 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HERSCHELSPIRE_H
#define HERSCHELSPIRE_H

#include <kstdatasource.h>
#include <fitsio.h>

typedef struct folderField {
  QString file;
  QString date;
  long frameLo;
  long frames;
  bool operator<(const folderField& field) const {
    return date < field.date;
  }
};

typedef QValueList<folderField> fileList;

typedef struct {
  QString units;
  QString columnName;
  QString tableName;
} field;

class HERSCHELSPIRESource : public KstDataSource {
  public:
    HERSCHELSPIRESource(KConfig *cfg, const QString& filename, const QString& type, const QDomElement& e = QDomElement());
   ~HERSCHELSPIRESource();

    KstObject::UpdateType update(int = -1);
    int                   readField(double *v, const QString &field, int s, int n);
    bool                  isValidField(const QString &field) const;
    int                   samplesPerFrame(const QString &field);
    int                   frameCount(const QString& field = QString::null) const;
    QString               fileType() const;
    void                  save(QTextStream &ts, const QString& indent = QString::null);
    bool                  isEmpty() const;
    bool                  supportsHierarchy() const;
    bool                  reset();
    QString               units(const QString& field);
    virtual QString       configuration(QString setting);
    virtual bool          setConfiguration(QString setting, const QString &value);

    bool                  supportsTimeConversions() const;
    int                   sampleForTime(const KST::ExtDateTime& time, bool *ok = 0L);
    int                   sampleForTime(double ms, bool *ok = 0L);
    KST::ExtDateTime      timeForSample(int sample, bool *ok = 0L);
    double                relativeTimeForSample(int sample, bool *ok = 0L);

    class Config;
    static bool           checkValidHerschelSPIREFile( const QString& filename, HERSCHELSPIRESource::Config *config );
    static bool           checkValidHerschelSPIREFolder( const QString& filename );

  private:
    long                  getNumFrames( fitsfile* ffits, int iNumHeaderDataUnits );
    int                   readFileFrames( const QString& filename, field *fld, double *v, int s, int n );
    int                   readFolderFrames( field *fld, double *v, int s, int n );
    int                   sampleForOBT(double timeIDEF, bool *ok);

    static bool           isHistoryTable( fitsfile* ffits );
    static bool           isValidFilename( const QString& filename, Config *config );
    void                  addToMetadata( fitsfile *ffits, int &iStatus );
    void                  addToFieldList( fitsfile *ffits, const int iNumCols, int &iStatus );
    void                  addTableFile( const QString& filename, fitsfile* ffits, const QString& date );
    bool                  initFolderFile( const QString& filename, bool bAddMetadata );
    bool                  initFile( const QString& filename, bool bAddMetadata );
    bool                  initFile();
    bool                  initFolder();
    bool                  initialize();

    friend class ConfigWidgetHerschelSPIRE;
    mutable Config       *_config;
    QDict<field>          _fields;
    QDict<fileList>       _files;
    double                _dTimeZero;
    double                _dTimeDelta;
    bool                  _bHasTime;
    bool                  _first;
    bool                  _isSingleFile;
    int                   _numFrames;
    int                   _numCols;
};

#endif

