/***************************************************************************
                          rectitem.h  -  description
                             -------------------
    begin                : Sat Apr 28 2001
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RECTITEM_H
#define RECTITEM_H

#include <kplitem.h>

/**
  * Rectangle item class. Class for rectangle decoration items.
  * @author Werner Stille
  */
class RectItem : public DecoItem
{
public: 
  /** Constructor */
  RectItem();
  /**
    * Constructor. Initializes corresponding to autoplot settings.
    * @param aut pointer to structure containing autoplot settings.
    */
  RectItem(Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to plot file.
    * @param plo pointer to KSimpleConfig object containing item data.
    * @param aut pointer to structure containing autoplot settings.
    */
  RectItem(KSimpleConfig* plo, Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to arguments.
    * @param active true for visible item.
    * @param fillStyle > 0 for pattern filled rectangle.
    * @param color color for rectangle.
    * @param x x position in cm.
    * @param y y position in cm.
    * @param w width in cm.
    * @param h height in cm.
    * @param relSize relative line width.
    * @param ang rotation angle in degree.
    */
  RectItem(bool active, int fillStyle, const QString& color,
           double x, double y, double w, double h, double relSize,
           double ang = 0.0);
  /** Destructor */
  ~RectItem();
  virtual ItemTypes iType() const;
  virtual void draw(KplGraph* g);
  virtual void writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const;
  virtual void setText(KplCheckListItem* it, bool* arrays, bool* funcs) const;
  virtual int editItem(QWidget* parent, KplDoc* m, int i);
  virtual KplItem* copy() const;

protected:
  int fillStyle;
  double width, height, dir;

  friend class RectDlg;
};

#endif
