/***************************************************************************
 *                                                                         *
 *   knetworkmanager-state_dbus.h - A NetworkManager frontend for KDE      *
 *   Copyright (C) 2005, 2006 Novell, Inc.                                 *
 *                                                                         *
 *   Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/

#ifndef KNETWORKMANAGER_STATE_DBUS_H
#define KNETWORKMANAGER_STATE_DBUS_H

#include "knetworkmanager.h"
#include "knetworkmanager-state.h"

class StateDBus
{
	public:
	  static void switchWireless           (bool);
	  static void switchMode               (const char*);
	  
	  static bool isNetworkManagerRunning  (void);

	  static void setState                 (NMState);
	  static void getStateCallback         (DBusPendingCall*, void*);
	  static void getState                 (void);
	 
	  static void setWirelessState         (bool);
	  static void getWirelessStateCallback (DBusPendingCall*, void*);
	  static void getWirelessState         (void);
	  
	  static void push                    (KNetworkManager*);

	private:
	  static KNetworkManager* _ctx;
};

#endif /* KNETWORKMANAGER_STATE_DBUS_H */
