#include <qlayout.h>
#include <qvgroupbox.h>
#include <qhbox.h>
#include <qlabel.h>
#include <klocale.h>
#include <kcombobox.h>
#include <kpushbutton.h>
#include <kapplication.h>
#include <kaboutapplication.h>
#include <hdatepp.h>
#include "mainwidget.h"

MainWidget::MainWidget(QWidget* parent) : QWidget(parent)
{
	QVBoxLayout* layout = new QVBoxLayout(this);

	QVGroupBox* groupboxJewishToGregorian = new QVGroupBox
		(i18n("Jewish to Gregorian date"), this);
	QHBox* hboxJewishToGregorianJewish = new QHBox
		(groupboxJewishToGregorian);
	hboxJewishToGregorianJewish->setSpacing(3);
	new QLabel(i18n("Jewish date"), hboxJewishToGregorianJewish);
	m_comboboxJewishToGregorianJewishDay =
		new KComboBox(false, hboxJewishToGregorianJewish);
	for (int hday = 1; hday <= 30; hday++)
	{
		QString num = QString::number(hday);
		m_comboboxJewishToGregorianJewishDay->insertItem(num);
	}
	m_comboboxJewishToGregorianJewishMonth = 
		new KComboBox(false, hboxJewishToGregorianJewish);
	for (int hmonth = 1; hmonth <= 14; hmonth++)
		m_comboboxJewishToGregorianJewishMonth->insertItem
			(getJewishMonthName(hmonth));
	m_lineeditJewishToGregorianJewishYear =
		new KLineEdit(hboxJewishToGregorianJewish);
	m_lineeditJewishToGregorianJewishYear->setMaxLength(4);
	KPushButton* buttonJewishToGregorianConvert =
		new KPushButton(i18n("Convert"),
			hboxJewishToGregorianJewish);
	QHBox* hboxJewishToGregorianGregorian = new QHBox
		(groupboxJewishToGregorian);
	hboxJewishToGregorianGregorian->setSpacing(3);
	new QLabel(i18n("Gregorian date"), hboxJewishToGregorianGregorian);
	m_labelJewishToGregorianGregorian = new QLabel(QString(""),
		hboxJewishToGregorianGregorian);
	layout->addWidget(groupboxJewishToGregorian);

	QVGroupBox* groupboxGregorianToJewish = new QVGroupBox
		(i18n("Gregorian to Jewish date"), this);
	QHBox* hboxGregorianToJewishGregorian = new QHBox
		(groupboxGregorianToJewish);
	hboxGregorianToJewishGregorian->setSpacing(3);
	new QLabel(i18n("Gregorian date"), hboxGregorianToJewishGregorian);
	m_comboboxGregorianToJewishGregorianDay =
		new KComboBox(false, hboxGregorianToJewishGregorian);
	for (int gday = 1; gday <= 31; gday++)
	{
		QString num = QString::number(gday);
		m_comboboxGregorianToJewishGregorianDay->insertItem(num);
	}
	m_comboboxGregorianToJewishGregorianMonth =
		new KComboBox(false, hboxGregorianToJewishGregorian);
	for (int gmonth = 1; gmonth <= 12; gmonth++)
		m_comboboxGregorianToJewishGregorianMonth->insertItem
			(getGregorianMonthName(gmonth));
	m_lineeditGregorianToJewishGregorianYear =
		new KLineEdit(hboxGregorianToJewishGregorian);
	m_lineeditGregorianToJewishGregorianYear->setMaxLength(4);
	KPushButton* buttonGregorianToJewishConvert =
		new KPushButton(i18n("Convert"),
			hboxGregorianToJewishGregorian);
	QHBox* hboxGregorianToJewishJewish = new QHBox
		(groupboxGregorianToJewish);
	hboxGregorianToJewishJewish->setSpacing(3);
	new QLabel(i18n("Jewish date"), hboxGregorianToJewishJewish);
	m_labelGregorianToJewishJewish = new QLabel(QString(""),
		hboxGregorianToJewishJewish);
	layout->addWidget(groupboxGregorianToJewish);

	QHBox* hboxButtons = new QHBox(this);
	KPushButton* buttonClose = new KPushButton(i18n("Close"),
		hboxButtons);
	KPushButton* buttonAbout = new KPushButton(i18n("About this program"),
		hboxButtons);
	layout->addWidget(hboxButtons);

	QObject::connect(buttonJewishToGregorianConvert, SIGNAL(clicked()),
		this, SLOT(slotConvertJewishToGregorian()));
	QObject::connect(buttonGregorianToJewishConvert, SIGNAL(clicked()),
		this, SLOT(slotConvertGregorianToJewish()));
	QObject::connect(buttonClose, SIGNAL(clicked()),
		this, SLOT(slotClose()));
	QObject::connect(buttonAbout, SIGNAL(clicked()),
		this, SLOT(slotAbout()));
}

QString MainWidget::getGregorianMonthName(int month)
{
	switch (month)
	{
		case 1: return i18n("January");
		case 2: return i18n("February");
		case 3: return i18n("March");
		case 4: return i18n("April");
		case 5: return i18n("May");
		case 6: return i18n("June");
		case 7: return i18n("July");
		case 8: return i18n("August");
		case 9: return i18n("September");
		case 10: return i18n("October");
		case 11: return i18n("November");
		case 12: return i18n("December");
	}
	return QString("");
}

QString MainWidget::getJewishMonthName(int month)
{
	switch (month)
	{
		case 1: return i18n("Tishri");
		case 2: return i18n("Heshvan");
		case 3: return i18n("Kislev");
		case 4: return i18n("Tevet");
		case 5: return i18n("Shevat");
		case 6: return i18n("Adar");
		case 7: return i18n("Nisan");
		case 8: return i18n("Iyar");
		case 9: return i18n("Sivan");
		case 10: return i18n("Tammuz");
		case 11: return i18n("Av");
		case 12: return i18n("Elul");
		case 13: return i18n("Adar I");
		case 14: return i18n("Adar II");
	}
	return QString("");
}

void MainWidget::slotConvertJewishToGregorian()
{
	int hday = m_comboboxJewishToGregorianJewishDay->currentItem()+1;
	int hmonth = m_comboboxJewishToGregorianJewishMonth->currentItem()+1;
	QString hyearStr = m_lineeditJewishToGregorianJewishYear->text();
	bool ok;
	int hyear = hyearStr.toInt(&ok);
	if (ok)
	{
		hdate::Hdate thedate;
		thedate.set_hdate(hday, hmonth, hyear);
		int gday = thedate.get_gday();
		int gmonth = thedate.get_gmonth();
		int gyear = thedate.get_gyear();

		QString resultDayStr = QString::number(gday);
		QString resultMonthStr = getGregorianMonthName(gmonth);
		QString resultYearStr = QString::number(gyear);
		QString resultStr = i18n("%1 %2 %3")
			.arg(resultDayStr).arg(resultMonthStr)
			.arg(resultYearStr);
		m_labelJewishToGregorianGregorian->setText(resultStr);
	}
}

void MainWidget::slotConvertGregorianToJewish()
{
	int gday = m_comboboxGregorianToJewishGregorianDay->currentItem()+1;
	int gmonth = m_comboboxGregorianToJewishGregorianMonth->currentItem()+1;
	QString gyearStr = m_lineeditGregorianToJewishGregorianYear->text();
	bool ok;
	int gyear = gyearStr.toInt(&ok);
	if (ok)
	{
		hdate::Hdate thedate;
		thedate.set_gdate(gday, gmonth, gyear);
		int hday = thedate.get_hday();
		int hmonth = thedate.get_hmonth();
		int hyear = thedate.get_hyear();

		QString resultDayStr = QString::number(hday);
		QString resultMonthStr = getJewishMonthName(hmonth);
		QString resultYearStr = QString::number(hyear);
		QString resultStr = i18n("%1 %2 %3")
			.arg(resultDayStr).arg(resultMonthStr)
			.arg(resultYearStr);
		m_labelGregorianToJewishJewish->setText(resultStr);
	}
}

void MainWidget::slotClose()
{
	kapp->quit();
}

void MainWidget::slotAbout()
{
	KAboutApplication* aboutApp = new KAboutApplication(this);
	aboutApp->exec();
}

