/* Copyright (C) 2002 Philippe Fremy <pfremy@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/


#include "vimwidget.h"
#include "vimpart.h"

#include <kparts/partmanager.h>
#include <kparts/mainwindow.h>

#include <kapp.h>
#include <kdebug.h>
#include <klocale.h>
#include <kstddirs.h>


VimPart::VimPart( QWidget * parent, const char * name )
 : KParts::ReadWritePart( parent, name )
{
  KInstance * instance = new KInstance( "vimpart" );
  setInstance( instance );

  setXMLFile("vimpartui.rc");

  _vimWidget = new VimWidget(  parent, "VimWidget" );
  //_vimWidget = new VimWidget( "/bin/vim", parent, "VimWidget" );
  //_vimWidget = new VimWidget( "/bin/echo", parent, "VimWidget" );
    
  setWidget( _vimWidget );

  (void) new KAction( "Vimpart Hop", 0, actionCollection(), "vimpart_hop" );
  (void) new KAction( "Vimpart Blah", 0, actionCollection(), "p1_blah" );

  //setReadWrite( true );
  _vimWidget->setFocus();
}

VimPart::~VimPart()
{
    widget()->close();
}

void VimPart::setReadWrite( bool rw )
{
    _vimWidget->setReadWrite( rw );
}

bool VimPart::openFile()
{
	// We could check if the file is readable and accessible.
  _vimWidget->openFile(m_file );
  return true;
}

bool VimPart::saveFile()
{
	// We could check if the file is readable and accessible.
  _vimWidget->saveFile();
  return true;
}

//#include "vimpart.moc"
