/*
  Copyright 2008 Brad Hards <bradh@frogmouth.net>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "pyemf_tests.h"
#include <EnhMetaFile.h>

using namespace EnhancedMetafile;

void PyEmfTests::test1()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(2401, 1801) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 1 , penStyle: 0 width: 1 color: QColor(ARGB 1, 1, 0, 0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,0 2401x1801) (QPoint(0,1800) ,  QPoint(2400,0) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,0 2401x1801) (QPoint(0,0) ,  QPoint(2400,1800) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-1.emf") ) );
}

void PyEmfTests::testArcChordPie()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(2401, 1801) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEBRUSHINDIRECT: 1 style: 0 Colour: QColor(ARGB 1, 0.498039, 0, 1) , Hatch: 4 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 2 , penStyle: 1 width: 1 color: QColor(ARGB 1, 0, 0.501961, 0.501961) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARC QRect(100,100 301x301) QPoint(100,100) QPoint(100,400) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CHORD QRect(400,400 301x301) QPoint(400,400) QPoint(400,700) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_PIE QRect(700,700 301x301) QPoint(700,700) QPoint(700,1000) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ELLIPSE: QRect(1000,700 301x301) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-arc-chord-pie.emf") ) );
}

void PyEmfTests::testDeleteObject()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(801, 601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 1 , penStyle: 0 width: 0 color: QColor(ARGB 1, 0, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 2 , penStyle: 0 width: 1 color: QColor(ARGB 1, 0.0627451, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 3 , penStyle: 0 width: 2 color: QColor(ARGB 1, 0.12549, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 4 , penStyle: 0 width: 3 color: QColor(ARGB 1, 0.188235, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 5 , penStyle: 0 width: 4 color: QColor(ARGB 1, 0.25098, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 6 , penStyle: 0 width: 5 color: QColor(ARGB 1, 0.313725, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 7 , penStyle: 0 width: 6 color: QColor(ARGB 1, 0.376471, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 8 , penStyle: 0 width: 7 color: QColor(ARGB 1, 0.439216, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 9 , penStyle: 0 width: 8 color: QColor(ARGB 1, 0.501961, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 10 , penStyle: 0 width: 9 color: QColor(ARGB 1, 0.564706, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 11 , penStyle: 0 width: 10 color: QColor(ARGB 1, 0.627451, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 12 , penStyle: 0 width: 11 color: QColor(ARGB 1, 0.690196, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 13 , penStyle: 0 width: 12 color: QColor(ARGB 1, 0.752941, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 14 , penStyle: 0 width: 13 color: QColor(ARGB 1, 0.815686, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 15 , penStyle: 0 width: 14 color: QColor(ARGB 1, 0.878431, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 16 , penStyle: 0 width: 15 color: QColor(ARGB 1, 0.941176, 0.12549, 0.25098) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,0 401x1) (QPoint(0,0) ,  QPoint(400,0) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,32 401x1) (QPoint(0,32) ,  QPoint(400,32) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 3 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,64 401x1) (QPoint(0,64) ,  QPoint(400,64) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 4 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,96 401x1) (QPoint(0,96) ,  QPoint(400,96) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 5 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,128 401x1) (QPoint(0,128) ,  QPoint(400,128) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 6 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,160 401x1) (QPoint(0,160) ,  QPoint(400,160) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 7 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,192 401x1) (QPoint(0,192) ,  QPoint(400,192) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 8 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,224 401x1) (QPoint(0,224) ,  QPoint(400,224) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 9 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,256 401x1) (QPoint(0,256) ,  QPoint(400,256) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 10 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,288 401x1) (QPoint(0,288) ,  QPoint(400,288) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 11 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,320 401x1) (QPoint(0,320) ,  QPoint(400,320) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 12 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,352 401x1) (QPoint(0,352) ,  QPoint(400,352) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 13 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,384 401x1) (QPoint(0,384) ,  QPoint(400,384) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 14 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,416 401x1) (QPoint(0,416) ,  QPoint(400,416) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 15 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,448 401x1) (QPoint(0,448) ,  QPoint(400,448) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 16 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,480 401x1) (QPoint(0,480) ,  QPoint(400,480) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_DELETEOBJECT: 5 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_DELETEOBJECT: 11 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_DELETEOBJECT: 3 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_DELETEOBJECT: 9 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_DELETEOBJECT: 16 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 16 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.941176, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 11 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.878431, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 9 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.815686, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 5 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.752941, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 3 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.690196, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 17 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.627451, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 18 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.564706, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 19 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.501961, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 20 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.439216, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 21 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.376471, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 22 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.313725, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 23 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.25098, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 24 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.188235, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 25 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.12549, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 26 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0.0627451, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 27 , penStyle: 1 width: 8 color: QColor(ARGB 1, 0.00392157, 0, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,0 401x1) (QPoint(400,0) ,  QPoint(800,0) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,32 401x1) (QPoint(400,32) ,  QPoint(800,32) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 3 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,64 401x1) (QPoint(400,64) ,  QPoint(800,64) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 4 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,96 401x1) (QPoint(400,96) ,  QPoint(800,96) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 5 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,128 401x1) (QPoint(400,128) ,  QPoint(800,128) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 6 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,160 401x1) (QPoint(400,160) ,  QPoint(800,160) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 7 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,192 401x1) (QPoint(400,192) ,  QPoint(800,192) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 8 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,224 401x1) (QPoint(400,224) ,  QPoint(800,224) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 9 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,256 401x1) (QPoint(400,256) ,  QPoint(800,256) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 10 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,288 401x1) (QPoint(400,288) ,  QPoint(800,288) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 11 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,320 401x1) (QPoint(400,320) ,  QPoint(800,320) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 12 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,352 401x1) (QPoint(400,352) ,  QPoint(800,352) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 13 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,384 401x1) (QPoint(400,384) ,  QPoint(800,384) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 14 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,416 401x1) (QPoint(400,416) ,  QPoint(800,416) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 15 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,448 401x1) (QPoint(400,448) ,  QPoint(800,448) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 16 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(400,480 401x1) (QPoint(400,480) ,  QPoint(800,480) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-deleteobject.emf") ) );
}

void PyEmfTests::testSetPixel()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(801, 601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(150,75) QColor(ARGB 1, 0.501961, 0.588235, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(151,75) QColor(ARGB 1, 0.501961, 0.592157, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(152,76) QColor(ARGB 1, 0.501961, 0.596078, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(153,76) QColor(ARGB 1, 0.501961, 0.6, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(154,77) QColor(ARGB 1, 0.501961, 0.603922, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(155,77) QColor(ARGB 1, 0.501961, 0.607843, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(156,78) QColor(ARGB 1, 0.501961, 0.611765, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(157,78) QColor(ARGB 1, 0.501961, 0.615686, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(158,79) QColor(ARGB 1, 0.501961, 0.619608, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(159,79) QColor(ARGB 1, 0.501961, 0.623529, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(160,80) QColor(ARGB 1, 0.501961, 0.627451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(161,80) QColor(ARGB 1, 0.501961, 0.631373, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(162,81) QColor(ARGB 1, 0.501961, 0.635294, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(163,81) QColor(ARGB 1, 0.501961, 0.639216, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(164,82) QColor(ARGB 1, 0.501961, 0.643137, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(165,82) QColor(ARGB 1, 0.501961, 0.647059, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(166,83) QColor(ARGB 1, 0.501961, 0.65098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(167,83) QColor(ARGB 1, 0.501961, 0.654902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(168,84) QColor(ARGB 1, 0.501961, 0.658824, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(169,84) QColor(ARGB 1, 0.501961, 0.662745, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(170,85) QColor(ARGB 1, 0.501961, 0.666667, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(171,85) QColor(ARGB 1, 0.501961, 0.670588, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(172,86) QColor(ARGB 1, 0.501961, 0.67451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(173,86) QColor(ARGB 1, 0.501961, 0.678431, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(174,87) QColor(ARGB 1, 0.501961, 0.682353, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(175,87) QColor(ARGB 1, 0.501961, 0.686275, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(176,88) QColor(ARGB 1, 0.501961, 0.690196, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(177,88) QColor(ARGB 1, 0.501961, 0.694118, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(178,89) QColor(ARGB 1, 0.501961, 0.698039, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(179,89) QColor(ARGB 1, 0.501961, 0.701961, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(180,90) QColor(ARGB 1, 0.501961, 0.705882, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(181,90) QColor(ARGB 1, 0.501961, 0.709804, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(182,91) QColor(ARGB 1, 0.501961, 0.713725, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(183,91) QColor(ARGB 1, 0.501961, 0.717647, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(184,92) QColor(ARGB 1, 0.501961, 0.721569, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(185,92) QColor(ARGB 1, 0.501961, 0.72549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(186,93) QColor(ARGB 1, 0.501961, 0.729412, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(187,93) QColor(ARGB 1, 0.501961, 0.733333, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(188,94) QColor(ARGB 1, 0.501961, 0.737255, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(189,94) QColor(ARGB 1, 0.501961, 0.741176, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(190,95) QColor(ARGB 1, 0.501961, 0.745098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(191,95) QColor(ARGB 1, 0.501961, 0.74902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(192,96) QColor(ARGB 1, 0.501961, 0.752941, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(193,96) QColor(ARGB 1, 0.501961, 0.756863, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(194,97) QColor(ARGB 1, 0.501961, 0.760784, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(195,97) QColor(ARGB 1, 0.501961, 0.764706, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(196,98) QColor(ARGB 1, 0.501961, 0.768627, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(197,98) QColor(ARGB 1, 0.501961, 0.772549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(198,99) QColor(ARGB 1, 0.501961, 0.776471, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(199,99) QColor(ARGB 1, 0.501961, 0.780392, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(200,100) QColor(ARGB 1, 0.501961, 0.784314, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(201,100) QColor(ARGB 1, 0.501961, 0.788235, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(202,101) QColor(ARGB 1, 0.501961, 0.792157, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(203,101) QColor(ARGB 1, 0.501961, 0.796078, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(204,102) QColor(ARGB 1, 0.501961, 0.8, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(205,102) QColor(ARGB 1, 0.501961, 0.803922, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(206,103) QColor(ARGB 1, 0.501961, 0.807843, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(207,103) QColor(ARGB 1, 0.501961, 0.811765, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(208,104) QColor(ARGB 1, 0.501961, 0.815686, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(209,104) QColor(ARGB 1, 0.501961, 0.819608, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(210,105) QColor(ARGB 1, 0.501961, 0.823529, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(211,105) QColor(ARGB 1, 0.501961, 0.827451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(212,106) QColor(ARGB 1, 0.501961, 0.831373, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(213,106) QColor(ARGB 1, 0.501961, 0.835294, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(214,107) QColor(ARGB 1, 0.501961, 0.839216, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(215,107) QColor(ARGB 1, 0.501961, 0.843137, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(216,108) QColor(ARGB 1, 0.501961, 0.847059, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(217,108) QColor(ARGB 1, 0.501961, 0.85098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(218,109) QColor(ARGB 1, 0.501961, 0.854902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(219,109) QColor(ARGB 1, 0.501961, 0.858824, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(220,110) QColor(ARGB 1, 0.501961, 0.862745, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(221,110) QColor(ARGB 1, 0.501961, 0.866667, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(222,111) QColor(ARGB 1, 0.501961, 0.870588, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(223,111) QColor(ARGB 1, 0.501961, 0.87451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(224,112) QColor(ARGB 1, 0.501961, 0.878431, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(225,112) QColor(ARGB 1, 0.501961, 0.882353, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(226,113) QColor(ARGB 1, 0.501961, 0.886275, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(227,113) QColor(ARGB 1, 0.501961, 0.890196, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(228,114) QColor(ARGB 1, 0.501961, 0.894118, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(229,114) QColor(ARGB 1, 0.501961, 0.898039, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(230,115) QColor(ARGB 1, 0.501961, 0.901961, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(231,115) QColor(ARGB 1, 0.501961, 0.905882, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(232,116) QColor(ARGB 1, 0.501961, 0.909804, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(233,116) QColor(ARGB 1, 0.501961, 0.913725, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(234,117) QColor(ARGB 1, 0.501961, 0.917647, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(235,117) QColor(ARGB 1, 0.501961, 0.921569, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(236,118) QColor(ARGB 1, 0.501961, 0.92549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(237,118) QColor(ARGB 1, 0.501961, 0.929412, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(238,119) QColor(ARGB 1, 0.501961, 0.933333, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(239,119) QColor(ARGB 1, 0.501961, 0.937255, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(240,120) QColor(ARGB 1, 0.501961, 0.941176, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(241,120) QColor(ARGB 1, 0.501961, 0.945098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(242,121) QColor(ARGB 1, 0.501961, 0.94902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(243,121) QColor(ARGB 1, 0.501961, 0.952941, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(244,122) QColor(ARGB 1, 0.501961, 0.956863, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(245,122) QColor(ARGB 1, 0.501961, 0.960784, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(246,123) QColor(ARGB 1, 0.501961, 0.964706, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(247,123) QColor(ARGB 1, 0.501961, 0.968627, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(248,124) QColor(ARGB 1, 0.501961, 0.972549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(249,124) QColor(ARGB 1, 0.501961, 0.976471, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(250,125) QColor(ARGB 1, 0.501961, 0.980392, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(251,125) QColor(ARGB 1, 0.501961, 0.984314, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(252,126) QColor(ARGB 1, 0.501961, 0.988235, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(253,126) QColor(ARGB 1, 0.501961, 0.992157, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(254,127) QColor(ARGB 1, 0.501961, 0.996078, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(255,127) QColor(ARGB 1, 0.501961, 1, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(256,128) QColor(ARGB 1, 0.501961, 0, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(257,128) QColor(ARGB 1, 0.501961, 0.00392157, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(258,129) QColor(ARGB 1, 0.501961, 0.00784314, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(259,129) QColor(ARGB 1, 0.501961, 0.0117647, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(260,130) QColor(ARGB 1, 0.501961, 0.0156863, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(261,130) QColor(ARGB 1, 0.501961, 0.0196078, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(262,131) QColor(ARGB 1, 0.501961, 0.0235294, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(263,131) QColor(ARGB 1, 0.501961, 0.027451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(264,132) QColor(ARGB 1, 0.501961, 0.0313725, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(265,132) QColor(ARGB 1, 0.501961, 0.0352941, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(266,133) QColor(ARGB 1, 0.501961, 0.0392157, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(267,133) QColor(ARGB 1, 0.501961, 0.0431373, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(268,134) QColor(ARGB 1, 0.501961, 0.0470588, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(269,134) QColor(ARGB 1, 0.501961, 0.0509804, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(270,135) QColor(ARGB 1, 0.501961, 0.054902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(271,135) QColor(ARGB 1, 0.501961, 0.0588235, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(272,136) QColor(ARGB 1, 0.501961, 0.0627451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(273,136) QColor(ARGB 1, 0.501961, 0.0666667, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(274,137) QColor(ARGB 1, 0.501961, 0.0705882, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(275,137) QColor(ARGB 1, 0.501961, 0.0745098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(276,138) QColor(ARGB 1, 0.501961, 0.0784314, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(277,138) QColor(ARGB 1, 0.501961, 0.0823529, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(278,139) QColor(ARGB 1, 0.501961, 0.0862745, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(279,139) QColor(ARGB 1, 0.501961, 0.0901961, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(280,140) QColor(ARGB 1, 0.501961, 0.0941176, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(281,140) QColor(ARGB 1, 0.501961, 0.0980392, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(282,141) QColor(ARGB 1, 0.501961, 0.101961, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(283,141) QColor(ARGB 1, 0.501961, 0.105882, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(284,142) QColor(ARGB 1, 0.501961, 0.109804, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(285,142) QColor(ARGB 1, 0.501961, 0.113725, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(286,143) QColor(ARGB 1, 0.501961, 0.117647, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(287,143) QColor(ARGB 1, 0.501961, 0.121569, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(288,144) QColor(ARGB 1, 0.501961, 0.12549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(289,144) QColor(ARGB 1, 0.501961, 0.129412, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(290,145) QColor(ARGB 1, 0.501961, 0.133333, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(291,145) QColor(ARGB 1, 0.501961, 0.137255, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(292,146) QColor(ARGB 1, 0.501961, 0.141176, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(293,146) QColor(ARGB 1, 0.501961, 0.145098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(294,147) QColor(ARGB 1, 0.501961, 0.14902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(295,147) QColor(ARGB 1, 0.501961, 0.152941, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(296,148) QColor(ARGB 1, 0.501961, 0.156863, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(297,148) QColor(ARGB 1, 0.501961, 0.160784, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(298,149) QColor(ARGB 1, 0.501961, 0.164706, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(299,149) QColor(ARGB 1, 0.501961, 0.168627, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(300,150) QColor(ARGB 1, 0.501961, 0.172549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(301,150) QColor(ARGB 1, 0.501961, 0.176471, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(302,151) QColor(ARGB 1, 0.501961, 0.180392, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(303,151) QColor(ARGB 1, 0.501961, 0.184314, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(304,152) QColor(ARGB 1, 0.501961, 0.188235, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(305,152) QColor(ARGB 1, 0.501961, 0.192157, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(306,153) QColor(ARGB 1, 0.501961, 0.196078, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(307,153) QColor(ARGB 1, 0.501961, 0.2, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(308,154) QColor(ARGB 1, 0.501961, 0.203922, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(309,154) QColor(ARGB 1, 0.501961, 0.207843, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(310,155) QColor(ARGB 1, 0.501961, 0.211765, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(311,155) QColor(ARGB 1, 0.501961, 0.215686, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(312,156) QColor(ARGB 1, 0.501961, 0.219608, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(313,156) QColor(ARGB 1, 0.501961, 0.223529, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(314,157) QColor(ARGB 1, 0.501961, 0.227451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(315,157) QColor(ARGB 1, 0.501961, 0.231373, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(316,158) QColor(ARGB 1, 0.501961, 0.235294, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(317,158) QColor(ARGB 1, 0.501961, 0.239216, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(318,159) QColor(ARGB 1, 0.501961, 0.243137, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(319,159) QColor(ARGB 1, 0.501961, 0.247059, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(320,160) QColor(ARGB 1, 0.501961, 0.25098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(321,160) QColor(ARGB 1, 0.501961, 0.254902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(322,161) QColor(ARGB 1, 0.501961, 0.258824, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(323,161) QColor(ARGB 1, 0.501961, 0.262745, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(324,162) QColor(ARGB 1, 0.501961, 0.266667, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(325,162) QColor(ARGB 1, 0.501961, 0.270588, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(326,163) QColor(ARGB 1, 0.501961, 0.27451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(327,163) QColor(ARGB 1, 0.501961, 0.278431, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(328,164) QColor(ARGB 1, 0.501961, 0.282353, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(329,164) QColor(ARGB 1, 0.501961, 0.286275, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(330,165) QColor(ARGB 1, 0.501961, 0.290196, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(331,165) QColor(ARGB 1, 0.501961, 0.294118, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(332,166) QColor(ARGB 1, 0.501961, 0.298039, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(333,166) QColor(ARGB 1, 0.501961, 0.301961, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(334,167) QColor(ARGB 1, 0.501961, 0.305882, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(335,167) QColor(ARGB 1, 0.501961, 0.309804, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(336,168) QColor(ARGB 1, 0.501961, 0.313725, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(337,168) QColor(ARGB 1, 0.501961, 0.317647, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(338,169) QColor(ARGB 1, 0.501961, 0.321569, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(339,169) QColor(ARGB 1, 0.501961, 0.32549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(340,170) QColor(ARGB 1, 0.501961, 0.329412, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(341,170) QColor(ARGB 1, 0.501961, 0.333333, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(342,171) QColor(ARGB 1, 0.501961, 0.337255, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(343,171) QColor(ARGB 1, 0.501961, 0.341176, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(344,172) QColor(ARGB 1, 0.501961, 0.345098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(345,172) QColor(ARGB 1, 0.501961, 0.34902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(346,173) QColor(ARGB 1, 0.501961, 0.352941, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(347,173) QColor(ARGB 1, 0.501961, 0.356863, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(348,174) QColor(ARGB 1, 0.501961, 0.360784, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(349,174) QColor(ARGB 1, 0.501961, 0.364706, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(350,175) QColor(ARGB 1, 0.501961, 0.368627, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(351,175) QColor(ARGB 1, 0.501961, 0.372549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(352,176) QColor(ARGB 1, 0.501961, 0.376471, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(353,176) QColor(ARGB 1, 0.501961, 0.380392, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(354,177) QColor(ARGB 1, 0.501961, 0.384314, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(355,177) QColor(ARGB 1, 0.501961, 0.388235, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(356,178) QColor(ARGB 1, 0.501961, 0.392157, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(357,178) QColor(ARGB 1, 0.501961, 0.396078, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(358,179) QColor(ARGB 1, 0.501961, 0.4, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(359,179) QColor(ARGB 1, 0.501961, 0.403922, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(360,180) QColor(ARGB 1, 0.501961, 0.407843, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(361,180) QColor(ARGB 1, 0.501961, 0.411765, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(362,181) QColor(ARGB 1, 0.501961, 0.415686, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(363,181) QColor(ARGB 1, 0.501961, 0.419608, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(364,182) QColor(ARGB 1, 0.501961, 0.423529, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(365,182) QColor(ARGB 1, 0.501961, 0.427451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(366,183) QColor(ARGB 1, 0.501961, 0.431373, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(367,183) QColor(ARGB 1, 0.501961, 0.435294, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(368,184) QColor(ARGB 1, 0.501961, 0.439216, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(369,184) QColor(ARGB 1, 0.501961, 0.443137, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(370,185) QColor(ARGB 1, 0.501961, 0.447059, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(371,185) QColor(ARGB 1, 0.501961, 0.45098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(372,186) QColor(ARGB 1, 0.501961, 0.454902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(373,186) QColor(ARGB 1, 0.501961, 0.458824, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(374,187) QColor(ARGB 1, 0.501961, 0.462745, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(375,187) QColor(ARGB 1, 0.501961, 0.466667, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(376,188) QColor(ARGB 1, 0.501961, 0.470588, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(377,188) QColor(ARGB 1, 0.501961, 0.47451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(378,189) QColor(ARGB 1, 0.501961, 0.478431, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(379,189) QColor(ARGB 1, 0.501961, 0.482353, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(380,190) QColor(ARGB 1, 0.501961, 0.486275, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(381,190) QColor(ARGB 1, 0.501961, 0.490196, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(382,191) QColor(ARGB 1, 0.501961, 0.494118, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(383,191) QColor(ARGB 1, 0.501961, 0.498039, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(384,192) QColor(ARGB 1, 0.501961, 0.501961, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(385,192) QColor(ARGB 1, 0.501961, 0.505882, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(386,193) QColor(ARGB 1, 0.501961, 0.509804, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(387,193) QColor(ARGB 1, 0.501961, 0.513725, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(388,194) QColor(ARGB 1, 0.501961, 0.517647, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(389,194) QColor(ARGB 1, 0.501961, 0.521569, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(390,195) QColor(ARGB 1, 0.501961, 0.52549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(391,195) QColor(ARGB 1, 0.501961, 0.529412, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(392,196) QColor(ARGB 1, 0.501961, 0.533333, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(393,196) QColor(ARGB 1, 0.501961, 0.537255, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(394,197) QColor(ARGB 1, 0.501961, 0.541176, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(395,197) QColor(ARGB 1, 0.501961, 0.545098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(396,198) QColor(ARGB 1, 0.501961, 0.54902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(397,198) QColor(ARGB 1, 0.501961, 0.552941, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(398,199) QColor(ARGB 1, 0.501961, 0.556863, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(399,199) QColor(ARGB 1, 0.501961, 0.560784, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(400,200) QColor(ARGB 1, 0.501961, 0.564706, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(401,200) QColor(ARGB 1, 0.501961, 0.568627, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(402,201) QColor(ARGB 1, 0.501961, 0.572549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(403,201) QColor(ARGB 1, 0.501961, 0.576471, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(404,202) QColor(ARGB 1, 0.501961, 0.580392, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(405,202) QColor(ARGB 1, 0.501961, 0.584314, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(406,203) QColor(ARGB 1, 0.501961, 0.588235, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(407,203) QColor(ARGB 1, 0.501961, 0.592157, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(408,204) QColor(ARGB 1, 0.501961, 0.596078, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(409,204) QColor(ARGB 1, 0.501961, 0.6, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(410,205) QColor(ARGB 1, 0.501961, 0.603922, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(411,205) QColor(ARGB 1, 0.501961, 0.607843, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(412,206) QColor(ARGB 1, 0.501961, 0.611765, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(413,206) QColor(ARGB 1, 0.501961, 0.615686, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(414,207) QColor(ARGB 1, 0.501961, 0.619608, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(415,207) QColor(ARGB 1, 0.501961, 0.623529, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(416,208) QColor(ARGB 1, 0.501961, 0.627451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(417,208) QColor(ARGB 1, 0.501961, 0.631373, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(418,209) QColor(ARGB 1, 0.501961, 0.635294, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(419,209) QColor(ARGB 1, 0.501961, 0.639216, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(420,210) QColor(ARGB 1, 0.501961, 0.643137, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(421,210) QColor(ARGB 1, 0.501961, 0.647059, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(422,211) QColor(ARGB 1, 0.501961, 0.65098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(423,211) QColor(ARGB 1, 0.501961, 0.654902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(424,212) QColor(ARGB 1, 0.501961, 0.658824, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(425,212) QColor(ARGB 1, 0.501961, 0.662745, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(426,213) QColor(ARGB 1, 0.501961, 0.666667, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(427,213) QColor(ARGB 1, 0.501961, 0.670588, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(428,214) QColor(ARGB 1, 0.501961, 0.67451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(429,214) QColor(ARGB 1, 0.501961, 0.678431, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(430,215) QColor(ARGB 1, 0.501961, 0.682353, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(431,215) QColor(ARGB 1, 0.501961, 0.686275, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(432,216) QColor(ARGB 1, 0.501961, 0.690196, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(433,216) QColor(ARGB 1, 0.501961, 0.694118, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(434,217) QColor(ARGB 1, 0.501961, 0.698039, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(435,217) QColor(ARGB 1, 0.501961, 0.701961, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(436,218) QColor(ARGB 1, 0.501961, 0.705882, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(437,218) QColor(ARGB 1, 0.501961, 0.709804, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(438,219) QColor(ARGB 1, 0.501961, 0.713725, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(439,219) QColor(ARGB 1, 0.501961, 0.717647, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(440,220) QColor(ARGB 1, 0.501961, 0.721569, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(441,220) QColor(ARGB 1, 0.501961, 0.72549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(442,221) QColor(ARGB 1, 0.501961, 0.729412, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(443,221) QColor(ARGB 1, 0.501961, 0.733333, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(444,222) QColor(ARGB 1, 0.501961, 0.737255, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(445,222) QColor(ARGB 1, 0.501961, 0.741176, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(446,223) QColor(ARGB 1, 0.501961, 0.745098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(447,223) QColor(ARGB 1, 0.501961, 0.74902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(448,224) QColor(ARGB 1, 0.501961, 0.752941, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(449,224) QColor(ARGB 1, 0.501961, 0.756863, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(450,225) QColor(ARGB 1, 0.501961, 0.760784, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(451,225) QColor(ARGB 1, 0.501961, 0.764706, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(452,226) QColor(ARGB 1, 0.501961, 0.768627, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(453,226) QColor(ARGB 1, 0.501961, 0.772549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(454,227) QColor(ARGB 1, 0.501961, 0.776471, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(455,227) QColor(ARGB 1, 0.501961, 0.780392, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(456,228) QColor(ARGB 1, 0.501961, 0.784314, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(457,228) QColor(ARGB 1, 0.501961, 0.788235, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(458,229) QColor(ARGB 1, 0.501961, 0.792157, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(459,229) QColor(ARGB 1, 0.501961, 0.796078, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(460,230) QColor(ARGB 1, 0.501961, 0.8, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(461,230) QColor(ARGB 1, 0.501961, 0.803922, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(462,231) QColor(ARGB 1, 0.501961, 0.807843, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(463,231) QColor(ARGB 1, 0.501961, 0.811765, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(464,232) QColor(ARGB 1, 0.501961, 0.815686, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(465,232) QColor(ARGB 1, 0.501961, 0.819608, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(466,233) QColor(ARGB 1, 0.501961, 0.823529, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(467,233) QColor(ARGB 1, 0.501961, 0.827451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(468,234) QColor(ARGB 1, 0.501961, 0.831373, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(469,234) QColor(ARGB 1, 0.501961, 0.835294, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(470,235) QColor(ARGB 1, 0.501961, 0.839216, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(471,235) QColor(ARGB 1, 0.501961, 0.843137, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(472,236) QColor(ARGB 1, 0.501961, 0.847059, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(473,236) QColor(ARGB 1, 0.501961, 0.85098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(474,237) QColor(ARGB 1, 0.501961, 0.854902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(475,237) QColor(ARGB 1, 0.501961, 0.858824, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(476,238) QColor(ARGB 1, 0.501961, 0.862745, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(477,238) QColor(ARGB 1, 0.501961, 0.866667, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(478,239) QColor(ARGB 1, 0.501961, 0.870588, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(479,239) QColor(ARGB 1, 0.501961, 0.87451, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(480,240) QColor(ARGB 1, 0.501961, 0.878431, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(481,240) QColor(ARGB 1, 0.501961, 0.882353, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(482,241) QColor(ARGB 1, 0.501961, 0.886275, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(483,241) QColor(ARGB 1, 0.501961, 0.890196, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(484,242) QColor(ARGB 1, 0.501961, 0.894118, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(485,242) QColor(ARGB 1, 0.501961, 0.898039, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(486,243) QColor(ARGB 1, 0.501961, 0.901961, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(487,243) QColor(ARGB 1, 0.501961, 0.905882, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(488,244) QColor(ARGB 1, 0.501961, 0.909804, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(489,244) QColor(ARGB 1, 0.501961, 0.913725, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(490,245) QColor(ARGB 1, 0.501961, 0.917647, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(491,245) QColor(ARGB 1, 0.501961, 0.921569, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(492,246) QColor(ARGB 1, 0.501961, 0.92549, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(493,246) QColor(ARGB 1, 0.501961, 0.929412, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(494,247) QColor(ARGB 1, 0.501961, 0.933333, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(495,247) QColor(ARGB 1, 0.501961, 0.937255, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(496,248) QColor(ARGB 1, 0.501961, 0.941176, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(497,248) QColor(ARGB 1, 0.501961, 0.945098, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(498,249) QColor(ARGB 1, 0.501961, 0.94902, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPIXELV: QPoint(499,249) QColor(ARGB 1, 0.501961, 0.952941, 0.564706) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-setpixel.emf") ) );
}

void PyEmfTests::testDrawing1()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(2401, 1801) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-drawing1.emf") ) );
}

void PyEmfTests::testFontBackground()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(1201, 901) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 1 , penStyle: 0 width: 1 color: QColor(ARGB 1, 0.00392157, 0.00784314, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETBKCOLOR QColor(ARGB 1, 0, 1, 0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETBKMODE: Opaque " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTALIGN: 8 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTCOLOR QColor(ARGB 1, 0, 0, 1) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Helvetica\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,100) \"height=48\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(700,100) \"height=-48\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTCOLOR QColor(ARGB 1, 0.501961, 0, 0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,152 1111x1) (QPoint(90,152) ,  QPoint(1200,152) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,176 1111x1) (QPoint(90,176) ,  QPoint(1200,176) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,200 1111x1) (QPoint(90,200) ,  QPoint(1200,200) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Arial\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 3 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,200) \"Arial\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Arial\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 4 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(700,200) \"Arial\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,232 1111x1) (QPoint(90,232) ,  QPoint(1200,232) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,256 1111x1) (QPoint(90,256) ,  QPoint(1200,256) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,280 1111x1) (QPoint(90,280) ,  QPoint(1200,280) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Times New Roman\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 5 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,280) \"Times New Roman\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Times New Roman\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 6 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(700,280) \"Times New Roman\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,312 1111x1) (QPoint(90,312) ,  QPoint(1200,312) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,336 1111x1) (QPoint(90,336) ,  QPoint(1200,336) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,360 1111x1) (QPoint(90,360) ,  QPoint(1200,360) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Andale Mono\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 7 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,360) \"Andale Mono\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Andale Mono\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 8 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(700,360) \"Andale Mono\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,392 1111x1) (QPoint(90,392) ,  QPoint(1200,392) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,416 1111x1) (QPoint(90,416) ,  QPoint(1200,416) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,440 1111x1) (QPoint(90,440) ,  QPoint(1200,440) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Trebuchet MS\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 9 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,440) \"Trebuchet MS\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Trebuchet MS\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 10 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(700,440) \"Trebuchet MS\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,472 1111x1) (QPoint(90,472) ,  QPoint(1200,472) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,496 1111x1) (QPoint(90,496) ,  QPoint(1200,496) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,520 1111x1) (QPoint(90,520) ,  QPoint(1200,520) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Georgia\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 11 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,520) \"Georgia\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Georgia\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 12 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(700,520) \"Georgia\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,552 1111x1) (QPoint(90,552) ,  QPoint(1200,552) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,576 1111x1) (QPoint(90,576) ,  QPoint(1200,576) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,600 1111x1) (QPoint(90,600) ,  QPoint(1200,600) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Verdana\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 13 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,600) \"Verdana\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Verdana\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 14 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(700,600) \"Verdana\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,632 1111x1) (QPoint(90,632) ,  QPoint(1200,632) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,656 1111x1) (QPoint(90,656) ,  QPoint(1200,656) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,680 1111x1) (QPoint(90,680) ,  QPoint(1200,680) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Courier New\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 15 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,680) \"Courier New\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Courier New\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 16 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(700,680) \"Courier New\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,712 1111x1) (QPoint(90,712) ,  QPoint(1200,712) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,736 1111x1) (QPoint(90,736) ,  QPoint(1200,736) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(90,760 1111x1) (QPoint(90,760) ,  QPoint(1200,760) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Helvetica\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 17 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,760) \"Helvetica\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Helvetica\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 18 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(700,760) \"Helvetica\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(0,840) \"All text should be on a green background\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-fontbackground.emf") ) );
}

void PyEmfTests::testOptimize16Bit()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(2401, 1801) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 1 , penStyle: 0 width: 1 color: QColor(ARGB 1, 0.00392157, 0.00784314, 1) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 2 , penStyle: 0 width: 1 color: QColor(ARGB 1, 0.00392157, 1, 0.0117647) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,0 2401x901) (QPoint(0,0) ,  QPoint(2400,900) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE QRect(0,0 40001x901) (QPoint(0,0) ,  QPoint(40000,900) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,900 2401x901) (QPoint(2400,900) ,  QPoint(0,1800) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE QRect(0,900 40001x901) (QPoint(40000,900) ,  QPoint(0,1800) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-optimize16bit.emf") ) );
}

void PyEmfTests::testPaths1()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(2401, 1801) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEBRUSHINDIRECT: 1 style: 0 Colour: QColor(ARGB 1, 0.498039, 0.498039, 1) , Hatch: 0 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 2 , penStyle: 3 width: 1 color: QColor(ARGB 1, 0.941176, 0, 0.501961) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETBKMODE: Transparent " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTALIGN: 0 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTCOLOR QColor(ARGB 1, 0, 0, 0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Helvetica\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 3 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(0,0) \"FillPath\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_BEGINPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MOVETOEX QPoint(0,50) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_LINETO QPoint(100,350) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARCTO QRect(100,350 301x301) QPoint(100,350) QPoint(400,350) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINETO16 QRect(400,150 151x201) (QPoint(400,350) ,  QPoint(450,250) ,  QPoint(500,350) ,  QPoint(550,150) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYBEZIERTO16 QRect(200,100 201x101) (QPoint(400,100) ,  QPoint(300,200) ,  QPoint(200,150) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CLOSEFIGURE " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ENDPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_FILLPATH QRect(0,50 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(800,0) \"StrokePath\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_BEGINPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MOVETOEX QPoint(800,50) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_LINETO QPoint(900,350) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARCTO QRect(900,350 301x301) QPoint(900,350) QPoint(1200,350) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINETO16 QRect(1200,150 151x201) (QPoint(1200,350) ,  QPoint(1250,250) ,  QPoint(1300,350) ,  QPoint(1350,150) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYBEZIERTO16 QRect(1000,100 201x101) (QPoint(1200,100) ,  QPoint(1100,200) ,  QPoint(1000,150) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CLOSEFIGURE " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ENDPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_STROKEPATH QRect(800,50 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(0,800) \"StrokePath,FillPath\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_BEGINPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MOVETOEX QPoint(0,850) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_LINETO QPoint(100,1150) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARCTO QRect(100,1150 301x301) QPoint(100,1150) QPoint(400,1150) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINETO16 QRect(400,950 151x201) (QPoint(400,1150) ,  QPoint(450,1050) ,  QPoint(500,1150) ,  QPoint(550,950) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYBEZIERTO16 QRect(200,900 201x101) (QPoint(400,900) ,  QPoint(300,1000) ,  QPoint(200,950) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CLOSEFIGURE " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ENDPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_STROKEPATH QRect(0,850 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_FILLPATH QRect(0,850 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(800,800) \"FillPath,StrokePath\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_BEGINPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MOVETOEX QPoint(800,850) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_LINETO QPoint(900,1150) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARCTO QRect(900,1150 301x301) QPoint(900,1150) QPoint(1200,1150) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINETO16 QRect(1200,950 151x201) (QPoint(1200,1150) ,  QPoint(1250,1050) ,  QPoint(1300,1150) ,  QPoint(1350,950) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYBEZIERTO16 QRect(1000,900 201x101) (QPoint(1200,900) ,  QPoint(1100,1000) ,  QPoint(1000,950) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CLOSEFIGURE " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ENDPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_FILLPATH QRect(800,850 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_STROKEPATH QRect(800,850 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(1600,800) \"StrokeAndFillPath\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_BEGINPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MOVETOEX QPoint(1600,850) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_LINETO QPoint(1700,1150) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARCTO QRect(1700,1150 301x301) QPoint(1700,1150) QPoint(2000,1150) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINETO16 QRect(2000,950 151x201) (QPoint(2000,1150) ,  QPoint(2050,1050) ,  QPoint(2100,1150) ,  QPoint(2150,950) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYBEZIERTO16 QRect(1800,900 201x101) (QPoint(2000,900) ,  QPoint(1900,1000) ,  QPoint(1800,950) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CLOSEFIGURE " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ENDPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_STROKEANDFILLPATH QRect(1600,850 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-paths1.emf") ) );
}

void PyEmfTests::testPoly1()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(2401, 1801) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 1 , penStyle: 0 width: 10 color: QColor(ARGB 1, 0.00392157, 0.627451, 1) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEBRUSHINDIRECT: 2 style: 0 Colour: QColor(ARGB 1, 0.313725, 0.313725, 0.313725) , Hatch: 0 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETBKMODE: Transparent " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTALIGN: 8 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTCOLOR QColor(ARGB 1, 0, 0, 0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Arial\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 3 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(500,50) \"Test of polypolygon and polypolyline\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,300) \"several filled-in squares.  OpenOffice doesn't seem to complete the polygons.\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,800) \"it's ... just a bunch of wavy lines.\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-poly1.emf") ) );
}

void PyEmfTests::testPoly2()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(2401, 1801) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 1 , penStyle: 0 width: 10 color: QColor(ARGB 1, 0.00392157, 0.627451, 1) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEBRUSHINDIRECT: 2 style: 0 Colour: QColor(ARGB 1, 0.313725, 0.313725, 0.313725) , Hatch: 0 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETBKMODE: Transparent " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTALIGN: 8 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTCOLOR QColor(ARGB 1, 0, 0, 0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Arial\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 3 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(500,50) \"Test of polygon fill mode\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,300) \"ALTERNATE\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPOLYFILLMODE: OddEvenFill " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYGON16 QRect(100,300 851x451) (QPoint(100,400) ,  QPoint(500,700) ,  QPoint(600,400) ,  QPoint(900,700) ,  QPoint(900,400) ,  QPoint(100,700) ,  QPoint(100,300) ,  QPoint(950,300) ,  QPoint(950,750) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(100,900) \"WINDING\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETPOLYFILLMODE: WindingFill " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYGON16 QRect(100,900 851x451) (QPoint(100,1000) ,  QPoint(500,1300) ,  QPoint(600,1000) ,  QPoint(900,1300) ,  QPoint(900,1000) ,  QPoint(100,1300) ,  QPoint(100,900) ,  QPoint(950,900) ,  QPoint(950,1350) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-poly2.emf") ) );
}

void PyEmfTests::testSetClipPath()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(901, 601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-selectclippath1.emf") ) );
}

void PyEmfTests::testViewportWindowOrigin()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(2401, 1801) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEBRUSHINDIRECT: 1 style: 0 Colour: QColor(ARGB 1, 0.498039, 0.498039, 1) , Hatch: 0 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 2 , penStyle: 3 width: 1 color: QColor(ARGB 1, 0.941176, 0, 0.501961) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETBKMODE: Transparent " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTALIGN: 0 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTCOLOR QColor(ARGB 1, 0, 0, 0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Helvetica\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 3 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETVIEWPORTORGEX QPoint(400,400) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(0,0) \"Viewport: 400,400, loc: 0,0\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_BEGINPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MOVETOEX QPoint(0,50) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_LINETO QPoint(100,350) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARCTO QRect(100,350 301x301) QPoint(100,350) QPoint(400,350) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINETO16 QRect(400,150 151x201) (QPoint(400,350) ,  QPoint(450,250) ,  QPoint(500,350) ,  QPoint(550,150) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYBEZIERTO16 QRect(200,100 201x101) (QPoint(400,100) ,  QPoint(300,200) ,  QPoint(200,150) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CLOSEFIGURE " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ENDPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_STROKEANDFILLPATH QRect(0,50 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETVIEWPORTORGEX QPoint(0,0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETWINDOWORGEX QPoint(800,800) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(800,800) \"Window: 800,800, loc: 800,800\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_BEGINPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MOVETOEX QPoint(800,850) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_LINETO QPoint(900,1150) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARCTO QRect(900,1150 301x301) QPoint(900,1150) QPoint(1200,1150) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINETO16 QRect(1200,950 151x201) (QPoint(1200,1150) ,  QPoint(1250,1050) ,  QPoint(1300,1150) ,  QPoint(1350,950) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYBEZIERTO16 QRect(1000,900 201x101) (QPoint(1200,900) ,  QPoint(1100,1000) ,  QPoint(1000,950) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CLOSEFIGURE " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ENDPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_STROKEANDFILLPATH QRect(800,850 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,0 2401x1801) (QPoint(0,0) ,  QPoint(2400,1800) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,0 2401x1801) (QPoint(0,1800) ,  QPoint(2400,0) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETVIEWPORTORGEX QPoint(200,200) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETWINDOWORGEX QPoint(800,800) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(1800,800) \"Window: 800,800, Viewport: 200,200, loc: 1800,800\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_BEGINPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MOVETOEX QPoint(1800,850) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_LINETO QPoint(1900,1150) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARCTO QRect(1900,1150 301x301) QPoint(1900,1150) QPoint(2200,1150) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINETO16 QRect(2200,950 151x201) (QPoint(2200,1150) ,  QPoint(2250,1050) ,  QPoint(2300,1150) ,  QPoint(2350,950) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYBEZIERTO16 QRect(2000,900 201x101) (QPoint(2200,900) ,  QPoint(2100,1000) ,  QPoint(2000,950) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CLOSEFIGURE " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ENDPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_STROKEANDFILLPATH QRect(1800,850 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-viewport-window-origin.emf") ) );
}

void PyEmfTests::testWorldTransform1()
{
    QTest::ignoreMessage( QtDebugMsg, "Initialising DebugOutput " );
    QTest::ignoreMessage( QtDebugMsg, "image size: QSize(1801, 1201) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEBRUSHINDIRECT: 1 style: 0 Colour: QColor(ARGB 1, 0.498039, 0.498039, 1) , Hatch: 0 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 1 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 2 , penStyle: 3 width: 1 color: QColor(ARGB 1, 0.941176, 0, 0.501961) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETBKMODE: Transparent " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTALIGN: 0 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETTEXTCOLOR QColor(ARGB 1, 0, 0, 0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEFONTINDIRECTW: \"Helvetica\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 3 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CREATEPEN ihPen: 4 , penStyle: 2 width: 1 color: QColor(ARGB 1, 0.00784314, 0.0117647, 0.0156863) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 4 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,0 51x51) (QPoint(50,0) ,  QPoint(50,50) ,  QPoint(0,50) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETWORLDTRANSFORM: QTransform(11=1 12=0 21=0 22=1 dx=50 dy=50) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_BEGINPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MOVETOEX QPoint(0,0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_LINETO QPoint(100,300) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARCTO QRect(100,300 301x301) QPoint(100,300) QPoint(400,300) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINETO16 QRect(400,100 151x201) (QPoint(400,300) ,  QPoint(450,200) ,  QPoint(500,300) ,  QPoint(550,100) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYBEZIERTO16 QRect(200,50 201x101) (QPoint(400,50) ,  QPoint(300,150) ,  QPoint(200,100) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CLOSEFIGURE " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ENDPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_STROKEANDFILLPATH QRect(0,0 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(0,0) \"translate (50,50) loc: 0,0\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MODIFYWORLDTRANSFORM: 1 QTransform(11=1 12=0 21=0 22=1 dx=0 dy=0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 4 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,0 501x801) (QPoint(500,0) ,  QPoint(500,800) ,  QPoint(0,800) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETWORLDTRANSFORM: QTransform(11=0.707107 12=-0.707107 21=0.707107 22=0.707107 dx=500 dy=800) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_BEGINPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MOVETOEX QPoint(0,0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_LINETO QPoint(100,300) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARCTO QRect(100,300 301x301) QPoint(100,300) QPoint(400,300) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINETO16 QRect(400,100 151x201) (QPoint(400,300) ,  QPoint(450,200) ,  QPoint(500,300) ,  QPoint(550,100) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYBEZIERTO16 QRect(200,50 201x101) (QPoint(400,50) ,  QPoint(300,150) ,  QPoint(200,100) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CLOSEFIGURE " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ENDPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_STROKEANDFILLPATH QRect(0,0 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(0,0) \"rotate 45 deg, translate (500,800) loc: 0,0\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SETWORLDTRANSFORM: QTransform(11=1 12=0 21=0 22=1 dx=0 dy=0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 4 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINE16 QRect(0,0 1001x1001) (QPoint(1000,0) ,  QPoint(1000,1000) ,  QPoint(0,1000) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_SELECTOBJECT 2 " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MODIFYWORLDTRANSFORM: 3 QTransform(11=0.173648 12=-0.984808 21=0.984808 22=0.173648 dx=1000 dy=1000) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_BEGINPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_MOVETOEX QPoint(0,0) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_LINETO QPoint(100,300) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ARCTO QRect(100,300 301x301) QPoint(100,300) QPoint(400,300) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYLINETO16 QRect(400,100 151x201) (QPoint(400,300) ,  QPoint(450,200) ,  QPoint(500,300) ,  QPoint(550,100) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_POLYBEZIERTO16 QRect(200,50 201x101) (QPoint(400,50) ,  QPoint(300,150) ,  QPoint(200,100) )  " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_CLOSEFIGURE " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_ENDPATH " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_STROKEANDFILLPATH QRect(0,0 551x601) " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EXTTEXTOUTA: QPoint(0,0) \"rotate 80 deg, translate (1000,1000) loc: 0,0\" " );
    QTest::ignoreMessage( QtDebugMsg, "EMR_EOF " );
    Parser parser;
    DebugOutput output;
    parser.setOutput( &output );
    QVERIFY( parser.load( QString("pyemf-worldtransform1.emf") ) );
}

QTEST_MAIN( PyEmfTests )
#include <pyemf_tests.moc>
