var NAVTREE =
[
  [ "Qyoto", "index.html", [
    [ "Packages", null, [
      [ "Packages", "namespaces.html", "namespaces" ],
      [ "Package Functions", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", null ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", "namespacemembers_enum" ],
        [ "Enumerator", "namespacemembers_eval.html", "namespacemembers_eval" ]
      ] ]
    ] ],
    [ "Classes", null, [
      [ "Class List", "annotated.html", "annotated" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Enumerations", "functions_enum.html", "functions_enum" ],
        [ "Enumerator", "functions_eval.html", "functions_eval" ],
        [ "Properties", "functions_prop.html", "functions_prop" ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"annotated.html",
"class_qt_core_1_1_q_abstract_file_engine_1_1_map_extension_option.html",
"class_qt_core_1_1_q_basic_atomic_int.html#a0cb709d323d820f9b40eb6c3e572cf73",
"class_qt_core_1_1_q_byte_array.html#ac65f893b2d66818e9ae2055be15c1408",
"class_qt_core_1_1_q_char.html#ae58e660bde165a71f5ac00c082e232baa6ef8202e2b2bd118263270694a5e4267",
"class_qt_core_1_1_q_date.html#a784b2e571edae0a9ce929bab05f62317",
"class_qt_core_1_1_q_easing_curve.html#a358986dc8475d2781d36c86aa5770886ab3edf28366bb104a3371991df583c95b",
"class_qt_core_1_1_q_event_loop.html#a95e6f41766db10fe2966501332a3857aa2a7f86f8c71a674b4624a69e8feac195",
"class_qt_core_1_1_q_file_system_watcher.html#aa3870805d9ace25885350a2069b86444",
"class_qt_core_1_1_q_internal.html#a67a78bd6c381204231b8e9df6c2ce3c2aa9b749fcf6b862fc20f5700453d3e20a",
"class_qt_core_1_1_q_locale.html#a45837e77974d680267aa5a3935064cd7a127fea8a1623861b7862b37ea52fb540",
"class_qt_core_1_1_q_locale.html#a5a4c85abb360336f28ae0d761839df59a06c7a3c3a3344a62864b951aec4df830",
"class_qt_core_1_1_q_locale.html#a7bb5a8c608e53a7833665b56a071a915",
"class_qt_core_1_1_q_meta_object.html#a7c3cd489120d332ab9d4e658bb5a2b64",
"class_qt_core_1_1_q_object.html#a2e64cc5a8789f56b865f9a658b649c96",
"class_qt_core_1_1_q_process.html#a6e6cd4a47bc1e2e37ba71cc3caa59752",
"class_qt_core_1_1_q_reg_exp.html#a279709e7ac724a6f96cacc746a21c78e",
"class_qt_core_1_1_q_signal_mapper.html#af1263a956fade9d7aa7139be68ea082a",
"class_qt_core_1_1_q_string_ref.html#ac749d85aa5917eacdcbfd3746656210f",
"class_qt_core_1_1_q_text_codec_plugin.html#a7c84df11e4ef1809273787c3e235131d",
"class_qt_core_1_1_q_translator.html#a72ee66e9111f8c07ff40379e129e249e",
"class_qt_core_1_1_q_variant.html#af8bc235d984ecbd11b93937a3434c8eca28a78c8063c0ab41f80ce56bc51ebb1f",
"class_qt_core_1_1_q_xml_stream_reader.html#ae718c5369d73739ba1b00e34a975692faa4ed1387b391ae71403de870630c8619",
"class_qt_core_1_1_qt.html#a3338ded9e1624d056212ca027c5d271faa1d8bc743bb44be63146ba88d4fbf412",
"class_qt_core_1_1_qt.html#a632272b1f891fdbe394baf8babe399faa35ad688b6ce829b865e06527fa91c66e",
"class_qt_core_1_1_qt.html#a632272b1f891fdbe394baf8babe399faac2c410f8093876707dbec0706a6b731e",
"class_qt_core_1_1_qt.html#a968e87de4bfb82657e22d2a36cb7a7f7a9c3a71fe1a6e6ee79109a8391f930447",
"class_qt_core_1_1_qt.html#ae143db05e5e2fdf80aa1cb10abc5e208a985dfae1a929cafa0034b939e16b9c5f",
"class_qt_gui_1_1_global.html#ae4af8998f8516d144634214ef5c315b1",
"class_qt_gui_1_1_q_abstract_item_view.html#ab1125b390485d586f86432ebe90a76b2a7b2cb747c9c5568f4d637bfc0c59e338",
"class_qt_gui_1_1_q_abstract_slider.html#acecc5699074445a5007e2f1f85671326a24ca04d8966977ccdecc2e23515271a4",
"class_qt_gui_1_1_q_action_group.html#a7abbde2479142fd0a33824d1dece2a35",
"class_qt_gui_1_1_q_calendar_widget.html#a2fc0baf62ed80a92ec5b1d7cce92c9dc",
"class_qt_gui_1_1_q_color_dialog.html#a4b47f7218cc0d5e8384010d45ce88b25",
"class_qt_gui_1_1_q_completer.html#a3c3386022e803590225e3090d2aa8a83",
"class_qt_gui_1_1_q_desktop_widget.html#a70ba546b8ac99ef14b2e8ae9e3285d75",
"class_qt_gui_1_1_q_dock_widget.html#ac8f8524e288f1da34457b638a2dd22c7",
"class_qt_gui_1_1_q_file_icon_provider.html#a3b4bc30b55fa27fcdc7c26c2e3d7f6fea0b27918290ff5323bea1e3b78a9cf04e",
"class_qt_gui_1_1_q_font.html#ace8ecdbca7fc70452c47c0614a08eebea4482f6775a780c524d76cd5b6023a0d4",
"class_qt_gui_1_1_q_font_metrics_f.html#ae8d5b7c2b1659474c5b6feff71f5a2ab",
"class_qt_gui_1_1_q_graphics_anchor_layout.html#ae49c954c0deb54fc3cd1908ebdbfa7a0",
"class_qt_gui_1_1_q_graphics_item.html#a646d476dae9657e2a942a0525ce71a5b",
"class_qt_gui_1_1_q_graphics_layout.html#aa0ba86a24be01e20bebaf10355de7123",
"class_qt_gui_1_1_q_graphics_object.html#aa687f57aa2e9d5e0d87dd11794a4a3bd",
"class_qt_gui_1_1_q_graphics_scale.html#a5f7ee1b3e19a17ad7149c7cce61b2033",
"class_qt_gui_1_1_q_graphics_scene_resize_event.html#aa74aaa8f08464d1c95964ebcdcbb185e",
"class_qt_gui_1_1_q_graphics_widget.html#a26b133801fe571337e8c3a54fa4f2f4e",
"class_qt_gui_1_1_q_header_view.html#a79d827da30b9f2f8b228527b0b72f97c",
"class_qt_gui_1_1_q_image.html#a6763e1189e9c6673032d7f8b96777f83",
"class_qt_gui_1_1_q_input_context.html#aae78bf415241064b347322edf07095af",
"class_qt_gui_1_1_q_item_selection_model.html#a02860786f696f0025571800f240526c5",
"class_qt_gui_1_1_q_l_c_d_number.html#a41d9d1a7bbaffdc6c4577f89bee8b91d",
"class_qt_gui_1_1_q_line_edit.html#adcff8f5260cdfdd69e795e37733d9e0c",
"class_qt_gui_1_1_q_main_window.html#aa776d1a3a0e0fc890493ccc67a8f4aa7",
"class_qt_gui_1_1_q_mdi_sub_window.html#ae58236add19a87636a6ed292bab04c8a",
"class_qt_gui_1_1_q_mouse_event.html#a20cb4cb0574229d5cddb87ab89bcf52c",
"class_qt_gui_1_1_q_paint_engine.html#ab61fdc9e96d4167d1d861c5d995a971aabd6ec70bbbe25cbfb6eaf2b4be369ba9",
"class_qt_gui_1_1_q_painter.html#aafb1efd0a3cc934bcee7a46b89cd8830",
"class_qt_gui_1_1_q_palette.html#a809e1bb6f6905b99e0a9f554afa0b5dba45bd1d5b32931106efbf1a82fe6a732f",
"class_qt_gui_1_1_q_pixmap.html#aca1fc04851387ea797d1696f6819cdcd",
"class_qt_gui_1_1_q_print_engine.html#a14b124a1e59e361ba3c4100765c672e6",
"class_qt_gui_1_1_q_printer_info.html#a234d87b81db1b27fc9220495c42f686a",
"class_qt_gui_1_1_q_radio_button.html",
"class_qt_gui_1_1_q_shortcut.html#a3e856e32701ae54b8ce3f61023eff084",
"class_qt_gui_1_1_q_spin_box.html#a1c7a71f6eb02503e7fcdea3c78b0012c",
"class_qt_gui_1_1_q_standard_item.html#afa79560df43a33d1b403b33e9a778f41",
"class_qt_gui_1_1_q_style.html#a5cdc599e78ae913beb8122eea2c93d7ea87da3e6dc3360c4214752584bb596fa5",
"class_qt_gui_1_1_q_style.html#a80e4f384a304186e4bac6d7e1ff54160a90a568a348a76260c9221a60d6a1e08c",
"class_qt_gui_1_1_q_style.html#afd5782d96394ecb65602e8e162ee60cfabebb2fdb338c55937f8386922847703c",
"class_qt_gui_1_1_q_style_option_frame_v3.html#ab858e7bbb954f791a4966eae7927314b",
"class_qt_gui_1_1_q_style_option_tab_bar_base_v2.html#a76d43d52758cf6d87c047663f8c22088",
"class_qt_gui_1_1_q_style_plugin.html#a06cd5057b2c192fc09d94c0d4b1dacd7",
"class_qt_gui_1_1_q_table_view.html#a0592828ad1d363063ac11c5740b43d7c",
"class_qt_gui_1_1_q_tablet_event.html#a3c5814624f91f646274f458a0a16a6b4af8859ab5a1a3ed6a16557acf58f012d9",
"class_qt_gui_1_1_q_text_char_format.html#ad3fc260d3fa0ededd8247005719ac261a8e3c548c16448b10510b0ac772aed40d",
"class_qt_gui_1_1_q_text_document_fragment.html#af3c6fa325ccb83cfafcf8e6849669cd2",
"class_qt_gui_1_1_q_text_format.html#a42db8b9c21ae94bad308f2547ceb7443",
"class_qt_gui_1_1_q_text_layout_1_1_format_range.html#a4a1f8441ce69012a4489b77b2bfbcecc",
"class_qt_gui_1_1_q_text_table_format.html#a300ba682e9a2d26fee9f0cfe80e9e49e",
"class_qt_gui_1_1_q_transform.html#a3d13c028815398d6c1862691d74ad2f8",
"class_qt_gui_1_1_q_tree_widget_item.html#a088095b0cd167284d613e32877657353",
"class_qt_gui_1_1_q_validator.html#ad5d582f7801c784524a30b6a0afda640",
"class_qt_gui_1_1_q_widget.html#a40242b8aaa601cc50137756c3d42ca5b",
"class_qt_gui_1_1_q_widget_item_v2.html#add2ca85820d70ace28c416b087b90e3b",
"class_qt_network_1_1_global.html#a7bdc317f7297c49fed174c1daaf7e587",
"class_qt_network_1_1_q_ftp.html#a6c978c5e70b4841b72c9c4cf8e07b786",
"class_qt_network_1_1_q_http_multi_part.html#a94873b7952d5cb1d31c27a1e7f16e1ad",
"class_qt_network_1_1_q_network_configuration.html#a5d87fad0836b640bf2341bc98cb2e0ad",
"class_qt_network_1_1_q_network_reply.html#a4dcd086e87333f179db991836d745827",
"class_qt_network_1_1_q_ssl_configuration.html#a38b4e0dec0fa767b27b021610be555f0",
"class_qt_network_1_1_q_url_info.html#a09a5bfda14ee0b5311b27d33a6407295",
"class_qt_open_g_l_1_1_global.html#ada03e5ad8ef7a9f7b3cdaa2d46932c52",
"class_qt_open_g_l_1_1_q_g_l_framebuffer_object.html#af57a2382702693fe7c04374503bcb5ce",
"class_qt_open_g_l_1_1_q_g_l_widget.html#af0bdae615e6c69bc334715835c85fad9",
"class_qt_script_1_1_q_script_syntax_check_result.html#a0fe16592570ba42230c40d9fa1d884a9a3ac705f2acd51a4613f9188c05c91d0d",
"class_qt_sql_1_1_global.html#a6cc003f71af278a7d01c9fd6c929989a",
"class_qt_sql_1_1_q_sql_driver_creator_base.html#ae92179279c5e770adfb70cd38a20ca9b",
"class_qt_sql_1_1_q_sql_relational_table_model.html#a9c2b3c00a727091e70e444133bef3582",
"class_qt_svg_1_1_global.html#a796ed4f2967d3ac530d8efa714c244b1",
"class_qt_web_kit_1_1_q_web_database.html#ab6113b59769527b6ed4cce2101fe4486",
"class_qt_web_kit_1_1_q_web_page.html#a477b02d272cf69430ef8f4eb22687538",
"class_qt_web_kit_1_1_q_web_plugin_factory.html",
"class_qt_xml_1_1_global.html#a27a1e268a4680eca439790c13cf114a2",
"class_qt_xml_1_1_q_dom_element.html#a6a9c34e7e1410405a0fcddf5b618895a",
"class_qt_xml_1_1_q_xml_content_handler.html#a73989266f0c777095982a0d7f6437963",
"class_qt_xml_patterns_1_1_global.html#a0adf5d91aa5b7ea15ee0368d5aaf071a",
"class_qt_xml_patterns_1_1_q_xml_formatter.html#a3118de1ea1cca91b94f8c6b2bfa6f6aa",
"functions_func_0x74.html",
"interface_qt_gui_1_1_i_q_command_link_button_signals.html",
"interface_qt_gui_1_1_i_q_graphics_layout_item.html#a0ad6c12d221f40ea48d50460ad21ce9d",
"interface_qt_gui_1_1_i_q_size_grip_signals.html",
"interface_qt_sql_1_1_i_q_sql_table_model_signals.html#a4a6ce5ec617df6d7973a725da2234bc0"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';
var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function localStorageSupported()
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null && window.localStorage.getItem;
  }
  catch(e) {
    return false;
  }
}


function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  } 
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does not work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  var level=-1;
  var n = node;
  while (n.parentNode) { level++; n=n.parentNode; }
  var imgNode = document.createElement("img");
  imgNode.style.paddingLeft=(16*level).toString()+'px';
  imgNode.width  = 16;
  imgNode.height = 22;
  imgNode.border = 0;
  if (node.childrenData) {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        node.plus_img.src = node.relpath+"ftv2pnode.png";
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
    imgNode.src = node.relpath+"ftv2pnode.png";
  } else {
    imgNode.src = node.relpath+"ftv2node.png";
    domNode.appendChild(imgNode);
  } 
}

var animationInProgress = false;

function gotoAnchor(anchor,aname,updateLocation)
{
  var pos, docContent = $('#doc-content');
  if (anchor.parent().attr('class')=='memItemLeft' ||
      anchor.parent().attr('class')=='fieldtype' ||
      anchor.parent().is(':header')) 
  {
    pos = anchor.parent().position().top;
  } else if (anchor.position()) {
    pos = anchor.position().top;
  }
  if (pos) {
    var dist = Math.abs(Math.min(
               pos-docContent.offset().top,
               docContent[0].scrollHeight-
               docContent.height()-docContent.scrollTop()));
    animationInProgress=true;
    docContent.animate({
      scrollTop: pos + docContent.scrollTop() - docContent.offset().top
    },Math.max(50,Math.min(500,dist)),function(){
      if (updateLocation) window.location.href=aname;
      animationInProgress=false;
    });
  }
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath($(location).attr('pathname'));
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : "javascript:void(0)"; 
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var anchor = $(aname);
        gotoAnchor(anchor,aname,true);
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var aname = $(location).attr('hash');
  var anchor = $(aname);
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+
               window.location.hash.substring(1)+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parents().slice(2).prop('tagName')=='TR') {
    glowEffect(anchor.parents('div.memitem'),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
  gotoAnchor(anchor,aname,false);
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath($(location).attr('pathname'))+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  if ($('#nav-tree-contents .item:first').hasClass('selected')) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).show();
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages" || rootBase=="search") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1];
    else hash='';
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
    //root=root.replace(/_source\./,'.'); // source link to doc link
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (i==-1) { i=0; root=NAVTREE[0][1]; } // fallback: show index
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function showSyncOff(n,relpath)
{
    n.html('<img src="'+relpath+'sync_off.png" title="'+SYNCOFFMSG+'"/>');
}

function showSyncOn(n,relpath)
{
    n.html('<img src="'+relpath+'sync_on.png" title="'+SYNCONMSG+'"/>');
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    showSyncOff(navSync,relpath);
    storeLink(stripPath2($(location).attr('pathname'))+$(location).attr('hash'));
  } else {
    navSync.addClass('sync');
    showSyncOn(navSync,relpath);
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      showSyncOff(navSync,relpath);
      navSync.removeClass('sync');
    } else {
      showSyncOn(navSync,relpath);
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  navTo(o,toroot,window.location.hash,relpath);

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath($(location).attr('pathname'))+':'+
                               $(location).attr('hash').substring(1);
         a=$('.item a[class$="'+clslink+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2($(location).attr('pathname'));
       navTo(o,link,$(location).attr('hash'),relpath);
     } else if (!animationInProgress) {
       $('#doc-content').scrollTop(0);
       $('.item').removeClass('selected');
       $('.item').removeAttr('id');
       navTo(o,toroot,window.location.hash,relpath);
     }
  })

  $(window).load(showRoot);
}

