/***************************************************************************
                          setup.h  -  description
                             -------------------
    begin                : Fri Dec 21 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETUP_H
#define SETUP_H

#include <qstring.h>
#include <qlistview.h>

#include "setup_dialog.h"

/**
  *@author Renchi Raju
  */

extern "C" {
	#include <gphoto2.h>
}


class Setup : public Setup_Dialog  {

public: 
	Setup(QWidget *parent=0, const char *name=0 );
	~Setup();

private:

	void getCameraListings();
	void loadCameraSettings();
	void saveCameraSettings();
	

	QString my_cameraModel;
	QString my_cameraPort;
	QString my_cameraPortPath;



protected slots:
  void slot_ok();
  void slot_apply();
  void slot_cancel();
  void slot_autoDetect();

  void slot_setModel(QListViewItem *);
  void slot_setPort(int portType);
  void slot_setPortPathLabel(int portType);
	
};

#endif
