/***************************************************************************
                          exif_info.cpp  -  description
                             -------------------
    begin                : Thu Jan 31 14:34:36 CST 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klistview.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kurl.h>

#include <qlabel.h>
#include <qpixmap.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qtooltip.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qstring.h>

#include <vector>
#include <string>


#include "exif_info.h"
#include "exif_parser.h"


Exif_Info::Exif_Info(Exif_Parser *_exifParser, QWidget *parent, 
		     const char *name, WFlags fl) 
  : QWidget(parent, name, fl)
{

  exifParser = _exifParser;


  resize( 450, 480 ); 
  setCaption( tr( "Exif Information" ) );
  Layout_main = new QGridLayout( this ); 
  Layout_main->setSpacing( 5 );
  Layout_main->setMargin( 5 );

  tabWidget = new QTabWidget( this, "tabWidget" );

  tab_IFD0 = new QWidget( tabWidget, "tab_IFD0" );
  tabLayout_IFD0 = new QGridLayout( tab_IFD0 ); 
  tabLayout_IFD0->setSpacing( 5 );
  tabLayout_IFD0->setMargin( 5 );

  ListView_IFD0 = new KListView( tab_IFD0, "ListView_IFD0" );
  ListView_IFD0->addColumn( tr( "Name" ), 1 );
  ListView_IFD0->addColumn( tr( "Value" ));
  ListView_IFD0->setSorting(-1);
  

  tabLayout_IFD0->addWidget( ListView_IFD0, 0, 0 );
  tabWidget->insertTab( tab_IFD0, tr( "IFD0" ) );


  tab_subIFD = new QWidget( tabWidget, "tab_subIFD" );
  tabLayout_subIFD = new QGridLayout( tab_subIFD ); 
  tabLayout_subIFD->setSpacing( 5 );
  tabLayout_subIFD->setMargin( 5 );

  ListView_subIFD = new KListView( tab_subIFD, "ListView_subIFD" );
  ListView_subIFD->addColumn( tr( "Name" ), 1 );
  ListView_subIFD->addColumn( tr( "Value" ) );
  ListView_subIFD->setSorting(-1);
 
  tabLayout_subIFD->addWidget( ListView_subIFD, 0, 0 );
  tabWidget->insertTab( tab_subIFD, tr( "SubIFD" ) );


  tab_interIFD = new QWidget( tabWidget, "tab_interIFD" );
  tabLayout_interIFD = new QGridLayout( tab_interIFD ); 
  tabLayout_interIFD->setSpacing( 5 );
  tabLayout_interIFD->setMargin( 5 );

  ListView_interIFD = new KListView( tab_interIFD, "ListView_interIFD" );
  ListView_interIFD->addColumn( tr( "Name" ), 1 );
  ListView_interIFD->addColumn( tr( "Value" ) );

  tabLayout_interIFD->addWidget( ListView_interIFD, 0, 0 );
  tabWidget->insertTab( tab_interIFD, tr( "InterIFD" ) );


  tab_makerIFD = new QWidget( tabWidget, "tab_makerIFD" );
  tabLayout_makerIFD = new QGridLayout( tab_makerIFD ); 
  tabLayout_makerIFD->setSpacing( 5 );
  tabLayout_makerIFD->setMargin( 5 );

  ListView_makerIFD = new KListView( tab_makerIFD, "ListView_makerIFD" );
  ListView_makerIFD->addColumn( tr( "Name" ), 1 );
  ListView_makerIFD->addColumn( tr( "Value" ) );
  ListView_makerIFD->setSorting(-1);

 
  tabLayout_makerIFD->addWidget( ListView_makerIFD, 0, 0 );
  tabWidget->insertTab( tab_makerIFD, tr( "MakerNote" ) );


  tab_IFD1 = new QWidget( tabWidget, "tab_IFD1" );
  tabLayout_IFD1 = new QGridLayout( tab_IFD1 ); 
  tabLayout_IFD1->setSpacing( 5 );
  tabLayout_IFD1->setMargin( 5 );

  Label_thumbnail = new QLabel( tab_IFD1, "Label_thumbnail" );
  Label_thumbnail->setGeometry( QRect( 10, 10, 200, 150 ) ); 
  Label_thumbnail->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, 
					       (QSizePolicy::SizeType)0 ) );
  Label_thumbnail->setMinimumSize( QSize( 200, 150 ) );
  Label_thumbnail->setText( "No thumbnail" );
  Label_thumbnail->setScaledContents( TRUE );
  Label_thumbnail->setFrameShape ( QFrame::Box );
  Label_thumbnail->setFrameShadow ( QFrame::Raised );

  ListView_IFD1 = new KListView( tab_IFD1, "ListView_IFD0" );
  ListView_IFD1->addColumn( tr( "Name" ), 1 );
  ListView_IFD1->addColumn( tr( "Value" ) );
  ListView_IFD1->setSorting(-1);
 
  tabLayout_IFD1->addWidget( Label_thumbnail, 0, 0 );
  tabLayout_IFD1->addWidget( ListView_IFD1, 1, 0 );
  tabWidget->insertTab( tab_IFD1, tr( "IFD1" ) );


  tab_comments = new QWidget( tabWidget, "tab_comments" );
  tabLayout_comments = new QGridLayout( tab_comments ); 
  tabLayout_comments->setSpacing( 5 );
  tabLayout_comments->setMargin( 5 );
  
  MultiLineEdit_comments = new QMultiLineEdit( tab_comments, 
					       "MultiLineEdit_comments" );
  MultiLineEdit_comments->setWordWrap ( QMultiLineEdit::WidgetWidth);

  tabLayout_comments->addWidget( MultiLineEdit_comments, 0, 0 );
  tabWidget->insertTab( tab_comments, tr( "Comments" ) );

  Layout_main->addWidget( tabWidget, 0, 0 );

  
  buttonBox = new QGroupBox(this);
  buttonBox->setFrameShape( QGroupBox::NoFrame );
  buttonBox->setTitle( QString::null );
  buttonBox->setColumnLayout(0, Qt::Vertical );
  buttonBox->layout()->setSpacing( 0 );
  buttonBox->layout()->setMargin( 0 );
  Layout_buttonBox = new QGridLayout(buttonBox->layout());
  Layout_buttonBox->setAlignment( Qt::AlignTop );
  Layout_buttonBox->setSpacing( 6 );
  Layout_buttonBox->setMargin( 11 );

  closeButton = new QPushButton( buttonBox, "closeButton" );
  closeButton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, 
					  (QSizePolicy::SizeType)0 ) );
  closeButton->setMinimumSize( QSize( 100, 0 ) );
  closeButton->setText( tr( "Close" ) );

  saveButton = new QPushButton( buttonBox, "saveButton" );
  saveButton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, 
					  (QSizePolicy::SizeType)0 ) );
  saveButton->setMinimumSize( QSize( 100, 0 ) );
  saveButton->setText( tr( "Save" ) );

  saveImageButton = new QPushButton( buttonBox, "saveImageButton" );
  saveImageButton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, 
					  (QSizePolicy::SizeType)0 ) );
  saveImageButton->setMinimumSize( QSize( 100, 0 ) );
  saveImageButton->setText( tr( "Save Image" ) );

  Layout_buttonBox->addWidget( closeButton, 0, 0 );
  Layout_buttonBox->addWidget( saveButton, 0, 1 );
  Layout_buttonBox->addWidget( saveImageButton, 0, 2);

  Layout_main->addWidget (buttonBox, 1, 0);


  vector<string> vector_name;
  vector<string> vector_value;

  if (exifParser->getIFD0(vector_name, vector_value) == 0) {
    
    exifStrings += "IFD0: Main Image";
    exifStrings += "-------------------------------------------";
    
   for (int i=vector_name.size()-1; i>=0; i--) {
     KListViewItem *item = new KListViewItem(ListView_IFD0);
     item->setText(0,vector_name[i].c_str());
     item->setText(1,vector_value[i].c_str());
     exifStrings += QString(vector_name[i].c_str()) + ": \t" 
       + QString(vector_value[i].c_str());
   }
   setListViewFullWidth(ListView_IFD0);
 }


 if (exifParser->getsubIFD(vector_name, vector_value) == 0) {
    
   exifStrings += "\nExif Sub IFD: Main Image";
   exifStrings += "-------------------------------------------";

   for (int i=vector_name.size()-1; i>=0; i--) {
     KListViewItem *item = new KListViewItem(ListView_subIFD);
     item->setText(0,vector_name[i].c_str());
     item->setText(1,vector_value[i].c_str());
     exifStrings += QString(vector_name[i].c_str()) + ": \t" 
       + QString(vector_value[i].c_str());
   }
   setListViewFullWidth(ListView_subIFD);
 }

 if (exifParser->getinterIFD(vector_name, vector_value) == 0) {

   exifStrings += "\nInteroperability IFD";
   exifStrings += "-------------------------------------------";
    
   for (int i=vector_name.size()-1; i>=0; i--) {
     KListViewItem *item = new KListViewItem(ListView_interIFD);
     item->setText(0,vector_name[i].c_str());
     item->setText(1,vector_value[i].c_str());
     exifStrings += QString(vector_name[i].c_str()) + ": \t" 
       + QString(vector_value[i].c_str());
   }
   setListViewFullWidth(ListView_interIFD);
 }

 if (exifParser->getmakerIFD(vector_name, vector_value) == 0) {
    
   exifStrings += "\nManufacturer Note";
   exifStrings += "-------------------------------------------";

   for (int i=vector_name.size()-1; i>=0; i--) {
     KListViewItem *item = new KListViewItem(ListView_makerIFD);
     item->setText(0,vector_name[i].c_str());
     item->setText(1,vector_value[i].c_str());
     exifStrings += QString(vector_name[i].c_str()) + ": \t" 
       + QString(vector_value[i].c_str());
   }
   setListViewFullWidth(ListView_makerIFD);
 }

 if (exifParser->getIFD1(vector_name, vector_value) == 0) {
    
   exifStrings += "\nIFD1: Thumbnail Image";
   exifStrings += "-------------------------------------------";

   for (int i=vector_name.size()-1; i>=0; i--) {
     KListViewItem *item = new KListViewItem(ListView_IFD1);
     item->setText(0,vector_name[i].c_str());
     item->setText(1,vector_value[i].c_str());
     exifStrings += QString(vector_name[i].c_str()) + ": \t" 
       + QString(vector_value[i].c_str());
   }
   setListViewFullWidth(ListView_IFD1);
 }
 
 unsigned char* thumbPtr;
 unsigned int thumbSize;
 QPixmap thumbnail;

 if (exifParser->getThumbnail(thumbPtr, thumbSize) == 0) {
   thumbnail.loadFromData(thumbPtr, thumbSize);
   Label_thumbnail->setPixmap(thumbnail);
 }

 string comments;

 exifParser->getComments(comments);
 if (!comments.empty()) {

   exifStrings += "\nComments";
   exifStrings += "-------------------------------------------";

   MultiLineEdit_comments->insert(QString(comments.c_str()));
   exifStrings += QString(comments.c_str());
 }



  commentsChanged = false;
  saveImageButton->setEnabled(false);

  connect(MultiLineEdit_comments, SIGNAL( textChanged () ),
	  this, SLOT( slot_commentsChanged() ) );

  connect( closeButton, SIGNAL(clicked()),
	   this, SLOT(slot_close()) );
  connect( saveButton, SIGNAL(clicked()),
	   this, SLOT(slot_save()) );
  connect( saveImageButton, SIGNAL( clicked () ),
	   this, SLOT( slot_saveImage() ) );

  




}


Exif_Info::~Exif_Info()
{
  if (exifParser)
    delete exifParser;
}


void Exif_Info::setListViewFullWidth(KListView *listview) {

  listview->setColumnWidth( 0, width()-listview->columnWidth(1)-30);
}


void Exif_Info::slot_commentsChanged() {

  commentsChanged = true;
  if (!saveImageButton->isEnabled())
      saveImageButton->setEnabled(true);
}


QString Exif_Info::getNewComments() {

  int num = MultiLineEdit_comments->numLines();

  if (num < 1) return QString::null;

  QString commentString;

  for (int i=0; i<num; i++) {
    commentString += MultiLineEdit_comments->textLine(i);
    if (i != num-1) commentString += "\n";
  }
    
  return commentString;
    

}

void Exif_Info::slot_close() {
  delete this;
}

void Exif_Info::slot_save() {

  QString exifFileName = exifParser->imageFileName;
  
  QFileInfo fileInfo(exifFileName);
  exifFileName = fileInfo.baseName();
  exifFileName += ".exif";

  QString exifDir;
  exifDir = KURL(exifParser->imageFileName).directory();

  KFileDialog *fileDlg = new KFileDialog(exifDir, QString::null, this, "Save File", true);
  fileDlg->setSelection (exifFileName);
  fileDlg->show();
  QString result=fileDlg->selectedFile ();

  if (!result.isEmpty()) {

    QFile f(result);
    if ( f.open(IO_WriteOnly) ) {
      QTextStream t( &f );       
      QString str;
      for (int i=0; i<exifStrings.count(); i++) {
	t <<  exifStrings[i] << "\n";
      }
      f.close();
    }
    else {
      KMessageBox::error(this,"Couldn't open file for writing");
    }
  }
  
  delete fileDlg;

}


void Exif_Info::slot_saveImage() {

  QString newComments = getNewComments();
  string comments = string(newComments.latin1());

  if (!comments.empty()) {
    exifParser->changeComments(comments);
    exifParser->writeImageFile(exifParser->imageFileName);
  }
  saveImageButton->setEnabled(false);
  

}



