/***************************************************************************
                          photo_foldertree.h  -  description
                             -------------------
    begin                : Sun Jan 13 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PHOTO_FOLDERTREE_H
#define PHOTO_FOLDERTREE_H

#include <klistview.h>
#include <kurl.h>
#include <kfileitem.h>

#include <qmap.h>

namespace KIO {
        class Job;
}

class KDirLister;
class Photo_Folder;


/**
  *@author Renchi Raju
  */

class Photo_FolderTree : public KListView  {

Q_OBJECT

public: 
	Photo_FolderTree(QWidget* parent=0, const char *name = 0);
	~Photo_FolderTree();
	void setFolder(Photo_Folder* item);

private:
	KDirLister* dirLister;
	QMap<KFileItem*, Photo_Folder*> folderMap;
  
	Photo_Folder* findParentFolder(const KURL& url);
	void removeFolderItemFromMap(Photo_Folder* item);

protected:
	void startDrag();
	void contentsDragMoveEvent(QDragMoveEvent* event);
	void contentsDragLeaveEvent(QDragLeaveEvent*);
	void contentsDropEvent(QDropEvent* event); 
	Photo_Folder* dropTarget;

private slots:
	void slot_newItems(const KFileItemList& fileItemList);
	void slot_deleteItem(KFileItem* fileItem);
	void slot_refreshItems(const KFileItemList& fileItemList);
	void slot_contextMenu(KListView* listview, QListViewItem* item, const QPoint& pos);
	void slot_makeDir();
	void slot_renameDir();
	void slot_removeDir();
	void slot_showProperties();
	void slot_showKIOError(KIO::Job* job);
};

#endif
