#ifndef TAGFUNCTIONS_H
#define TAGFUNCTIONS_H

#include <string>

#include "ifdentry.h"

extern string tagString(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagRational(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagRationalNormal(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagUShort(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagULong(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagNumber(const char *_name, IFDEntry *_entry, const char *units=0);


extern string tagOrientation(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagResolutionUnit(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagWhitePoint(const char *name, IFDEntry *entry, const char *units=0);
extern string tagPrimaryChromacities(const char *name, IFDEntry *entry, const char *units=0);
extern string tagYCbCrCoefficients(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagYCbCrPositioning(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagReferenceBW(const char *_name, IFDEntry *_entry, const char *units=0);

extern string tagExpProgram(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagISO(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagShutterSpeed(const char *_name, IFDEntry *_entry, const char *units=0);
extern string tagAperture(const char *name, IFDEntry *entry, const char *units=0);
extern string tagMeteringMode(const char *name, IFDEntry *entry, const char *units=0);
extern string tagLightSource(const char *name, IFDEntry *entry, const char *units=0);
extern string tagFlash(const char *name, IFDEntry *entry, const char *units=0);
extern string tagExifVersion(const char *name, IFDEntry *entry, const char *units);
extern string tagSensingMethod(const char *name, IFDEntry *entry, const char *units=0);
extern string tagFileSource(const char *name, IFDEntry *entry, const char *units=0);
extern string tagSceneType(const char *name, IFDEntry *entry, const char *units=0);

extern string tagCompression(const char *name, IFDEntry *entry, const char *units=0);
extern string tagPhotoMetric(const char *name, IFDEntry *entry, const char *units=0);


extern string tagNikonVersion(const char *name, IFDEntry *entry, const char *units);
extern string tagNikonAFFocusPosition(const char *name, IFDEntry *entry, const char *units=0);

extern string tagOlympusSpecialMode(const char *name, IFDEntry *entry, const char *units=0);
extern string tagOlympusJpegQuality(const char *name, IFDEntry *entry, const char *units=0);
extern string tagOlympusMacro(const char *name, IFDEntry *entry, const char *units=0);


#endif
