#ifndef THUMBNAILSIZE_H
#define THUMBNAILSIZE_H

// Qt includes
#include <qstring.h>

/**
 * This is an "enum-like" class : an enum with cast operators to convert
 * from/to string and a few other methods
 */
class ThumbnailSize {
public:
	enum Size { Small, Med, Large };
	ThumbnailSize(Size value=Med);

	/**
	 * Init a ThumbnailSize from a string, set to medium if the string
	 * is not recognized
	 */
	ThumbnailSize(const QString& str);

	int pixelSize() const;
	bool operator==(const ThumbnailSize& size) const { return mValue==size.mValue; }
	operator const QString&() const;
	operator Size() const { return mValue; }

private:
	Size mValue;
};

#endif
