#ifndef ALBUMFOLDERTREE_H
#define ALBUMFOLDERTREE_H

#include <qstring.h>

#include <kfiletreeview.h>
#include <kurl.h>

class QListViewItem;
class QTimer;
class QStringList;

class KFileTreeBranch;
class KFileTreeViewItem;

class AlbumFolderTree : public KFileTreeView {

    Q_OBJECT

public:

    AlbumFolderTree(QWidget* parent);
    ~AlbumFolderTree();

    void setRootPath(const KURL& url);
    void changeRootPath(const KURL& url);

    void makeDir();
    void rmDir();
    void renameDir();
    void showPropertiedDir();

protected:

    void contentsDragMoveEvent(QDragMoveEvent*);
    void contentsDragLeaveEvent(QDragLeaveEvent*);
    void contentsDropEvent(QDropEvent*);

private:

    KURL mRootURL;
    KFileTreeBranch* mRootBranch;
    KURL mPrevURL;

    QTimer* mAutoOpenTimer;
    KFileTreeViewItem* mDropTarget;
    int AUTO_OPEN_DELAY;

    bool kioJob;

private:

    QString trimCurrentAlbumName();

signals:

    void signal_currentURLChanged(const KURL&);
    void signal_requestCameraDownload(const QStringList&,
                                      const QStringList&,
                                      const QString&);

private slots:

    void slot_selectionChanged(QListViewItem* it);
    void slot_autoOpenDropTarget();
    void slot_onMkDir(KIO::Job*);
    void slot_onRmDir(KIO::Job*);
    void slot_onRenameDir(KIO::Job*);
    void slot_contextMenu(KListView*,
                          QListViewItem*,
                          const QPoint&);
    void slot_refreshItems(const KFileItemList&);

protected slots:

    void slotNewTreeViewItems(KFileTreeBranch*,
                              const KFileTreeViewItemList&);
};

#endif
