#ifndef CAMERAFOLDERTREE_H
#define CAMERAFOLDERTREE_H

#include <qstring.h>

#include <klistview.h>
#include <kservice.h>


class QCustomEvent;
class QStringList;
class QPoint;
class CameraIconView;
class CameraFolderItem;
class CameraIconItem;
class CameraFileItem;
class Gphoto_Controller;

class CameraFolderTree : public KListView {

    Q_OBJECT

public:

    CameraFolderTree(QWidget* parent);
    ~CameraFolderTree();

    void setIconView(CameraIconView* camView);

    void camera_new();
    void camera_change(const QString& model,
                       const QString& port,
                       const QString& path);
    void camera_connect();
    void camera_disconnect();
    void camera_cancel();
    void camera_download(const QString& downloadDir);
    void camera_download(const QStringList& nameList,
                         const QStringList& folderList,
                         const QString& downloadDir);
    void camera_downloadAll(const QString& downloadDir);
    void camera_delete();
    void camera_deleteAll();
    void camera_upload(const QString& localImagePath);
    void camera_information();

    bool cameraReadyForUpload(QString& reason);

private:

    CameraIconView* mIconView;
    Gphoto_Controller* mGpController;
    CameraFolderItem* mRootItem;

    QString mCameraModel;
    QString mCameraGlobalPath;
    QString mCameraPort;

    bool mBusy;

    int mNumThumbnailsRequested;
    int mNumThumbnailsDownloaded;

    KService::Ptr mCamItemServicePtr;

    QListViewItem* mHighlightedItem;

protected:

    void customEvent(QCustomEvent *event);

private:

    void downloadOneImage(const QString& name,
                          const QString& folder,
                          const QString& downloadDir,
                          bool& proceedFurther,
                          bool& overwriteAll);

    void eventCameraInitialized(QCustomEvent *event);
    void eventNewSubFolders(QCustomEvent *event);
    void eventNewItems(QCustomEvent *event);
    void eventThumbNailReady(QCustomEvent *event);
    void eventDownloadImage(QCustomEvent *event);
    void eventDeleteImage(QCustomEvent *event);
    void eventOpenImage(QCustomEvent *event);
    void eventCameraInformation(QCustomEvent *event);
    void eventCameraStatusMsg(QCustomEvent *event);
    void eventCameraProgress(QCustomEvent *event);
    void eventCameraErrorMsg(QCustomEvent *event);
    void eventCameraBusy(QCustomEvent *event);

    // -- DnD ----------------------------------------
    void contentsDragMoveEvent(QDragMoveEvent* event);
    void contentsDropEvent(QDropEvent* event);
    void contentsDragLeaveEvent(QDragLeaveEvent*);

    void highlightItem(QListViewItem* item);
    void cleanHighlights();


signals:

    void signal_cameraFolderClicked();
    void signal_cameraConnected(bool);
    void signal_cameraStatusMsg(const QString&);
    void signal_cameraProgress(int val);
    void signal_cameraBusy(bool);

private slots:

    void slot_executed(QListViewItem* item);
    void slot_selectionChanged(QListViewItem* item);
    void slot_iconViewInsertItems();
    void slot_openItem(CameraIconItem*,KService::Ptr);
    void slot_contextMenu(KListView*, QListViewItem*,
                                        const QPoint&);
};

#endif
