#include <qwmatrix.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qpen.h>
#include <qpixmap.h>

#include <kiconloader.h>

#include "thumbnailmt.h"
#include "camerafileitem.h"
#include "camerafileiteminfo.h"
#include "cameraiconview.h"
#include "cameraiconitem.h"


const char* CameraIconItem::new_xpm[] = {
"13 13 8 1",
" 	c None",
".	c #232300",
"+	c #F6F611",
"@	c #000000",
"#	c #DBDA4D",
"$	c #FFFF00",
"%	c #AAA538",
"&	c #E8E540",
"      .      ",
"  .  .+.  .  ",
" @#@ .$. .#. ",
"  @$@#$#@$.  ",
"   @$%&%$@   ",
" ..#%&&&%#.. ",
".+$$&&&&&$$+@",
" ..#%&&&%#@@ ",
"   @$%&%$@   ",
"  .$@#$#@$.  ",
" @#. @$@ @#. ",
"  .  @+@  .  ",
"      @      "};



CameraIconItem::CameraIconItem(CameraIconView* parent,
                               const CameraFileItem* fileItem,
                               const ThumbnailSize& thumbSize)
    : QObject(parent),
      QIconViewItem(parent),
      mThumbnailSize(thumbSize)
{
    setDragEnabled(true);
    setDropEnabled(false);

    mFileItem = fileItem;
    setText(mFileItem->fileInfo()->getName());

    if (mFileItem->pixmap())
        slot_showThumbnail();
    else
        showPixmapForMime();

    connect(mFileItem, SIGNAL(signal_thumbnailChanged()),
            this, SLOT(slot_showThumbnail()));
    connect(mFileItem, SIGNAL(signal_downloadStatusChanged()),
            this, SLOT(slot_showThumbnail()));
    connect(mFileItem, SIGNAL(signal_deleted()),
            this, SLOT(slot_deleteThis()));
}

CameraIconItem::~CameraIconItem()
{

}

CameraFileItemInfo* CameraIconItem::fileInfo() const
{
    return mFileItem->fileInfo();
}

const CameraFileItem* CameraIconItem::fileItem()
{
    return mFileItem;
}


void CameraIconItem::slot_showThumbnail()
{
    if (!mFileItem->pixmap()) {
        showPixmapForMime();
        return;
    }

    QPixmap thumbnail(*(mFileItem->pixmap()));

    switch(mThumbnailSize.getSize()) {
    case ThumbnailSize::Small: {
        QWMatrix matrix;
        matrix.scale(mThumbnailSize.scaleFactor(),
                     mThumbnailSize.scaleFactor());
        thumbnail = QPixmap(thumbnail.xForm(matrix));
        dropShadow(thumbnail);
        break;
    }
    case ThumbnailSize::Medium: {
        QWMatrix matrix;
        matrix.scale(mThumbnailSize.scaleFactor(),
                     mThumbnailSize.scaleFactor());
        thumbnail = QPixmap(thumbnail.xForm(matrix));
        dropShadow(thumbnail);
        break;
    }
    default:
        break;
    }

    if (mFileItem->fileInfo()->getDownloaded() == 0) {
        QPainter p;
        int x = thumbnail.width()-15;
        int y = 2;
        p.begin(&thumbnail);
        p.drawPixmap(x,y,QPixmap(new_xpm));
        p.end();
    }

    setPixmap(thumbnail);
}

void CameraIconItem::showPixmapForMime()
{
    int iconSize;

    switch(mThumbnailSize.getSize()) {
    case ThumbnailSize::Small:
        //iconSize = KIcon::SizeSmall;
        iconSize = 32;
        break;
    case ThumbnailSize::Medium:
        //iconSize = KIcon::SizeMedium;
        iconSize = 48;
        break;
    default:
        //iconSize = KIcon::SizeLarge;
        iconSize = 64;
        break;
    }

    if (fileInfo()->getMime().contains("image"))
        setPixmap(BarIcon("image", iconSize));
    else if (fileInfo()->getMime().contains("audio") )
        setPixmap(BarIcon("sound", iconSize));
    else if (fileInfo()->getMime().contains("video"))
        setPixmap(BarIcon("video", iconSize));
    else
        setPixmap(BarIcon("document", iconSize));
}


void CameraIconItem::dropShadow(QPixmap& thumbnail)
{
    // paint a black rectangle around the thumbnail

    QPainter p;
    int x2 = thumbnail.width() - 1;
    int y2 = thumbnail.height() - 1;
    p.begin(&thumbnail);
    p.setPen( QColor( 48, 48, 48 ));
    p.drawLine( x2, 0, x2, y2 );
    p.drawLine( 0, y2, x2, y2 );
    p.setPen( QColor( 215, 215, 215 ));
    p.drawLine( 0, 0, x2, 0 );
    p.drawLine( 0, 0, 0, y2 );
    p.end();
}

void CameraIconItem::slot_deleteThis()
{
    delete this;
}
