#include <ksimpleconfig.h>
#include "camerasettings.h"

CameraSettings::CameraSettings()
{
    config = new KSimpleConfig("digikam_camerarc");
}

CameraSettings::~CameraSettings()
{
    delete config;
}

void CameraSettings::readSettings()
{
    config->setGroup("Camera");

    if (config->hasKey("Model"))
        mCameraModel = config->readEntry("Model");
    else
        mCameraModel = "";

    if (config->hasKey("Port"))
        mCameraPort = config->readEntry("Port");
    else
        mCameraPort = "None";

    if (config->hasKey("Path"))
        mCameraPath = config->readEntry("Path");
    else
        mCameraPath = "/";
}

void CameraSettings::saveSettings()
{
    config->setGroup("Camera");
    config->writeEntry("Model", mCameraModel);
    config->writeEntry("Port", mCameraPort);
    config->writeEntry("Path", mCameraPath);
    config->sync();
}
