#ifndef DIGIKAMVIEW_H
#define DIGIKAMVIEW_H


#include <qwidget.h>
#include <kfileitem.h>

#include "thumbnailsize.h"

class QGridLayout;
class QSplitter;
class QCustomEvent;
class QWidgetStack;
class QString;
class QColor;

class KDirLister;
class KURL;
class KListView;

class AlbumIconView;
class CameraIconView;
class AlbumFolderTree;
class CameraFolderTree;
class GeneralSettings;
class CameraSettings;

class DigikamView : public QWidget
{
    Q_OBJECT

public:

    DigikamView(QWidget *_parent);
    ~DigikamView();

    void applyGeneralSettings(const GeneralSettings& genSettings);
    void applyCameraSettings(const CameraSettings& camSettings);

    void setThumbnailSize(const ThumbnailSize& thumbSize);
    QString getWhatsShowing() const;

private:

    void setAlbumPath(const QString& albumPath);
    void setupConnections();
    void highlightListView(KListView* view);
    void unhighlightListView(KListView* view);

private:

    QGridLayout  *mLayout;
    QSplitter    *mSplitter;
    QSplitter    *mDirSplitter;
    QWidgetStack *mIconViewStack;

    QColor mHighlightColor;
    QColor mOrigColor;

    AlbumFolderTree  *mAlbumFolderTree;
    AlbumIconView    *mAlbumIconView;
    CameraFolderTree *mCameraFolderTree;
    CameraIconView   *mCameraIconView;
    KDirLister       *mDirLister;

    KURL mAlbumPath;
    KURL mCurrentDownloadAlbum;

    enum mIconViewStackID {
        AlbumIconViewID = 0,
        CameraIconViewID
    };

    ThumbnailSize mThumbnailSize;

    bool mCameraBusy;
    bool mAlbumBusy;
    QString mCameraLastMsg;
    int mCameraLastVal;
    QString mAlbumLastMsg;
    int mAlbumLastVal;

private slots:

    void slot_dirListerNewItems(const KFileItemList& _itemList);
    void slot_dirListerDeleteItem(KFileItem* _item);
    void slot_dirListerClear();
    void slot_dirListerCompleted();
    void slot_dirListerRefreshItems(const KFileItemList& _itemList);

    void slot_newURLSelected(const KURL& url);
    void slot_albumFolderTreeClicked();
    void slot_albumBusy(bool busy);
    void slot_albumProgress(int val);

    void slot_cameraFolderTreeClicked();
    void slot_cameraStatusMsg(const QString& msg);
    void slot_cameraProgress(int val);
    void slot_cameraBusy(bool busy);

    void slot_raisingIconView(int);

signals:

    void signal_cameraConnected(bool);
    void signal_statusMsg(const QString&);
    void signal_progress(int val);
    void signal_resetStatusBar();
    void signal_cameraBusy();
    void signal_cameraIdle();

public slots:

    void slot_hideFolders();
    void slot_hideCameraFolders();
    void slot_hideAlbumFolders();

    void slot_selectAll();
    void slot_selectNone();
    void slot_selectInvert();


    void slot_cameraConnect();
    void slot_cameraDisconnect();
    void slot_cameraDownload();
    void slot_cameraDownload(const QStringList& nameList,
                             const QStringList& folderList,
                             const QString& downloadDir);
    void slot_cameraDownloadAll();
    void slot_cameraDelete();
    void slot_cameraDeleteAll();
    void slot_cameraUpload();
    void slot_cameraCancel();
    void slot_cameraInfo();

    void slot_createNewAlbum();
    void slot_deleteAlbum();
    void slot_albumRegenerateThumbnails();
    void slot_albumPauseThumbnails();
    void slot_albumSlideShow();
    void slot_albumRefresh();

};

#endif
