#ifndef GPHOTO_CONTROLLER_H
#define GPHOTO_CONTROLLER_H

#include <qevent.h>
#include <qthread.h>
#include <qmutex.h>
#include <qobject.h>

#include "mtqueue.h"
#include "gphoto_commands.h"

class Gphoto_Interface;
class ThumbnailMT;
class ThumbnailSize;

class Gphoto_Controller : public QObject, public QThread {

    Q_OBJECT

public:

    Gphoto_Controller(QObject *_parent = 0);

    ~Gphoto_Controller();


    // Command Functions (rather Request Functions)

    void initializeCamera();

    void getSubFolders(const QString& folder);
    void makeFolder(const QString& folder, const QString& newFolder);
    void deleteFolder(const QString& folder);

    void getThumbnail(const QString& folder, const QString& imageName);

    void getImagesInfo(const QString& folder);

    void downloadImage(const QString& folder, const QString& imageName,
                       const QString& saveFileName);
    void deleteImage(const QString& folder, const QString& imageName);

    void openImage(const QString& folder, const QString& imageName);

    void uploadImage(const QString& folder, const QString& localImagePath,
                     const QString& uploadName);

    void getCameraInformation();

    void stopOperations();

    // Query Functions

    bool isCameraInitialised();
    bool cameraSupportsThumbNails();
    bool cameraSupportsDelete();
    bool cameraSupportsUpload();
    bool cameraSupportsMkDir();
    bool cameraSupportsDelDir();

    QString cameraModel() const;
    QString cameraPort() const;
    QString cameraGlobalPath() const;

private:

    Gphoto_Interface *gpInterface;
    QObject *parent;

    MTQueue<Gphoto_Command>* cmdQueue;
    QMutex mutex;

    bool globalExit;

    // Actual Command Functions

    void initializeCamera_Real();
    void getSubFolders_Real(const QString& folder);
    void getImagesInfo_Real(const QString& folder);
    void getThumbNail_Real(const QString& folder, const QString& imageName);
    void downloadImage_Real(const QString& folder, const QString& imageName,
                            const QString& saveFileName);
    void deleteImage_Real(const QString& folder, const QString& imageName);
    void openImage_Real(const QString& folder, const QString& imageName);
    void uploadImage_Real(const QString& folder, const QString& localImagePath,
                          const QString& uploadName);
    void getCameraInformation_Real();

    void showBusyStatus(bool _busy);

    void cacheThumbnails(const QString& folder,
                         const QString& imageName,
                         const QString& saveFileName);

private slots:

    void slot_cameraStatusMsg(const QString& msg);
    void slot_cameraProgressVal(int val);
    void slot_cameraErrorMsg(const QString& msg);

protected:

    virtual void run();


};


#endif
