#ifndef SETUPGENERAL_H
#define SETUPGENERAL_H

#include <qwidget.h>

class QCheckBox;
class QComboBox;
class QPushButton;
class QRadioButton;

class KIntNumInput;
class KColorButton;

class SetupGeneral : public QWidget
{
    Q_OBJECT

public:

    SetupGeneral( QWidget* parent = 0, const char* name = 0);
    ~SetupGeneral();

    void saveSettings();

private:

    QPushButton* mAlbumPathBrowseButton;
    QComboBox*   mAlbumPathBrowseComboBox;
    QRadioButton* mSmallIconSizeButton;
    QRadioButton* mMediumIconSizeButton;
    QRadioButton* mLargeIconSizeButton;
    KIntNumInput*  mSlideShowDelaySpinBox;
    QCheckBox* mSlideShowEffectCheckBox;
    QRadioButton* mSlideShowFileNameAtTop;
    QRadioButton* mSlideShowFileNameAtBottom;
    QRadioButton* mSlideShowFileNameOff;
    KColorButton* mColorButton;
    QCheckBox* mUseInternalImageViewer;
    QComboBox* mImageViewerName;

private:

    void loadSettings();

private slots:

    void slot_albumPathBrowse();
    void slot_imageViewerCheckBoxToggled(bool on);

};

#endif // SETUPGENERAL_H
